/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.index.lucene.query;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.query.qom.Constraint;
import javax.jcr.query.qom.DynamicOperand;
import javax.jcr.query.qom.Length;
import javax.jcr.query.qom.LowerCase;
import javax.jcr.query.qom.NodeLocalName;
import javax.jcr.query.qom.NodeName;
import javax.jcr.query.qom.Not;
import javax.jcr.query.qom.PropertyExistence;
import javax.jcr.query.qom.StaticOperand;
import javax.jcr.query.qom.UpperCase;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.LegacyNumericRangeQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.RegexpQuery;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrLexicon;
import org.modeshape.jcr.ModeShapeLexicon;
import org.modeshape.jcr.api.query.qom.Between;
import org.modeshape.jcr.api.query.qom.Cast;
import org.modeshape.jcr.api.query.qom.NodeDepth;
import org.modeshape.jcr.api.query.qom.NodePath;
import org.modeshape.jcr.api.query.qom.Operator;
import org.modeshape.jcr.api.value.DateTime;
import org.modeshape.jcr.index.lucene.FieldUtil;
import org.modeshape.jcr.index.lucene.LuceneConfig;
import org.modeshape.jcr.index.lucene.LuceneIndexException;
import org.modeshape.jcr.index.lucene.LuceneIndexProviderI18n;
import org.modeshape.jcr.index.lucene.query.CompareNameQuery;
import org.modeshape.jcr.index.lucene.query.ComparePathQuery;
import org.modeshape.jcr.index.lucene.query.CompareStringQuery;
import org.modeshape.jcr.index.lucene.query.FieldExistsQuery;
import org.modeshape.jcr.index.lucene.query.RelikeQuery;
import org.modeshape.jcr.query.engine.QueryUtil;
import org.modeshape.jcr.query.model.And;
import org.modeshape.jcr.query.model.BindVariableName;
import org.modeshape.jcr.query.model.Comparison;
import org.modeshape.jcr.query.model.FullTextSearch;
import org.modeshape.jcr.query.model.Literal;
import org.modeshape.jcr.query.model.Or;
import org.modeshape.jcr.query.model.PropertyValue;
import org.modeshape.jcr.query.model.ReferenceValue;
import org.modeshape.jcr.query.model.Relike;
import org.modeshape.jcr.query.model.SetCriteria;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.NameFactory;
import org.modeshape.jcr.value.Path;
import org.modeshape.jcr.value.PathFactory;
import org.modeshape.jcr.value.PropertyType;
import org.modeshape.jcr.value.StringFactory;
import org.modeshape.jcr.value.ValueFactories;

@ThreadSafe
@Immutable
public class LuceneQueryFactory {
    protected final PathFactory pathFactory;
    protected final NameFactory nameFactory;
    protected final StringFactory stringFactory;
    protected final Map<String, Object> variables;
    protected final ValueFactories factories;
    protected final Map<String, PropertyType> propertyTypesByName;

    private LuceneQueryFactory(ValueFactories factories, Map<String, Object> variables, Map<String, PropertyType> propertyTypesByName) {
        assert (factories != null);
        this.factories = factories;
        this.pathFactory = factories.getPathFactory();
        this.nameFactory = factories.getNameFactory();
        this.stringFactory = factories.getStringFactory();
        Map<String, Object> map = this.variables = variables != null ? variables : Collections.emptyMap();
        assert (propertyTypesByName != null);
        this.propertyTypesByName = propertyTypesByName;
    }

    public static LuceneQueryFactory forMultiColumnIndex(ValueFactories factories, Map<String, Object> variables, Map<String, PropertyType> propertyTypesByName) {
        return new LuceneQueryFactory(factories, variables, propertyTypesByName);
    }

    public static LuceneQueryFactory forSingleColumnIndex(ValueFactories factories, Map<String, Object> variables, Map<String, PropertyType> propertyTypesByName) {
        return new SingleColumnQueryFactory(factories, variables, propertyTypesByName);
    }

    public static LuceneQueryFactory forTextIndex(ValueFactories factories, Map<String, Object> variables, Map<String, PropertyType> propertyTypesByName, LuceneConfig config) {
        return new TextQueryFactory(factories, variables, propertyTypesByName, config);
    }

    public Query createQuery(Constraint constraint) {
        if (constraint instanceof And) {
            return this.createQuery((And)constraint);
        }
        if (constraint instanceof Or) {
            return this.createQuery((Or)constraint);
        }
        if (constraint instanceof Not) {
            return this.createQuery((Not)constraint);
        }
        if (constraint instanceof SetCriteria) {
            return this.createQuery((SetCriteria)constraint);
        }
        if (constraint instanceof PropertyExistence) {
            return this.createQuery((PropertyExistence)constraint);
        }
        if (constraint instanceof Between) {
            return this.createQuery((Between)constraint);
        }
        if (constraint instanceof Relike) {
            return this.createQuery((Relike)constraint);
        }
        if (constraint instanceof Comparison) {
            return this.createQuery((Comparison)constraint);
        }
        if (constraint instanceof FullTextSearch) {
            return this.createQuery((FullTextSearch)constraint);
        }
        throw new LuceneIndexException("Unexpected Constraint instance: class=" + (constraint != null ? constraint.getClass() : "null") + " and instance=" + constraint);
    }

    public boolean scoreDocuments() {
        return false;
    }

    protected Query createQuery(FullTextSearch constraint) {
        throw new UnsupportedOperationException("Only text indexes support FTS constraints...");
    }

    protected Query createQuery(Comparison comparison) {
        return this.createQuery((DynamicOperand)comparison.getOperand1(), comparison.operator(), (StaticOperand)comparison.getOperand2(), null);
    }

    protected Query createQuery(Not not) {
        return this.not(this.createQuery(not.getConstraint()));
    }

    protected Query createQuery(Relike relike) {
        org.modeshape.jcr.query.model.StaticOperand op1 = relike.getOperand1();
        PropertyValue op2 = relike.getOperand2();
        Object relikeValue = this.getSingleValueFromStaticOperand((StaticOperand)op1);
        assert (relikeValue != null);
        String fieldName = op2.getPropertyName();
        return new RelikeQuery(fieldName, relikeValue.toString());
    }

    protected Query createQuery(Between between) {
        DynamicOperand operand = between.getOperand();
        StaticOperand lower = between.getLowerBound();
        StaticOperand upper = between.getUpperBound();
        boolean upperBoundIncluded = between.isUpperBoundIncluded();
        boolean lowerBoundIncluded = between.isLowerBoundIncluded();
        Object lowerValue = this.getSingleValueFromStaticOperand(lower);
        Object upperValue = this.getSingleValueFromStaticOperand(upper);
        assert (lowerValue != null);
        assert (upperValue != null);
        if (operand instanceof NodeDepth) {
            return this.createRangeQuery(this.depthField(), lowerValue, upperValue, lowerBoundIncluded, upperBoundIncluded);
        }
        if (operand instanceof javax.jcr.query.qom.PropertyValue) {
            String field = ((javax.jcr.query.qom.PropertyValue)operand).getPropertyName();
            PropertyType lowerType = PropertyType.discoverType((Object)lowerValue);
            PropertyType upperType = PropertyType.discoverType((Object)upperValue);
            if (upperType == lowerType) {
                switch (upperType) {
                    case DATE: 
                    case LONG: 
                    case DOUBLE: 
                    case DECIMAL: {
                        return this.createRangeQuery(field, lowerValue, upperValue, lowerBoundIncluded, upperBoundIncluded);
                    }
                }
            }
        }
        Operator lowerOp = lowerBoundIncluded ? Operator.GREATER_THAN_OR_EQUAL_TO : Operator.GREATER_THAN;
        Operator upperOp = upperBoundIncluded ? Operator.LESS_THAN_OR_EQUAL_TO : Operator.LESS_THAN;
        Query lowerQuery = this.createQuery(operand, lowerOp, lower, null);
        Query upperQuery = this.createQuery(operand, upperOp, upper, null);
        return this.booleanQuery(lowerQuery, BooleanClause.Occur.MUST, upperQuery, BooleanClause.Occur.MUST);
    }

    protected Query createRangeQuery(String field, Object lowerValue, Object upperValue, boolean includesLower, boolean includesUpper) {
        PropertyType upperType;
        PropertyType type = null;
        PropertyType lowerType = PropertyType.discoverType((Object)lowerValue);
        if (lowerType != (upperType = PropertyType.discoverType((Object)upperValue))) {
            return new MatchNoDocsQuery();
        }
        type = lowerType;
        switch (type) {
            case DATE: {
                long lowerDate = (Long)this.factories.getLongFactory().create(lowerValue);
                long upperDate = (Long)this.factories.getLongFactory().create(upperValue);
                return LegacyNumericRangeQuery.newLongRange((String)field, (Long)lowerDate, (Long)upperDate, (boolean)includesLower, (boolean)includesUpper);
            }
            case LONG: {
                long lowerLong = (Long)this.factories.getLongFactory().create(lowerValue);
                long upperLong = (Long)this.factories.getLongFactory().create(upperValue);
                return LegacyNumericRangeQuery.newLongRange((String)field, (Long)lowerLong, (Long)upperLong, (boolean)includesLower, (boolean)includesUpper);
            }
            case DOUBLE: {
                double lowerDouble = (Double)this.factories.getDoubleFactory().create(lowerValue);
                double upperDouble = (Double)this.factories.getDoubleFactory().create(upperValue);
                return LegacyNumericRangeQuery.newDoubleRange((String)field, (Double)lowerDouble, (Double)upperDouble, (boolean)includesLower, (boolean)includesUpper);
            }
            case BOOLEAN: {
                int lowerInt = (Boolean)this.factories.getBooleanFactory().create(lowerValue) != false ? 1 : 0;
                int upperInt = (Boolean)this.factories.getBooleanFactory().create(upperValue) != false ? 1 : 0;
                return LegacyNumericRangeQuery.newIntRange((String)field, (Integer)lowerInt, (Integer)upperInt, (boolean)includesLower, (boolean)includesUpper);
            }
            case DECIMAL: {
                BigDecimal lowerDecimal = (BigDecimal)this.factories.getDecimalFactory().create(lowerValue);
                BigDecimal upperDecimal = (BigDecimal)this.factories.getDecimalFactory().create(upperValue);
                String lsv = FieldUtil.decimalToString(lowerDecimal);
                String usv = FieldUtil.decimalToString(upperDecimal);
                Query lower = null;
                lower = includesLower ? CompareStringQuery.createQueryForNodesWithFieldGreaterThanOrEqualTo(lsv, field, null) : CompareStringQuery.createQueryForNodesWithFieldGreaterThan(lsv, field, null);
                Query upper = null;
                upper = includesUpper ? CompareStringQuery.createQueryForNodesWithFieldLessThanOrEqualTo(usv, field, null) : CompareStringQuery.createQueryForNodesWithFieldLessThan(usv, field, null);
                return this.booleanQuery(lower, BooleanClause.Occur.MUST, upper, BooleanClause.Occur.MUST);
            }
            case OBJECT: 
            case URI: 
            case PATH: 
            case NAME: 
            case STRING: 
            case REFERENCE: 
            case WEAKREFERENCE: 
            case SIMPLEREFERENCE: 
            case BINARY: {
                throw new LuceneIndexException("Unsupported type for range query:" + type);
            }
        }
        return new MatchNoDocsQuery();
    }

    protected Query createQuery(SetCriteria setCriteria) {
        StaticOperand rightOperand;
        org.modeshape.jcr.query.model.DynamicOperand left = setCriteria.leftOperand();
        int numRightOperands = setCriteria.rightOperands().size();
        assert (numRightOperands > 0);
        if (numRightOperands == 1 && (rightOperand = (StaticOperand)setCriteria.rightOperands().iterator().next()) instanceof Literal) {
            return this.createQuery((DynamicOperand)left, Operator.EQUAL_TO, (StaticOperand)setCriteria.rightOperands().iterator().next(), null);
        }
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        builder.setDisableCoord(true);
        for (StaticOperand right : setCriteria.rightOperands()) {
            if (right instanceof BindVariableName) {
                BindVariableName var = (BindVariableName)right;
                String bindVariableName = var.getBindVariableName();
                Object value = this.variables.get(bindVariableName);
                if (value == null) {
                    if (bindVariableName.startsWith("__mode:subquery")) {
                        return new MatchAllDocsQuery();
                    }
                    throw new LuceneIndexException(JcrI18n.missingVariableValue.text(new Object[]{bindVariableName}));
                }
                if (value instanceof Iterable) {
                    for (Object resolvedValue : (Iterable)value) {
                        if (resolvedValue == null) continue;
                        if (resolvedValue instanceof Object[]) {
                            for (Object val : (Object[])resolvedValue) {
                                this.addQueryForSetConstraint(builder, (DynamicOperand)left, val);
                            }
                            continue;
                        }
                        this.addQueryForSetConstraint(builder, (DynamicOperand)left, resolvedValue);
                    }
                    continue;
                }
                this.addQueryForSetConstraint(builder, (DynamicOperand)left, value);
                continue;
            }
            Query rightQuery = this.createQuery((DynamicOperand)left, Operator.EQUAL_TO, right, null);
            builder.add(rightQuery, BooleanClause.Occur.SHOULD);
        }
        return builder.build();
    }

    private Query createQuery(Or or) {
        Query leftQuery = this.createQuery((Constraint)or.left());
        Query rightQuery = this.createQuery((Constraint)or.right());
        if (leftQuery == null) {
            return rightQuery != null ? rightQuery : null;
        }
        if (rightQuery == null) {
            return leftQuery;
        }
        return this.booleanQuery(leftQuery, BooleanClause.Occur.SHOULD, rightQuery, BooleanClause.Occur.SHOULD);
    }

    protected Query createQuery(And and) {
        Query leftQuery = this.createQuery((Constraint)and.left());
        Query rightQuery = this.createQuery((Constraint)and.right());
        if (leftQuery == null || rightQuery == null) {
            return null;
        }
        return this.booleanQuery(leftQuery, BooleanClause.Occur.MUST, rightQuery, BooleanClause.Occur.MUST);
    }

    protected Query createQuery(PropertyExistence propertyExistence) {
        String field = propertyExistence.getPropertyName();
        assert (this.propertyTypesByName.containsKey(field));
        return new FieldExistsQuery(field);
    }

    private void addQueryForSetConstraint(BooleanQuery.Builder setQueryBuilder, DynamicOperand left, Object resolvedValue) {
        Literal elementInRight = resolvedValue instanceof Literal ? (Literal)resolvedValue : new Literal(resolvedValue);
        Query rightQuery = this.createQuery(left, Operator.EQUAL_TO, (StaticOperand)elementInRight, null);
        setQueryBuilder.add(rightQuery, BooleanClause.Occur.SHOULD);
    }

    protected Query createQuery(DynamicOperand left, Operator operator, StaticOperand right, Function<String, String> caseOperation) {
        Object value = this.getSingleValueFromStaticOperand(right);
        assert (value != null);
        if (left instanceof javax.jcr.query.qom.PropertyValue) {
            return this.createPropertyValueQuery((javax.jcr.query.qom.PropertyValue)left, operator, value, caseOperation);
        }
        if (left instanceof ReferenceValue) {
            return this.createReferenceValueQuery((ReferenceValue)left, operator, value);
        }
        if (left instanceof Length) {
            return this.createLengthQuery((Length)left, operator, value);
        }
        if (left instanceof LowerCase) {
            LowerCase lowercase = (LowerCase)left;
            return this.createQuery(lowercase.getOperand(), operator, right, String::toLowerCase);
        }
        if (left instanceof UpperCase) {
            UpperCase uppercase = (UpperCase)left;
            return this.createQuery(uppercase.getOperand(), operator, right, String::toUpperCase);
        }
        if (left instanceof NodeDepth) {
            return this.longFieldQuery(this.depthField(), operator, value);
        }
        if (left instanceof NodePath) {
            String field = (String)this.stringFactory.create(JcrLexicon.PATH);
            return this.pathFieldQuery(field, operator, value, caseOperation);
        }
        if (left instanceof NodeName) {
            String field = (String)this.stringFactory.create(JcrLexicon.NAME);
            return this.nameFieldQuery(field, operator, value, caseOperation);
        }
        if (left instanceof NodeLocalName) {
            String field = (String)this.stringFactory.create(ModeShapeLexicon.LOCALNAME);
            return this.stringFieldQuery(field, operator, value, caseOperation);
        }
        if (left instanceof Cast) {
            Cast cast = (Cast)left;
            return this.createQuery(cast.getOperand(), operator, right, caseOperation);
        }
        throw new LuceneIndexException("Unexpected DynamicOperand instance: class=" + (left != null ? left.getClass() : "null") + " and instance=" + left);
    }

    private String depthField() {
        return (String)this.stringFactory.create(ModeShapeLexicon.DEPTH);
    }

    protected Object getSingleValueFromStaticOperand(StaticOperand operand) {
        Object value = null;
        if (operand instanceof Literal) {
            Literal literal = (Literal)operand;
            value = literal.value();
        } else if (operand instanceof BindVariableName) {
            BindVariableName variable = (BindVariableName)operand;
            String variableName = variable.getBindVariableName();
            value = this.variables.get(variableName);
            if (value instanceof Iterable) {
                Iterator iter = ((Iterable)value).iterator();
                if (iter.hasNext()) {
                    return iter.next();
                }
                value = null;
            }
            if (value == null) {
                throw new LuceneIndexException(JcrI18n.missingVariableValue.text(new Object[]{variableName}));
            }
        } else {
            throw new IllegalArgumentException("Unknown operand type:" + operand);
        }
        return value;
    }

    protected BooleanQuery not(Query notted) {
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        builder.setDisableCoord(true);
        builder.add((Query)new MatchAllDocsQuery(), BooleanClause.Occur.SHOULD);
        builder.add(notted, BooleanClause.Occur.MUST_NOT);
        return builder.build();
    }

    protected Query createPropertyValueQuery(javax.jcr.query.qom.PropertyValue propertyValue, Operator operator, Object value, Function<String, String> caseOperation) {
        String stringValue;
        if (!(operator != Operator.LIKE || (stringValue = (String)this.stringFactory.create(value)).contains("%") || stringValue.contains("_") || stringValue.contains("\\"))) {
            operator = Operator.EQUAL_TO;
        }
        String propertyName = propertyValue.getPropertyName();
        PropertyType valueType = this.propertyTypesByName.get(propertyName);
        switch (valueType) {
            case REFERENCE: 
            case WEAKREFERENCE: 
            case SIMPLEREFERENCE: {
                return this.stringFieldQuery(propertyName, operator, value, null);
            }
            case URI: 
            case STRING: {
                return this.stringFieldQuery(propertyName, operator, value, caseOperation);
            }
            case PATH: {
                return this.pathFieldQuery(propertyName, operator, value, caseOperation);
            }
            case NAME: {
                return this.nameFieldQuery(propertyName, operator, value, caseOperation);
            }
            case DECIMAL: {
                return this.decimalFieldQuery(propertyName, operator, value, caseOperation);
            }
            case DATE: {
                return this.dateFieldQuery(propertyName, operator, value);
            }
            case LONG: {
                return this.longFieldQuery(propertyName, operator, value);
            }
            case BOOLEAN: {
                return this.booleanFieldQuery(propertyName, operator, value);
            }
            case DOUBLE: {
                return this.doubleFieldQuery(propertyName, operator, value);
            }
        }
        throw new IllegalArgumentException("Unsupported value type:" + valueType);
    }

    protected Query stringFieldQuery(String field, Operator operator, Object value, Function<String, String> caseOperation) {
        String stringValue = (String)this.stringFactory.create(value);
        switch (operator) {
            case EQUAL_TO: {
                return CompareStringQuery.createQueryForNodesWithFieldEqualTo(stringValue, field, caseOperation);
            }
            case NOT_EQUAL_TO: {
                Query query = CompareStringQuery.createQueryForNodesWithFieldEqualTo(stringValue, field, caseOperation);
                return this.not(query);
            }
            case GREATER_THAN: {
                return CompareStringQuery.createQueryForNodesWithFieldGreaterThan(stringValue, field, caseOperation);
            }
            case GREATER_THAN_OR_EQUAL_TO: {
                return CompareStringQuery.createQueryForNodesWithFieldGreaterThanOrEqualTo(stringValue, field, caseOperation);
            }
            case LESS_THAN: {
                return CompareStringQuery.createQueryForNodesWithFieldLessThan(stringValue, field, caseOperation);
            }
            case LESS_THAN_OR_EQUAL_TO: {
                return CompareStringQuery.createQueryForNodesWithFieldLessThanOrEqualTo(stringValue, field, caseOperation);
            }
            case LIKE: {
                return CompareStringQuery.createQueryForNodesWithFieldLike(stringValue, field, caseOperation);
            }
        }
        throw new IllegalArgumentException("Unknown operator:" + operator);
    }

    protected Query decimalFieldQuery(String field, Operator operator, Object value, Function<String, String> caseOperation) {
        String decimalString = null;
        if (operator != Operator.LIKE) {
            BigDecimal decimalValue = (BigDecimal)this.factories.getDecimalFactory().create(value);
            decimalString = FieldUtil.decimalToString(decimalValue);
        } else {
            decimalString = (String)this.stringFactory.create(value);
        }
        return this.stringFieldQuery(field, operator, decimalString, caseOperation);
    }

    protected Query booleanFieldQuery(String field, Operator operator, Object value) {
        Boolean booleanValue = (Boolean)this.factories.getBooleanFactory().create(value);
        if (booleanValue.booleanValue()) {
            switch (operator) {
                case EQUAL_TO: {
                    return LegacyNumericRangeQuery.newIntRange((String)field, (Integer)0, (Integer)1, (boolean)false, (boolean)true);
                }
                case NOT_EQUAL_TO: {
                    return LegacyNumericRangeQuery.newIntRange((String)field, (Integer)0, (Integer)1, (boolean)true, (boolean)false);
                }
                case GREATER_THAN_OR_EQUAL_TO: {
                    return LegacyNumericRangeQuery.newIntRange((String)field, (Integer)1, (Integer)1, (boolean)true, (boolean)true);
                }
                case LESS_THAN_OR_EQUAL_TO: {
                    return LegacyNumericRangeQuery.newIntRange((String)field, (Integer)0, (Integer)1, (boolean)true, (boolean)true);
                }
                case GREATER_THAN: {
                    return new MatchNoDocsQuery();
                }
                case LESS_THAN: {
                    return LegacyNumericRangeQuery.newIntRange((String)field, (Integer)0, (Integer)0, (boolean)true, (boolean)true);
                }
                case LIKE: {
                    throw new LuceneIndexException(LuceneIndexProviderI18n.invalidOperatorForPropertyType.text(new Object[]{Operator.LIKE, PropertyType.BOOLEAN}));
                }
            }
            throw new IllegalArgumentException("Unknown operator:" + operator);
        }
        switch (operator) {
            case EQUAL_TO: {
                return LegacyNumericRangeQuery.newIntRange((String)field, (Integer)0, (Integer)1, (boolean)true, (boolean)false);
            }
            case NOT_EQUAL_TO: {
                return LegacyNumericRangeQuery.newIntRange((String)field, (Integer)0, (Integer)1, (boolean)false, (boolean)true);
            }
            case GREATER_THAN_OR_EQUAL_TO: {
                return LegacyNumericRangeQuery.newIntRange((String)field, (Integer)0, (Integer)1, (boolean)true, (boolean)true);
            }
            case LESS_THAN_OR_EQUAL_TO: {
                return LegacyNumericRangeQuery.newIntRange((String)field, (Integer)0, (Integer)0, (boolean)true, (boolean)true);
            }
            case GREATER_THAN: {
                return LegacyNumericRangeQuery.newIntRange((String)field, (Integer)1, (Integer)1, (boolean)true, (boolean)true);
            }
            case LESS_THAN: {
                return new MatchNoDocsQuery();
            }
            case LIKE: {
                throw new LuceneIndexException(LuceneIndexProviderI18n.invalidOperatorForPropertyType.text(new Object[]{Operator.LIKE, PropertyType.BOOLEAN}));
            }
        }
        throw new IllegalArgumentException("Unknown operator:" + operator);
    }

    protected Query longFieldQuery(String field, Operator operator, Object value) {
        Long longMinimum = Long.MIN_VALUE;
        Long longMaximum = Long.MAX_VALUE;
        long longValue = (Long)this.factories.getLongFactory().create(value);
        switch (operator) {
            case EQUAL_TO: {
                if (longValue < longMinimum || longValue > longMaximum) {
                    return new MatchNoDocsQuery();
                }
                return LegacyNumericRangeQuery.newLongRange((String)field, (Long)longValue, (Long)longValue, (boolean)true, (boolean)true);
            }
            case NOT_EQUAL_TO: {
                if (longValue < longMinimum || longValue > longMaximum) {
                    return new MatchAllDocsQuery();
                }
                LegacyNumericRangeQuery lowerRange = LegacyNumericRangeQuery.newLongRange((String)field, (Long)longMinimum, (Long)longValue, (boolean)true, (boolean)false);
                LegacyNumericRangeQuery upperRange = LegacyNumericRangeQuery.newLongRange((String)field, (Long)longValue, (Long)longMaximum, (boolean)false, (boolean)true);
                return this.booleanQuery((Query)lowerRange, BooleanClause.Occur.SHOULD, (Query)upperRange, BooleanClause.Occur.SHOULD);
            }
            case GREATER_THAN: {
                if (longValue > longMaximum) {
                    return new MatchNoDocsQuery();
                }
                return LegacyNumericRangeQuery.newLongRange((String)field, (Long)longValue, (Long)longMaximum, (boolean)false, (boolean)true);
            }
            case GREATER_THAN_OR_EQUAL_TO: {
                if (longValue > longMaximum) {
                    return new MatchNoDocsQuery();
                }
                return LegacyNumericRangeQuery.newLongRange((String)field, (Long)longValue, (Long)longMaximum, (boolean)true, (boolean)true);
            }
            case LESS_THAN: {
                if (longValue < longMinimum) {
                    return new MatchNoDocsQuery();
                }
                return LegacyNumericRangeQuery.newLongRange((String)field, (Long)longMinimum, (Long)longValue, (boolean)true, (boolean)false);
            }
            case LESS_THAN_OR_EQUAL_TO: {
                if (longValue < longMinimum) {
                    return new MatchNoDocsQuery();
                }
                return LegacyNumericRangeQuery.newLongRange((String)field, (Long)longMinimum, (Long)longValue, (boolean)true, (boolean)true);
            }
            case LIKE: {
                throw new LuceneIndexException(LuceneIndexProviderI18n.invalidOperatorForPropertyType.text(new Object[]{operator, PropertyType.LONG}));
            }
        }
        throw new IllegalArgumentException("Unknown operator:" + operator);
    }

    protected Query doubleFieldQuery(String field, Operator operator, Object value) {
        double doubleValue = (Double)this.factories.getDoubleFactory().create(value);
        Double doubleMinimum = Double.MIN_VALUE;
        Double doubleMaximum = Double.MAX_VALUE;
        switch (operator) {
            case EQUAL_TO: {
                if (doubleValue < doubleMinimum || doubleValue > doubleMaximum) {
                    return new MatchNoDocsQuery();
                }
                return LegacyNumericRangeQuery.newDoubleRange((String)field, (Double)doubleValue, (Double)doubleValue, (boolean)true, (boolean)true);
            }
            case NOT_EQUAL_TO: {
                if (doubleValue < doubleMinimum || doubleValue > doubleMaximum) {
                    return new MatchAllDocsQuery();
                }
                LegacyNumericRangeQuery lowerRange = LegacyNumericRangeQuery.newDoubleRange((String)field, (Double)doubleMinimum, (Double)doubleValue, (boolean)true, (boolean)false);
                LegacyNumericRangeQuery upperRange = LegacyNumericRangeQuery.newDoubleRange((String)field, (Double)doubleValue, (Double)doubleMaximum, (boolean)false, (boolean)true);
                return this.booleanQuery((Query)lowerRange, BooleanClause.Occur.SHOULD, (Query)upperRange, BooleanClause.Occur.SHOULD);
            }
            case GREATER_THAN: {
                if (doubleValue > doubleMaximum) {
                    return new MatchNoDocsQuery();
                }
                return LegacyNumericRangeQuery.newDoubleRange((String)field, (Double)doubleValue, (Double)doubleMaximum, (boolean)false, (boolean)true);
            }
            case GREATER_THAN_OR_EQUAL_TO: {
                if (doubleValue > doubleMaximum) {
                    return new MatchNoDocsQuery();
                }
                return LegacyNumericRangeQuery.newDoubleRange((String)field, (Double)doubleValue, (Double)doubleMaximum, (boolean)true, (boolean)true);
            }
            case LESS_THAN: {
                if (doubleValue < doubleMinimum) {
                    return new MatchNoDocsQuery();
                }
                return LegacyNumericRangeQuery.newDoubleRange((String)field, (Double)doubleMinimum, (Double)doubleValue, (boolean)true, (boolean)false);
            }
            case LESS_THAN_OR_EQUAL_TO: {
                if (doubleValue < doubleMinimum) {
                    return new MatchNoDocsQuery();
                }
                return LegacyNumericRangeQuery.newDoubleRange((String)field, (Double)doubleMinimum, (Double)doubleValue, (boolean)true, (boolean)true);
            }
            case LIKE: {
                assert (false);
                break;
            }
        }
        throw new IllegalArgumentException("Unknown operator:" + operator);
    }

    protected Query dateFieldQuery(String field, Operator operator, Object value) {
        Long longMinimum = Long.MIN_VALUE;
        Long longMaximum = Long.MAX_VALUE;
        long millis = ((DateTime)this.factories.getDateFactory().create(value)).getMilliseconds();
        switch (operator) {
            case EQUAL_TO: {
                if (millis < longMinimum || millis > longMaximum) {
                    return new MatchNoDocsQuery();
                }
                return LegacyNumericRangeQuery.newLongRange((String)field, (Long)millis, (Long)millis, (boolean)true, (boolean)true);
            }
            case NOT_EQUAL_TO: {
                if (millis < longMinimum || millis > longMaximum) {
                    return new MatchAllDocsQuery();
                }
                LegacyNumericRangeQuery lowerRange = LegacyNumericRangeQuery.newLongRange((String)field, (Long)longMinimum, (Long)millis, (boolean)true, (boolean)false);
                LegacyNumericRangeQuery upperRange = LegacyNumericRangeQuery.newLongRange((String)field, (Long)millis, (Long)longMaximum, (boolean)false, (boolean)true);
                return this.booleanQuery((Query)lowerRange, BooleanClause.Occur.SHOULD, (Query)upperRange, BooleanClause.Occur.SHOULD);
            }
            case GREATER_THAN: {
                if (millis > longMaximum) {
                    return new MatchNoDocsQuery();
                }
                return LegacyNumericRangeQuery.newLongRange((String)field, (Long)millis, (Long)longMaximum, (boolean)false, (boolean)true);
            }
            case GREATER_THAN_OR_EQUAL_TO: {
                if (millis > longMaximum) {
                    return new MatchNoDocsQuery();
                }
                return LegacyNumericRangeQuery.newLongRange((String)field, (Long)millis, (Long)longMaximum, (boolean)true, (boolean)true);
            }
            case LESS_THAN: {
                if (millis < longMinimum) {
                    return new MatchNoDocsQuery();
                }
                return LegacyNumericRangeQuery.newLongRange((String)field, (Long)longMinimum, (Long)millis, (boolean)true, (boolean)false);
            }
            case LESS_THAN_OR_EQUAL_TO: {
                if (millis < longMinimum) {
                    return new MatchNoDocsQuery();
                }
                return LegacyNumericRangeQuery.newLongRange((String)field, (Long)longMinimum, (Long)millis, (boolean)true, (boolean)true);
            }
            case LIKE: {
                assert (false);
                break;
            }
        }
        throw new IllegalArgumentException("Unknown operator:" + operator);
    }

    protected Query createReferenceValueQuery(ReferenceValue referenceValue, Operator operator, Object value) {
        String field = referenceValue.getPropertyName();
        if (field != null) {
            return this.stringFieldQuery(field, operator, value, null);
        }
        List<String> referenceFields = this.collectReferenceFieldNames(referenceValue);
        assert (!referenceFields.isEmpty());
        if (referenceFields.size() == 1) {
            return this.stringFieldQuery(referenceFields.get(0), operator, value, null);
        }
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        builder.setDisableCoord(true);
        for (String fieldName : referenceFields) {
            Query fieldQuery = this.stringFieldQuery(fieldName, operator, value, null);
            builder.add(fieldQuery, BooleanClause.Occur.SHOULD);
        }
        return builder.build();
    }

    protected List<String> collectReferenceFieldNames(ReferenceValue referenceValue) {
        ArrayList<String> result = new ArrayList<String>();
        boolean includeWeakReferences = referenceValue.includesWeakReferences();
        boolean includeSimpleReferences = referenceValue.includeSimpleReferences();
        for (Map.Entry<String, PropertyType> propertyEntry : this.propertyTypesByName.entrySet()) {
            PropertyType propertyType = propertyEntry.getValue();
            switch (propertyType) {
                case WEAKREFERENCE: {
                    if (!includeWeakReferences) break;
                    result.add(propertyEntry.getKey());
                    break;
                }
                case SIMPLEREFERENCE: {
                    if (!includeSimpleReferences) break;
                    result.add(propertyEntry.getKey());
                    break;
                }
                case REFERENCE: {
                    result.add(propertyEntry.getKey());
                }
            }
        }
        return result;
    }

    protected Query createLengthQuery(Length propertyLength, Operator operator, Object value) {
        assert (propertyLength != null);
        assert (value != null);
        long length = (Long)this.factories.getLongFactory().create(value);
        if (length <= 0L) {
            return new MatchNoDocsQuery();
        }
        String field = FieldUtil.lengthField(propertyLength.getPropertyValue().getPropertyName());
        switch (operator) {
            case EQUAL_TO: {
                return LegacyNumericRangeQuery.newLongRange((String)field, (Long)length, (Long)length, (boolean)true, (boolean)true);
            }
            case NOT_EQUAL_TO: {
                LegacyNumericRangeQuery upper = LegacyNumericRangeQuery.newLongRange((String)field, (Long)length, (Long)Long.MAX_VALUE, (boolean)false, (boolean)false);
                LegacyNumericRangeQuery lower = LegacyNumericRangeQuery.newLongRange((String)field, (Long)0L, (Long)length, (boolean)true, (boolean)false);
                return this.booleanQuery((Query)upper, BooleanClause.Occur.SHOULD, (Query)lower, BooleanClause.Occur.SHOULD);
            }
            case GREATER_THAN: {
                return LegacyNumericRangeQuery.newLongRange((String)field, (Long)length, (Long)Long.MAX_VALUE, (boolean)false, (boolean)false);
            }
            case GREATER_THAN_OR_EQUAL_TO: {
                return LegacyNumericRangeQuery.newLongRange((String)field, (Long)length, (Long)Long.MAX_VALUE, (boolean)true, (boolean)false);
            }
            case LESS_THAN: {
                return LegacyNumericRangeQuery.newLongRange((String)field, (Long)0L, (Long)length, (boolean)true, (boolean)false);
            }
            case LESS_THAN_OR_EQUAL_TO: {
                return LegacyNumericRangeQuery.newLongRange((String)field, (Long)0L, (Long)length, (boolean)true, (boolean)true);
            }
            case LIKE: {
                throw new LuceneIndexException(LuceneIndexProviderI18n.invalidOperatorForOperand.text(new Object[]{operator, propertyLength}));
            }
        }
        throw new IllegalArgumentException("Unknown operator:" + operator);
    }

    protected Query pathFieldQuery(String field, Operator operator, Object value, Function<String, String> caseOperation) {
        Path path = null;
        if (operator != Operator.LIKE) {
            path = !(value instanceof Path) ? (Path)this.pathFactory.create(value) : (Path)value;
        }
        switch (operator) {
            case EQUAL_TO: {
                return CompareStringQuery.createQueryForNodesWithFieldEqualTo((String)this.stringFactory.create(path), field, caseOperation);
            }
            case NOT_EQUAL_TO: {
                return this.not(CompareStringQuery.createQueryForNodesWithFieldEqualTo((String)this.stringFactory.create(path), field, caseOperation));
            }
            case LIKE: {
                String likeExpression = (String)this.stringFactory.create(value);
                likeExpression = likeExpression.replaceAll("\\[1\\]", "");
                if (likeExpression.contains("[%]")) {
                    String regex = likeExpression;
                    regex = regex.replace("[%]", "(\\[[0-9]+\\])?");
                    regex = regex.replaceAll("\\[\\d+\\]", "\\[[0-9]+\\]");
                    regex = regex.replace("*", ".*");
                    regex = regex.replace("%", ".*").replace("_", ".");
                    int flags = caseOperation == null ? 0 : 2;
                    return new RegexpQuery(new Term(field, regex), flags);
                }
                return CompareStringQuery.createQueryForNodesWithFieldLike(likeExpression, field, caseOperation);
            }
            case GREATER_THAN: {
                return ComparePathQuery.createQueryForNodesWithPathGreaterThan(path, field, this.factories, caseOperation);
            }
            case GREATER_THAN_OR_EQUAL_TO: {
                return ComparePathQuery.createQueryForNodesWithPathGreaterThanOrEqualTo(path, field, this.factories, caseOperation);
            }
            case LESS_THAN: {
                return ComparePathQuery.createQueryForNodesWithPathLessThan(path, field, this.factories, caseOperation);
            }
            case LESS_THAN_OR_EQUAL_TO: {
                return ComparePathQuery.createQueryForNodesWithPathLessThanOrEqualTo(path, field, this.factories, caseOperation);
            }
        }
        throw new IllegalArgumentException("Unknown operator:" + operator);
    }

    protected Query nameFieldQuery(String field, Operator operator, Object value, Function<String, String> caseOperation) {
        Name name = null;
        if (operator != Operator.LIKE) {
            name = !(value instanceof Name) ? (Name)this.factories.getNameFactory().create(value) : (Name)value;
        }
        switch (operator) {
            case EQUAL_TO: {
                return CompareNameQuery.createQueryForNodesWithNameEqualTo(name, field, this.factories, caseOperation);
            }
            case NOT_EQUAL_TO: {
                Query equalToQuery = CompareNameQuery.createQueryForNodesWithNameEqualTo(name, field, this.factories, caseOperation);
                return this.not(equalToQuery);
            }
            case GREATER_THAN: {
                return CompareNameQuery.createQueryForNodesWithNameGreaterThan(name, field, this.factories, caseOperation);
            }
            case GREATER_THAN_OR_EQUAL_TO: {
                return CompareNameQuery.createQueryForNodesWithNameGreaterThanOrEqualTo(name, field, this.factories, caseOperation);
            }
            case LESS_THAN: {
                return CompareNameQuery.createQueryForNodesWithNameLessThan(name, field, this.factories, caseOperation);
            }
            case LESS_THAN_OR_EQUAL_TO: {
                return CompareNameQuery.createQueryForNodesWithNameLessThanOrEqualTo(name, field, this.factories, caseOperation);
            }
            case LIKE: {
                String likeExpression = (String)this.stringFactory.create(value);
                return CompareStringQuery.createQueryForNodesWithFieldLike(likeExpression, field, caseOperation);
            }
        }
        throw new IllegalArgumentException("Unknown operator:" + operator);
    }

    protected BooleanQuery booleanQuery(Query leftQuery, BooleanClause.Occur leftOccur, Query rightQuery, BooleanClause.Occur rightOccur) {
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        builder.setDisableCoord(true);
        builder.add(leftQuery, leftOccur);
        builder.add(rightQuery, rightOccur);
        return builder.build();
    }

    protected static class TextQueryFactory
    extends SingleColumnQueryFactory {
        private static final PhraseQuery EMPTY_PHRASE_QUERY = new PhraseQuery.Builder().build();
        private final Analyzer analyzer;

        private TextQueryFactory(ValueFactories factories, Map<String, Object> variables, Map<String, PropertyType> propertyTypesByName, LuceneConfig config) {
            super(factories, variables, propertyTypesByName);
            this.analyzer = config.getAnalyzer();
        }

        @Override
        public boolean scoreDocuments() {
            return true;
        }

        @Override
        protected Query createQuery(FullTextSearch search) {
            String propertyName = search.getPropertyName();
            if (propertyName == null) {
                propertyName = this.propertyName();
            }
            org.modeshape.jcr.query.model.StaticOperand expression = search.getFullTextSearchExpression();
            Object value = this.getSingleValueFromStaticOperand((StaticOperand)expression);
            try {
                String valueString = value instanceof Value ? ((Value)value).getString() : (String)this.stringFactory.create(value);
                search = search.withFullTextExpression(valueString);
                return this.createQuery(propertyName, search.getTerm());
            }
            catch (RepositoryException e) {
                throw new LuceneIndexException(e);
            }
        }

        protected Query createQuery(String fieldName, FullTextSearch.Term term) {
            assert (fieldName != null);
            if (term instanceof FullTextSearch.Conjunction) {
                return this.createConjunctionQuery(fieldName, (FullTextSearch.Conjunction)term);
            }
            if (term instanceof FullTextSearch.Disjunction) {
                return this.createDisjunctionQuery(fieldName, (FullTextSearch.Disjunction)term);
            }
            if (term instanceof FullTextSearch.SimpleTerm) {
                return this.createSimpleTermQuery(fieldName, (FullTextSearch.SimpleTerm)term);
            }
            if (term instanceof FullTextSearch.NegationTerm) {
                return this.createNegationTermQuery(fieldName, (FullTextSearch.NegationTerm)term);
            }
            throw new IllegalArgumentException("Unknown term instance:" + term);
        }

        private Query createNegationTermQuery(String fieldName, FullTextSearch.NegationTerm negation) {
            BooleanQuery.Builder builder = new BooleanQuery.Builder();
            builder.setDisableCoord(true);
            Query subQuery = this.createQuery(fieldName, negation.getNegatedTerm());
            if (!EMPTY_PHRASE_QUERY.equals((Object)subQuery)) {
                builder.add(subQuery, BooleanClause.Occur.MUST_NOT);
                builder.add((Query)new MatchAllDocsQuery(), BooleanClause.Occur.FILTER);
                return builder.build();
            }
            return new MatchAllDocsQuery();
        }

        private Query createSimpleTermQuery(String fieldName, FullTextSearch.SimpleTerm simple) {
            try {
                if (QueryUtil.hasWildcardCharacters((String)simple.getValue())) {
                    return this.createWildcardQuery(fieldName, simple);
                }
                PhraseQuery.Builder builder = new PhraseQuery.Builder();
                builder.setSlop(0);
                String expression = simple.getValue();
                try (TokenStream stream = this.analyzer.tokenStream(fieldName, expression);){
                    stream.reset();
                    CharTermAttribute termAttribute = (CharTermAttribute)stream.addAttribute(CharTermAttribute.class);
                    while (stream.incrementToken()) {
                        String analyzedTerm = termAttribute.toString();
                        builder.add(new Term(fieldName, analyzedTerm));
                    }
                    stream.end();
                }
                return builder.build();
            }
            catch (Exception e) {
                throw new LuceneIndexException(e);
            }
        }

        private Query createDisjunctionQuery(String fieldName, FullTextSearch.Disjunction disjunction) {
            BooleanQuery.Builder builder = new BooleanQuery.Builder();
            builder.setDisableCoord(true);
            boolean atLeastOnePositiveClause = false;
            for (FullTextSearch.Term nested : disjunction) {
                Query subQuery;
                if (nested instanceof FullTextSearch.NegationTerm || EMPTY_PHRASE_QUERY.equals((Object)(subQuery = this.createQuery(fieldName, nested)))) continue;
                atLeastOnePositiveClause = true;
                builder.add(subQuery, BooleanClause.Occur.SHOULD);
            }
            if (!atLeastOnePositiveClause) {
                builder.add((Query)new MatchAllDocsQuery(), BooleanClause.Occur.FILTER);
            }
            return builder.build();
        }

        private Query createConjunctionQuery(String fieldName, FullTextSearch.Conjunction conjunction) {
            BooleanQuery.Builder builder = new BooleanQuery.Builder();
            builder.setDisableCoord(true);
            boolean atLeastOnePositiveClause = false;
            for (FullTextSearch.Term nested : conjunction) {
                Query subQuery;
                if (nested instanceof FullTextSearch.NegationTerm) {
                    subQuery = this.createQuery(fieldName, ((FullTextSearch.NegationTerm)nested).getNegatedTerm());
                    if (EMPTY_PHRASE_QUERY.equals((Object)subQuery)) continue;
                    builder.add(subQuery, BooleanClause.Occur.MUST_NOT);
                    continue;
                }
                subQuery = this.createQuery(fieldName, nested);
                if (EMPTY_PHRASE_QUERY.equals((Object)subQuery)) continue;
                atLeastOnePositiveClause = true;
                builder.add(subQuery, BooleanClause.Occur.MUST);
            }
            if (!atLeastOnePositiveClause) {
                builder.add((Query)new MatchAllDocsQuery(), BooleanClause.Occur.FILTER);
            }
            return builder.build();
        }

        private Query createWildcardQuery(final String fieldName, FullTextSearch.SimpleTerm simple) throws ParseException {
            QueryParser parser = new QueryParser(fieldName, this.analyzer){

                protected Query getWildcardQuery(String field, String termStr) {
                    return CompareStringQuery.createQueryForNodesWithFieldLike(termStr.toLowerCase(), fieldName, null);
                }
            };
            String expression = simple.getValue();
            expression = expression.replaceAll("(?<![\\\\])_", "?");
            expression = expression.replaceAll("(?<![\\\\])%", "*");
            expression = expression.replaceAll("((?<![\\d*?]))[-]((?![\\d*?]))", "$1 $2");
            return parser.parse(expression);
        }
    }

    protected static class SingleColumnQueryFactory
    extends LuceneQueryFactory {
        private SingleColumnQueryFactory(ValueFactories factories, Map<String, Object> variables, Map<String, PropertyType> propertyTypesByName) {
            super(factories, variables, propertyTypesByName);
        }

        @Override
        protected Query createQuery(PropertyExistence propertyExistence) {
            return new MatchAllDocsQuery();
        }

        @Override
        protected List<String> collectReferenceFieldNames(ReferenceValue referenceValue) {
            assert (this.propertyTypesByName.size() == 1);
            return Collections.singletonList(this.propertyName());
        }

        protected String propertyName() {
            return (String)this.propertyTypesByName.keySet().iterator().next();
        }
    }
}

