/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.index.lucene;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Random;
import java.util.UUID;
import org.junit.After;
import org.junit.Before;
import org.modeshape.common.util.FileUtil;
import org.modeshape.jcr.ExecutionContext;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.index.lucene.LuceneConfig;
import org.modeshape.jcr.index.lucene.LuceneIndex;
import org.modeshape.jcr.value.PropertyType;
import org.modeshape.jcr.value.basic.ModeShapeDateTime;

public abstract class AbstractIndexPersistenceTest {
    private static final Random RANDOM = new Random();
    protected ExecutionContext context;
    protected LuceneConfig config;
    protected LuceneIndex index;

    protected abstract LuceneIndex createIndex(String var1);

    @Before
    public void setUp() throws Exception {
        String dir = "target/lucene-index-test";
        FileUtil.delete((String)dir);
        this.config = LuceneConfig.onDisk((String)dir);
        this.context = new ExecutionContext();
        this.index = this.defaultIndex();
    }

    protected LuceneIndex defaultIndex() {
        return this.createIndex("default");
    }

    @After
    public void tearDown() throws Exception {
        this.index.shutdown(false);
    }

    protected String addMultiplePropertiesToSameNode(LuceneIndex index, String nodeKey, int valuesPerProperty, PropertyType type) {
        ArrayList<Object> values = new ArrayList<Object>();
        IndexedProperty property = this.newProperty(type);
        String propertyName = property.getName();
        for (int i = 0; i < valuesPerProperty; ++i) {
            values.add(property.getValue());
            property = this.newProperty(type);
        }
        index.add(nodeKey, propertyName, values.toArray());
        return propertyName;
    }

    protected IndexedProperty newProperty(PropertyType type) {
        String rnd = UUID.randomUUID().toString().replace("\\-", "_");
        switch (type) {
            case STRING: {
                return new IndexedProperty(type, "prop:string", "string#" + rnd);
            }
            case BINARY: {
                return new IndexedProperty(type, "prop:binary", this.context.getValueFactories().getBinaryFactory().create(rnd));
            }
            case NAME: {
                return new IndexedProperty(type, "prop:name", this.context.getValueFactories().getNameFactory().create("jcr:" + rnd));
            }
            case PATH: {
                return new IndexedProperty(type, "prop:path", this.context.getValueFactories().getPathFactory().create("/a/b/" + rnd));
            }
            case BOOLEAN: {
                Boolean value = RANDOM.nextInt(2) == 1 ? Boolean.TRUE : Boolean.FALSE;
                return new IndexedProperty(type, "prop:boolean", value);
            }
            case DATE: {
                return new IndexedProperty(type, "prop:date", new ModeShapeDateTime());
            }
            case DECIMAL: {
                return new IndexedProperty(type, "prop:decimal", BigDecimal.valueOf(RANDOM.nextDouble()));
            }
            case DOUBLE: {
                return new IndexedProperty(type, "prop:double", RANDOM.nextDouble());
            }
            case LONG: {
                return new IndexedProperty(type, "prop:long", RANDOM.nextLong());
            }
            case REFERENCE: {
                return new IndexedProperty(type, "prop:ref", this.context.getValueFactories().getReferenceFactory().create(new NodeKey(rnd), false));
            }
            case WEAKREFERENCE: {
                return new IndexedProperty(type, "prop:weakref", this.context.getValueFactories().getReferenceFactory().create(new NodeKey(rnd), false));
            }
            case SIMPLEREFERENCE: {
                return new IndexedProperty(type, "prop:simpleref", this.context.getValueFactories().getReferenceFactory().create(new NodeKey(rnd), false));
            }
            case URI: {
                return new IndexedProperty(type, "prop:uri", "http://" + rnd);
            }
        }
        throw new IllegalArgumentException("Unknown property type:" + type);
    }

    protected static class IndexedProperty {
        private final PropertyType type;
        private final String name;
        private final Object value;

        protected IndexedProperty(PropertyType type, String name, Object value) {
            this.type = type;
            this.name = name;
            this.value = value;
        }

        protected PropertyType getType() {
            return this.type;
        }

        protected String getName() {
            return this.name;
        }

        protected Object getValue() {
            return this.value;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("IndexedProperty{");
            sb.append("type=").append(this.type);
            sb.append(", name='").append(this.name).append('\'');
            sb.append(", value=").append(this.value);
            sb.append('}');
            return sb.toString();
        }
    }
}

