/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.index.lucene;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.jcr.query.qom.Constraint;
import javax.jcr.query.qom.JoinCondition;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.modeshape.common.util.FileUtil;
import org.modeshape.jcr.ExecutionContext;
import org.modeshape.jcr.api.query.qom.Operator;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.index.lucene.LuceneConfig;
import org.modeshape.jcr.index.lucene.LuceneIndex;
import org.modeshape.jcr.query.model.And;
import org.modeshape.jcr.query.model.Between;
import org.modeshape.jcr.query.model.Comparison;
import org.modeshape.jcr.query.model.DynamicOperand;
import org.modeshape.jcr.query.model.FullTextSearch;
import org.modeshape.jcr.query.model.Length;
import org.modeshape.jcr.query.model.Literal;
import org.modeshape.jcr.query.model.LowerCase;
import org.modeshape.jcr.query.model.Not;
import org.modeshape.jcr.query.model.Or;
import org.modeshape.jcr.query.model.PropertyExistence;
import org.modeshape.jcr.query.model.PropertyValue;
import org.modeshape.jcr.query.model.ReferenceValue;
import org.modeshape.jcr.query.model.Relike;
import org.modeshape.jcr.query.model.SelectorName;
import org.modeshape.jcr.query.model.SetCriteria;
import org.modeshape.jcr.query.model.StaticOperand;
import org.modeshape.jcr.query.model.UpperCase;
import org.modeshape.jcr.spi.index.IndexConstraints;
import org.modeshape.jcr.spi.index.provider.Filter;
import org.modeshape.jcr.value.ValueFactories;

public abstract class AbstractLuceneIndexSearchTest {
    protected static final SelectorName SELECTOR = new SelectorName("node");
    protected ExecutionContext context;
    protected LuceneConfig config;
    protected LuceneIndex index;
    protected ValueFactories valueFactories;

    protected abstract LuceneIndex createIndex(String var1);

    @Before
    public void setUp() throws Exception {
        String dir = "target/lucene-index-search-test";
        FileUtil.delete((String)dir);
        this.config = LuceneConfig.onDisk((String)dir);
        this.context = new ExecutionContext();
        this.valueFactories = this.context.getValueFactories();
        this.index = this.createIndex("default");
    }

    @After
    public void tearDown() throws Exception {
        this.index.shutdown(false);
    }

    protected void assertLengthComparisonConstraint(String propertyName, String expectedNodeKey, int expectedLength) {
        Comparison constraint = this.length(propertyName, Operator.EQUAL_TO, expectedLength);
        this.validateCardinality((org.modeshape.jcr.query.model.Constraint)constraint, 1L);
        this.validateFilterResults((org.modeshape.jcr.query.model.Constraint)constraint, 1, false, expectedNodeKey);
    }

    protected void validateCardinality(org.modeshape.jcr.query.model.Constraint constraint, long expected) {
        long actualValue = this.index.estimateCardinality(Collections.singletonList(constraint), Collections.emptyMap());
        Assert.assertEquals((String)"Incorrect returned cardinality:", (long)expected, (long)actualValue);
    }

    protected void validateFilterResults(org.modeshape.jcr.query.model.Constraint constraint, int batchSize, boolean expectRealScore, String ... expectedKeys) {
        Filter.ResultBatch nextBatch;
        long cardinalityEstimate = expectedKeys != null ? (long)expectedKeys.length : 0L;
        Filter.Results results = this.index.filter((IndexConstraints)new TestIndexConstraints(constraint), cardinalityEstimate);
        LinkedHashMap actualResults = new LinkedHashMap();
        while ((nextBatch = results.getNextBatch(batchSize)).size() > 0) {
            Iterator keyIterator = nextBatch.keys().iterator();
            Iterator scoresIterator = nextBatch.scores().iterator();
            while (keyIterator.hasNext() && scoresIterator.hasNext()) {
                actualResults.put(((NodeKey)keyIterator.next()).toString(), scoresIterator.next());
            }
        }
        Assert.assertEquals((String)"Incorrect number of results:", (long)expectedKeys.length, (long)actualResults.size());
        for (String expectedKey : actualResults.keySet()) {
            Float score = (Float)actualResults.get(expectedKey);
            if (score == null) {
                Assert.fail((String)("Expected key: " + expectedKey + " not found among results: " + actualResults.keySet()));
            }
            if (!expectRealScore || score.floatValue() != 1.0f) continue;
            Assert.fail((String)("Expected a real score but found: " + score));
        }
    }

    @SafeVarargs
    protected final <T> void addValues(String nodeKey, String propertyName, T ... values) {
        this.index.add(nodeKey, propertyName, (Object[])values);
    }

    private <T> String insertValue(String propertyName, T value) {
        String nodeKey = UUID.randomUUID().toString();
        this.index.add(nodeKey, propertyName, value);
        return nodeKey;
    }

    @SafeVarargs
    protected final <T> List<String> indexNodes(String propertyName, T ... values) {
        ArrayList<String> result = new ArrayList<String>();
        for (T value : values) {
            result.add(this.insertValue(propertyName, value));
        }
        return result;
    }

    protected org.modeshape.jcr.query.model.Constraint relike(Object value, String propertyName) {
        PropertyValue propValue = new PropertyValue(SELECTOR, propertyName);
        return new Relike((StaticOperand)new Literal(value), propValue);
    }

    protected org.modeshape.jcr.query.model.Constraint and(org.modeshape.jcr.query.model.Constraint left, org.modeshape.jcr.query.model.Constraint right) {
        return new And(left, right);
    }

    protected org.modeshape.jcr.query.model.Constraint or(org.modeshape.jcr.query.model.Constraint left, org.modeshape.jcr.query.model.Constraint right) {
        return new Or(left, right);
    }

    protected org.modeshape.jcr.query.model.Constraint not(org.modeshape.jcr.query.model.Constraint constraint) {
        return new Not(constraint);
    }

    protected org.modeshape.jcr.query.model.Constraint set(String propertyName, Object ... values) {
        PropertyValue propValue = new PropertyValue(SELECTOR, propertyName);
        ArrayList<Literal> operands = new ArrayList<Literal>(values.length);
        for (Object value : values) {
            operands.add(new Literal(value));
        }
        return new SetCriteria((DynamicOperand)propValue, operands);
    }

    protected org.modeshape.jcr.query.model.Constraint between(String propertyName, Object lowerBound, boolean includeLowerBound, Object upperBound, boolean includeUpperBound) {
        PropertyValue propValue = new PropertyValue(SELECTOR, propertyName);
        return new Between((DynamicOperand)propValue, (StaticOperand)new Literal(lowerBound), (StaticOperand)new Literal(upperBound), includeLowerBound, includeUpperBound);
    }

    protected org.modeshape.jcr.query.model.Constraint fullTextSearch(String propertyName, String expression) {
        return new FullTextSearch(SELECTOR, propertyName, expression);
    }

    protected Comparison lowerCase(String propertyName, Operator operator, Object value) {
        PropertyValue propValue = new PropertyValue(SELECTOR, propertyName);
        LowerCase lowerCase = new LowerCase((DynamicOperand)propValue);
        return new Comparison((DynamicOperand)lowerCase, operator, (StaticOperand)new Literal(value));
    }

    protected Comparison upperCase(String propertyName, Operator operator, Object value) {
        PropertyValue propValue = new PropertyValue(SELECTOR, propertyName);
        UpperCase upperCase = new UpperCase((DynamicOperand)propValue);
        return new Comparison((DynamicOperand)upperCase, operator, (StaticOperand)new Literal(value));
    }

    protected Comparison propertyValue(String propertyName, Operator operator, Object value) {
        PropertyValue propValue = new PropertyValue(SELECTOR, propertyName);
        return new Comparison((DynamicOperand)propValue, operator, (StaticOperand)new Literal(value));
    }

    protected Comparison referenceValue(String propertyName, Operator operator, Object value, boolean includeWeak, boolean includeSimple) {
        ReferenceValue referenceValue = new ReferenceValue(SELECTOR, propertyName, includeWeak, includeSimple);
        return new Comparison((DynamicOperand)referenceValue, operator, (StaticOperand)new Literal(value));
    }

    protected Comparison length(String propertyName, Operator operator, Object value) {
        PropertyValue propValue = new PropertyValue(SELECTOR, propertyName);
        Length length = new Length(propValue);
        return new Comparison((DynamicOperand)length, operator, (StaticOperand)new Literal(value));
    }

    protected PropertyExistence propertyExistence(String propertyName) {
        return new PropertyExistence(SELECTOR, propertyName);
    }

    protected class TestIndexConstraints
    implements IndexConstraints {
        private final org.modeshape.jcr.query.model.Constraint constraint;

        private TestIndexConstraints(org.modeshape.jcr.query.model.Constraint constraint) {
            this.constraint = constraint;
        }

        public boolean hasConstraints() {
            return true;
        }

        public Collection<Constraint> getConstraints() {
            return Collections.singleton(this.constraint);
        }

        public Collection<JoinCondition> getJoinConditions() {
            return Collections.emptySet();
        }

        public Map<String, Object> getVariables() {
            return Collections.emptyMap();
        }

        public ValueFactories getValueFactories() {
            return AbstractLuceneIndexSearchTest.this.context.getValueFactories();
        }

        public Map<String, Object> getParameters() {
            return Collections.emptyMap();
        }
    }
}

