/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.index.lucene;

import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Random;
import java.util.concurrent.atomic.AtomicLong;
import javax.jcr.Node;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.modeshape.common.FixFor;
import org.modeshape.common.util.FileUtil;
import org.modeshape.jcr.JcrRootNode;
import org.modeshape.jcr.LocalIndexProviderTest;
import org.modeshape.jcr.api.JcrTools;
import org.modeshape.jcr.api.index.IndexDefinition;
import org.modeshape.jcr.api.index.InvalidIndexDefinitionException;

public class LuceneIndexProviderTest
extends LocalIndexProviderTest {
    public void beforeEach() throws Exception {
        super.beforeEach();
        this.tools = new JcrTools();
    }

    protected InputStream repositoryConfiguration() {
        return this.resource("config/repo-config-persistent-lucene-provider-no-indexes.json");
    }

    protected String providerName() {
        return "lucene";
    }

    @Test
    @FixFor(value={"MODE-2520"})
    public void shouldUseMultiColumnIndex() throws Exception {
        this.registerNodeType("nt:testType");
        HashMap<String, Integer> properties = new HashMap<String, Integer>();
        properties.put("stringProp", 1);
        properties.put("longProp", 3);
        properties.put("jcr:name", 7);
        this.registerValueIndex("multiColIndex", "nt:testType", null, "*", properties);
        JcrRootNode root = this.session().getRootNode();
        Node node1 = root.addNode("node1", "nt:testType");
        node1.setProperty("stringProp", "string1");
        Node node2 = root.addNode("node2", "nt:testType");
        node2.setProperty("longProp", 1L);
        Node node3 = root.addNode("node3", "nt:testType");
        node3.setProperty("stringProp", "string3");
        node3.setProperty("longProp", 2L);
        this.session.save();
        org.modeshape.jcr.api.query.Query query = this.jcrSql2Query("SELECT * FROM [nt:testType] WHERE stringProp LIKE 'string%'");
        this.validateQuery().rowCount(2L).hasNodesAtPaths(new String[]{"/node1", "/node3"}).useIndex("multiColIndex").validate((Query)query, (QueryResult)query.execute());
        query = this.jcrSql2Query("SELECT * FROM [nt:testType] WHERE longProp >= 1");
        this.validateQuery().rowCount(2L).hasNodesAtPaths(new String[]{"/node2", "/node3"}).useIndex("multiColIndex").validate((Query)query, (QueryResult)query.execute());
        query = this.jcrSql2Query("SELECT * FROM [nt:testType] WHERE longProp > 1 AND stringProp LIKE 'string%' ");
        this.validateQuery().rowCount(1L).hasNodesAtPaths(new String[]{"/node3"}).useIndex("multiColIndex").validate((Query)query, (QueryResult)query.execute());
        query = this.jcrSql2Query("SELECT * FROM [nt:testType] WHERE NAME() LIKE 'node%' ");
        this.validateQuery().rowCount(3L).hasNodesAtPaths(new String[]{"/node1", "/node2", "/node3"}).useIndex("multiColIndex").validate((Query)query, (QueryResult)query.execute());
    }

    @Test(expected=InvalidIndexDefinitionException.class)
    public void shouldNotAllowMultiColumnTextIndex() throws Exception {
        HashMap<String, Integer> properties = new HashMap<String, Integer>();
        properties.put("prop1", 1);
        properties.put("prop2", 1);
        this.registerIndex("multiColTextIndex", IndexDefinition.IndexKind.TEXT, this.providerName(), "nt:unstructured", null, "*", properties);
    }

    @Test
    public void shouldUseIndexForFTSOnStringProperty() throws Exception {
        this.registerNodeType("nt:testType");
        this.registerTextIndex("textIndex", "nt:testType", null, "*", "FTSProp", 1);
        JcrRootNode root = this.session().getRootNode();
        Node node1 = root.addNode("node", "nt:testType");
        String propertyText = "the quick Brown fox jumps over to the dog in at the gate";
        node1.setProperty("FTSProp", propertyText);
        this.session.save();
        org.modeshape.jcr.api.query.Query query = this.jcrSql2Query("select [jcr:path] from [nt:testType] as n where contains([nt:testType].*,'" + propertyText + "')");
        this.validateQuery().rowCount(1L).hasNodesAtPaths(new String[]{"/node"}).useIndex("textIndex").validate((Query)query, (QueryResult)query.execute());
        this.jcrSql2Query("select [jcr:path] from [nt:testType] as n where contains(FTSProp,'" + propertyText + "')");
        this.validateQuery().rowCount(1L).hasNodesAtPaths(new String[]{"/node"}).useIndex("textIndex").validate((Query)query, (QueryResult)query.execute());
        this.jcrSql2Query("select [jcr:path] from [nt:testType] as n where contains(FTSProp,'" + propertyText.toUpperCase() + "')");
        this.validateQuery().rowCount(1L).hasNodesAtPaths(new String[]{"/node"}).useIndex("textIndex").validate((Query)query, (QueryResult)query.execute());
        this.jcrSql2Query("select [jcr:path] from [nt:testType] as n where contains(FTSProp,'the quick Dog')");
        this.validateQuery().rowCount(1L).hasNodesAtPaths(new String[]{"/node"}).useIndex("textIndex").validate((Query)query, (QueryResult)query.execute());
        this.jcrSql2Query("select [jcr:path] from [nt:testType] as n where contains(n.*,'the quick Dog')");
        this.validateQuery().rowCount(1L).hasNodesAtPaths(new String[]{"/node"}).useIndex("textIndex").validate((Query)query, (QueryResult)query.execute());
        this.jcrSql2Query("select [jcr:path] from [nt:testType] as n where contains(FTSProp,'the quick jumps over gate')");
        this.validateQuery().rowCount(1L).hasNodesAtPaths(new String[]{"/node"}).useIndex("textIndex").validate((Query)query, (QueryResult)query.execute());
        this.jcrSql2Query("select [jcr:path] from [nt:testType] as n where contains(n.*,'the quick jumps over gate')");
        this.validateQuery().rowCount(1L).hasNodesAtPaths(new String[]{"/node"}).useIndex("textIndex").validate((Query)query, (QueryResult)query.execute());
        this.jcrSql2Query("select [jcr:path] from [nt:testType] as n where contains(FTSProp,'the gate')");
        this.validateQuery().rowCount(1L).hasNodesAtPaths(new String[]{"/node"}).useIndex("textIndex").validate((Query)query, (QueryResult)query.execute());
        this.jcrSql2Query("select [jcr:path] from [nt:testType] as n where contains(n.*,'the gate')");
        this.validateQuery().rowCount(1L).hasNodesAtPaths(new String[]{"/node"}).useIndex("textIndex").validate((Query)query, (QueryResult)query.execute());
    }

    @Test
    public void shouldUseIndexForFTSOnBinaryProperty() throws Exception {
        this.registerTextIndex("textIndex", "nt:resource", null, "*", "jcr:data", 2);
        this.tools.uploadFile((Session)this.session, "/node", this.resourceStream("text-file.txt"));
        this.session.save();
        org.modeshape.jcr.api.query.Query query = this.jcrSql2Query("select [jcr:path] from [nt:resource] as n where contains(n.*,'the quick jumps')");
        this.validateQuery().rowCount(1L).hasNodesAtPaths(new String[]{"/node/jcr:content"}).useIndex("textIndex").validate((Query)query, (QueryResult)query.execute());
    }

    @Test
    @FixFor(value={"MODE-2565"})
    public void shouldNotReindexOnStartup() throws Exception {
        super.shouldNotReindexOnStartup();
    }

    @Test
    @FixFor(value={"MODE-2683"})
    public void shouldUseIndexWithUpperAndLowerOperands() throws Exception {
        this.registerValueIndex("descriptionIndex", "mix:title", "Index for the 'jcr:title' property on mix:title", "*", "jcr:title", 1);
        JcrRootNode root = this.session().getRootNode();
        Node book1 = root.addNode("myFirstBook");
        book1.addMixin("mix:title");
        book1.setProperty("jcr:title", "The Title");
        Node book2 = root.addNode("mySecondBook");
        book2.addMixin("mix:title");
        book2.setProperty("jcr:title", "A Different Title");
        Node book3 = root.addNode("myThirdBook");
        book3.addMixin("mix:title");
        book3.setProperty("jcr:title", "UPPERCASE TITLE");
        this.session.save();
        org.modeshape.jcr.api.query.Query query = this.jcrSql2Query("SELECT * FROM [mix:title] WHERE UPPER([jcr:title]) LIKE '%TITLE%'");
        this.validateQuery().rowCount(3L).useIndex("descriptionIndex").validate((Query)query, (QueryResult)query.execute());
        query = this.jcrSql2Query("SELECT * FROM [mix:title] WHERE LOWER([jcr:title]) LIKE '%title%'");
        this.validateQuery().rowCount(3L).useIndex("descriptionIndex").validate((Query)query, (QueryResult)query.execute());
        query = this.jcrSql2Query("SELECT * FROM [mix:title] WHERE [jcr:title] LIKE '%title%'");
        this.validateQuery().rowCount(0L).useIndex("descriptionIndex").validate((Query)query, (QueryResult)query.execute());
        query = this.jcrSql2Query("SELECT * FROM [mix:title] WHERE [jcr:title] LIKE '%Title%'");
        this.validateQuery().rowCount(2L).useIndex("descriptionIndex").validate((Query)query, (QueryResult)query.execute());
        query = this.jcrSql2Query("SELECT * FROM [mix:title] WHERE [jcr:title] LIKE '%TITLE%'");
        this.validateQuery().rowCount(1L).useIndex("descriptionIndex").validate((Query)query, (QueryResult)query.execute());
    }

    @Test
    @Ignore(value="perf test")
    public void testPerformanceOnStringFields() throws Exception {
        this.registerNodeType("nt:testType");
        this.registerValueIndex("stringIndex", "nt:testType", null, "*", "stringProp", 1);
        JcrRootNode rootNode = this.session.getRootNode();
        Node containerNode = rootNode.addNode("container", "nt:unstructured");
        int numNodes = 1000;
        long start = System.currentTimeMillis();
        for (int i = 0; i < numNodes; ++i) {
            Node node = containerNode.addNode("node-" + i, "nt:testType");
            node.setProperty("id", (long)i);
            node.setProperty("stringProp", "str" + i);
        }
        this.session.save();
        System.out.printf("Inserted %d in %d ms.\n", numNodes, System.currentTimeMillis() - start);
        Random random = new Random();
        start = System.currentTimeMillis();
        int numSearches = 1000;
        for (int i = 0; i < numSearches; ++i) {
            int findId = random.nextInt(numNodes);
            String findStr = "str" + findId;
            String queryStr = "select test.[id] from [nt:testType] as test where test.stringProp = '" + findStr + "'";
            org.modeshape.jcr.api.query.Query query = this.jcrSql2Query(this.session, queryStr);
            this.validateQuery().useIndex("stringIndex").hasNodesAtPaths(new String[]{"/container/node-" + findId}).validate((Query)query, (QueryResult)query.execute());
        }
        System.out.printf("Searched %d nodes %d times in %d ms.\n", numNodes, numSearches, System.currentTimeMillis() - start);
        containerNode.remove();
        this.session.save();
    }

    protected void assertStorageLocationUnchangedAfterRestart() throws Exception {
        File indexesDir1 = new File("target/persistent_repository/indexes/lucene_primary/default/ref1");
        Assert.assertTrue((indexesDir1.exists() && indexesDir1.isDirectory() && indexesDir1.canRead() ? 1 : 0) != 0);
        long sizeDir1 = FileUtil.size((String)indexesDir1.getPath());
        AtomicLong lastModifiedDateDir1 = this.lastModifiedFileTime(indexesDir1, "_0.*");
        File indexesDir2 = new File("target/persistent_repository/indexes/lucene_primary/default/ref2");
        Assert.assertTrue((indexesDir2.exists() && indexesDir2.isDirectory() && indexesDir2.canRead() ? 1 : 0) != 0);
        long sizeDir2 = FileUtil.size((String)indexesDir1.getPath());
        AtomicLong lastModifiedDateDir2 = this.lastModifiedFileTime(indexesDir2, "_0.*");
        this.startRepository();
        this.printMessage("Repository restart complete");
        Assert.assertEquals((long)sizeDir1, (long)FileUtil.size((String)indexesDir1.getPath()));
        Assert.assertEquals((long)lastModifiedDateDir1.get(), (long)this.lastModifiedFileTime(indexesDir1, "_0.*").get());
        Assert.assertEquals((long)sizeDir2, (long)FileUtil.size((String)indexesDir2.getPath()));
        Assert.assertEquals((long)lastModifiedDateDir2.get(), (long)this.lastModifiedFileTime(indexesDir2, "_0.*").get());
    }
}

