/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.index.lucene;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.modeshape.common.FixFor;
import org.modeshape.jcr.api.query.qom.Operator;
import org.modeshape.jcr.api.value.DateTime;
import org.modeshape.jcr.index.lucene.AbstractLuceneIndexSearchTest;
import org.modeshape.jcr.index.lucene.LuceneIndex;
import org.modeshape.jcr.index.lucene.LuceneIndexException;
import org.modeshape.jcr.index.lucene.MultiColumnIndex;
import org.modeshape.jcr.index.lucene.PropertiesTestUtil;
import org.modeshape.jcr.query.model.Comparison;
import org.modeshape.jcr.query.model.Constraint;
import org.modeshape.jcr.query.model.PropertyExistence;
import org.modeshape.jcr.value.BinaryValue;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.NameFactory;
import org.modeshape.jcr.value.Path;
import org.modeshape.jcr.value.PathFactory;
import org.modeshape.jcr.value.StringFactory;
import org.modeshape.jcr.value.ValueFormatException;
import org.modeshape.jcr.value.basic.ModeShapeDateTime;

public class SingleColumnIndexSearchTest
extends AbstractLuceneIndexSearchTest {
    @Override
    protected LuceneIndex createIndex(String name) {
        return new MultiColumnIndex(name + "-multi-valued", "default", this.config, PropertiesTestUtil.ALLOWED_PROPERTIES, this.context);
    }

    @Test
    public void shouldSearchForStringPropertyValueInComparisonConstraint() throws Exception {
        List<String> nodeKeys = this.indexNodes("prop:string", "s1", "s2", "s1");
        Comparison constraint = this.propertyValue("prop:string", Operator.EQUAL_TO, "s1");
        this.validateCardinality((Constraint)constraint, 2L);
        this.validateFilterResults((Constraint)constraint, 2, false, nodeKeys.get(0), nodeKeys.get(2));
        constraint = this.propertyValue("prop:string", Operator.EQUAL_TO, "s2");
        this.validateCardinality((Constraint)constraint, 1L);
        this.validateFilterResults((Constraint)constraint, 1, false, nodeKeys.get(1));
        constraint = this.propertyValue("prop:string", Operator.EQUAL_TO, "s3");
        this.validateCardinality((Constraint)constraint, 0L);
        this.validateFilterResults((Constraint)constraint, 0, false, new String[0]);
        constraint = this.propertyValue("prop:string", Operator.GREATER_THAN, "s1");
        this.validateCardinality((Constraint)constraint, 1L);
        this.validateFilterResults((Constraint)constraint, 1, false, nodeKeys.get(1));
        constraint = this.propertyValue("prop:string", Operator.GREATER_THAN_OR_EQUAL_TO, "s1");
        this.validateCardinality((Constraint)constraint, 3L);
        this.validateFilterResults((Constraint)constraint, 3, false, nodeKeys.toArray(new String[3]));
        constraint = this.propertyValue("prop:string", Operator.LESS_THAN, "s2");
        this.validateCardinality((Constraint)constraint, 2L);
        this.validateFilterResults((Constraint)constraint, 2, false, nodeKeys.get(0), nodeKeys.get(2));
        constraint = this.propertyValue("prop:string", Operator.LESS_THAN_OR_EQUAL_TO, "s2");
        this.validateCardinality((Constraint)constraint, 3L);
        this.validateFilterResults((Constraint)constraint, 2, false, nodeKeys.toArray(new String[3]));
        constraint = this.propertyValue("prop:string", Operator.LIKE, "s%");
        this.validateCardinality((Constraint)constraint, 3L);
        this.validateFilterResults((Constraint)constraint, 1, false, nodeKeys.toArray(new String[3]));
        constraint = this.propertyValue("prop:string", Operator.LIKE, "%s%");
        this.validateCardinality((Constraint)constraint, 3L);
        this.validateFilterResults((Constraint)constraint, 1, false, nodeKeys.toArray(new String[3]));
        constraint = this.propertyValue("prop:string", Operator.NOT_EQUAL_TO, "s1");
        this.validateCardinality((Constraint)constraint, 1L);
        this.validateFilterResults((Constraint)constraint, 1, false, nodeKeys.get(1));
    }

    @Test
    public void shouldSearchForMultiValueProperty() throws Exception {
        String nodeKey = UUID.randomUUID().toString();
        this.addValues(nodeKey, "prop:string", "a", "ab", "abc");
        Comparison equality = this.propertyValue("prop:string", Operator.EQUAL_TO, "a");
        this.validateCardinality((Constraint)equality, 1L);
        this.validateFilterResults((Constraint)equality, 1, false, nodeKey);
        equality = this.propertyValue("prop:string", Operator.EQUAL_TO, "ab");
        this.validateCardinality((Constraint)equality, 1L);
        this.validateFilterResults((Constraint)equality, 1, false, nodeKey);
        equality = this.propertyValue("prop:string", Operator.EQUAL_TO, "abc");
        this.validateCardinality((Constraint)equality, 1L);
        this.validateFilterResults((Constraint)equality, 1, false, nodeKey);
        equality = this.propertyValue("prop:string", Operator.EQUAL_TO, "d");
        this.validateCardinality((Constraint)equality, 0L);
        Comparison length = this.length("prop:string", Operator.EQUAL_TO, 1);
        this.validateCardinality((Constraint)length, 1L);
        this.validateFilterResults((Constraint)length, 1, false, nodeKey);
        length = this.length("prop:string", Operator.EQUAL_TO, 2);
        this.validateCardinality((Constraint)length, 1L);
        this.validateFilterResults((Constraint)length, 1, false, nodeKey);
        length = this.length("prop:string", Operator.EQUAL_TO, 3);
        this.validateCardinality((Constraint)length, 1L);
        this.validateFilterResults((Constraint)length, 1, false, nodeKey);
        length = this.length("prop:string", Operator.EQUAL_TO, 4);
        this.validateCardinality((Constraint)length, 0L);
    }

    @Test
    public void shouldSearchForPathPropertyValueInComparisonConstraint() throws Exception {
        PathFactory pathFactory = this.valueFactories.getPathFactory();
        List<String> nodeKeys = this.indexNodes("prop:path", (Path)pathFactory.create("/a/b"), (Path)pathFactory.create("/a/d"), (Path)pathFactory.create("/b"));
        Comparison constraint = this.propertyValue("prop:path", Operator.EQUAL_TO, "/a/b");
        this.validateCardinality((Constraint)constraint, 1L);
        this.validateFilterResults((Constraint)constraint, 1, false, nodeKeys.get(0));
        constraint = this.propertyValue("prop:path", Operator.EQUAL_TO, "/c");
        this.validateCardinality((Constraint)constraint, 0L);
        this.validateFilterResults((Constraint)constraint, 0, false, new String[0]);
        constraint = this.propertyValue("prop:path", Operator.GREATER_THAN, "/a/a");
        this.validateCardinality((Constraint)constraint, 3L);
        this.validateFilterResults((Constraint)constraint, 2, false, nodeKeys.toArray(new String[3]));
        constraint = this.propertyValue("prop:path", Operator.GREATER_THAN_OR_EQUAL_TO, "/a/b");
        this.validateCardinality((Constraint)constraint, 3L);
        this.validateFilterResults((Constraint)constraint, 2, false, nodeKeys.toArray(new String[3]));
        constraint = this.propertyValue("prop:path", Operator.LESS_THAN, "/z");
        this.validateCardinality((Constraint)constraint, 3L);
        this.validateFilterResults((Constraint)constraint, 2, false, nodeKeys.toArray(new String[3]));
        constraint = this.propertyValue("prop:path", Operator.LESS_THAN_OR_EQUAL_TO, "/b");
        this.validateCardinality((Constraint)constraint, 3L);
        this.validateFilterResults((Constraint)constraint, 2, false, nodeKeys.toArray(new String[3]));
        constraint = this.propertyValue("prop:path", Operator.LIKE, "/a/%");
        this.validateCardinality((Constraint)constraint, 2L);
        this.validateFilterResults((Constraint)constraint, 1, false, nodeKeys.get(0), nodeKeys.get(1));
        constraint = this.propertyValue("prop:path", Operator.NOT_EQUAL_TO, "/a/b");
        this.validateCardinality((Constraint)constraint, 2L);
        this.validateFilterResults((Constraint)constraint, 2, false, nodeKeys.get(0), nodeKeys.get(1));
    }

    @Test
    public void shouldSearchForNamePropertyValueInComparisonConstraint() throws Exception {
        NameFactory nameFactory = this.valueFactories.getNameFactory();
        List<String> nodeKeys = this.indexNodes("prop:name", (Name)nameFactory.create("jcr:name1"), (Name)nameFactory.create("jcr:name2"), (Name)nameFactory.create("mode:name1"));
        Comparison constraint = this.propertyValue("prop:name", Operator.EQUAL_TO, "jcr:name1");
        this.validateCardinality((Constraint)constraint, 1L);
        this.validateFilterResults((Constraint)constraint, 1, false, nodeKeys.get(0));
        constraint = this.propertyValue("prop:name", Operator.EQUAL_TO, "jcr:name3");
        this.validateCardinality((Constraint)constraint, 0L);
        this.validateFilterResults((Constraint)constraint, 0, false, new String[0]);
        constraint = this.propertyValue("prop:name", Operator.GREATER_THAN, "jcr:name");
        this.validateCardinality((Constraint)constraint, 3L);
        this.validateFilterResults((Constraint)constraint, 2, false, nodeKeys.toArray(new String[3]));
        constraint = this.propertyValue("prop:name", Operator.GREATER_THAN_OR_EQUAL_TO, "jcr:name1");
        this.validateCardinality((Constraint)constraint, 3L);
        this.validateFilterResults((Constraint)constraint, 2, false, nodeKeys.toArray(new String[3]));
        constraint = this.propertyValue("prop:name", Operator.LESS_THAN, "mode:name1");
        this.validateCardinality((Constraint)constraint, 1L);
        this.validateFilterResults((Constraint)constraint, 2, false, nodeKeys.get(0));
        constraint = this.propertyValue("prop:name", Operator.LESS_THAN_OR_EQUAL_TO, "mode:name1");
        this.validateCardinality((Constraint)constraint, 2L);
        this.validateFilterResults((Constraint)constraint, 2, false, nodeKeys.get(0), nodeKeys.get(2));
        constraint = this.propertyValue("prop:name", Operator.LIKE, "jcr:%");
        this.validateCardinality((Constraint)constraint, 2L);
        this.validateFilterResults((Constraint)constraint, 1, false, nodeKeys.get(0), nodeKeys.get(1));
        constraint = this.propertyValue("prop:name", Operator.NOT_EQUAL_TO, "mode:name1");
        this.validateCardinality((Constraint)constraint, 2L);
        this.validateFilterResults((Constraint)constraint, 2, false, nodeKeys.get(1), nodeKeys.get(2));
    }

    @Test
    public void shouldSearchForDecimalPropertyValueInComparisonConstraint() throws Exception {
        List<String> nodesWithDecimalProp = this.indexNodes("prop:decimal", BigDecimal.valueOf(1.1), BigDecimal.valueOf(1.3), BigDecimal.valueOf(1.5));
        Comparison constraint = this.propertyValue("prop:decimal", Operator.EQUAL_TO, "1.1");
        this.validateCardinality((Constraint)constraint, 1L);
        this.validateFilterResults((Constraint)constraint, 1, false, nodesWithDecimalProp.get(0));
        constraint = this.propertyValue("prop:decimal", Operator.GREATER_THAN, "1.1");
        this.validateCardinality((Constraint)constraint, 2L);
        this.validateFilterResults((Constraint)constraint, 1, false, nodesWithDecimalProp.get(1), nodesWithDecimalProp.get(2));
        constraint = this.propertyValue("prop:decimal", Operator.GREATER_THAN_OR_EQUAL_TO, "1.1");
        this.validateCardinality((Constraint)constraint, 3L);
        this.validateFilterResults((Constraint)constraint, 2, false, nodesWithDecimalProp.toArray(new String[3]));
        constraint = this.propertyValue("prop:decimal", Operator.LESS_THAN, "1.3");
        this.validateCardinality((Constraint)constraint, 1L);
        this.validateFilterResults((Constraint)constraint, 2, false, nodesWithDecimalProp.get(0));
        constraint = this.propertyValue("prop:decimal", Operator.LESS_THAN_OR_EQUAL_TO, "1.3");
        this.validateCardinality((Constraint)constraint, 2L);
        this.validateFilterResults((Constraint)constraint, 2, false, nodesWithDecimalProp.get(0), nodesWithDecimalProp.get(1));
        constraint = this.propertyValue("prop:decimal", Operator.LIKE, "1%");
        this.validateCardinality((Constraint)constraint, 3L);
        this.validateFilterResults((Constraint)constraint, 1, false, nodesWithDecimalProp.toArray(new String[3]));
        constraint = this.propertyValue("prop:decimal", Operator.NOT_EQUAL_TO, "1.3");
        this.validateCardinality((Constraint)constraint, 2L);
        this.validateFilterResults((Constraint)constraint, 2, false, nodesWithDecimalProp.get(0), nodesWithDecimalProp.get(2));
    }

    @Test
    public void shouldSearchForLongPropertyValueInComparisonConstraint() throws Exception {
        List<String> nodesWithLongProp = this.indexNodes("prop:long", 101L, 103L, 105L);
        Comparison constraint = this.propertyValue("prop:long", Operator.EQUAL_TO, "103");
        this.validateCardinality((Constraint)constraint, 1L);
        this.validateFilterResults((Constraint)constraint, 1, false, nodesWithLongProp.get(1));
        constraint = this.propertyValue("prop:long", Operator.GREATER_THAN, "101");
        this.validateCardinality((Constraint)constraint, 2L);
        this.validateFilterResults((Constraint)constraint, 1, false, nodesWithLongProp.get(1), nodesWithLongProp.get(2));
        constraint = this.propertyValue("prop:long", Operator.GREATER_THAN_OR_EQUAL_TO, "101");
        this.validateCardinality((Constraint)constraint, 3L);
        this.validateFilterResults((Constraint)constraint, 2, false, nodesWithLongProp.toArray(new String[3]));
        constraint = this.propertyValue("prop:long", Operator.LESS_THAN, "103");
        this.validateCardinality((Constraint)constraint, 1L);
        this.validateFilterResults((Constraint)constraint, 2, false, nodesWithLongProp.get(0));
        constraint = this.propertyValue("prop:long", Operator.LESS_THAN_OR_EQUAL_TO, "103");
        this.validateCardinality((Constraint)constraint, 2L);
        this.validateFilterResults((Constraint)constraint, 2, false, nodesWithLongProp.get(0), nodesWithLongProp.get(1));
        constraint = this.propertyValue("prop:long", Operator.LIKE, "10%");
        try {
            this.validateCardinality((Constraint)constraint, 3L);
            Assert.fail((String)"Should not be able to use the LIKE operator on LONG values");
        }
        catch (ValueFormatException valueFormatException) {
            // empty catch block
        }
        constraint = this.propertyValue("prop:long", Operator.NOT_EQUAL_TO, "103");
        this.validateCardinality((Constraint)constraint, 2L);
        this.validateFilterResults((Constraint)constraint, 2, false, nodesWithLongProp.get(0), nodesWithLongProp.get(2));
    }

    @Test
    public void shouldSearchForDoublePropertyValueInComparisonConstraint() throws Exception {
        List<String> nodesWithDoubleProp = this.indexNodes("prop:double", 10.0, 13.0, 15.0);
        Comparison constraint = this.propertyValue("prop:double", Operator.EQUAL_TO, "15");
        this.validateCardinality((Constraint)constraint, 1L);
        this.validateFilterResults((Constraint)constraint, 1, false, nodesWithDoubleProp.get(2));
        constraint = this.propertyValue("prop:double", Operator.GREATER_THAN, "10");
        this.validateCardinality((Constraint)constraint, 2L);
        this.validateFilterResults((Constraint)constraint, 1, false, nodesWithDoubleProp.get(1), nodesWithDoubleProp.get(2));
        constraint = this.propertyValue("prop:double", Operator.GREATER_THAN_OR_EQUAL_TO, "10");
        this.validateCardinality((Constraint)constraint, 3L);
        this.validateFilterResults((Constraint)constraint, 2, false, nodesWithDoubleProp.toArray(new String[3]));
        constraint = this.propertyValue("prop:double", Operator.LESS_THAN, "13");
        this.validateCardinality((Constraint)constraint, 1L);
        this.validateFilterResults((Constraint)constraint, 2, false, nodesWithDoubleProp.get(0));
        constraint = this.propertyValue("prop:double", Operator.LESS_THAN_OR_EQUAL_TO, "13");
        this.validateCardinality((Constraint)constraint, 2L);
        this.validateFilterResults((Constraint)constraint, 2, false, nodesWithDoubleProp.get(0), nodesWithDoubleProp.get(1));
        constraint = this.propertyValue("prop:double", Operator.LIKE, "10%");
        try {
            this.validateCardinality((Constraint)constraint, 3L);
            Assert.fail((String)"Should not be able to use the LIKE operator on DOUBLE values");
        }
        catch (ValueFormatException valueFormatException) {
            // empty catch block
        }
        constraint = this.propertyValue("prop:double", Operator.NOT_EQUAL_TO, "13");
        this.validateCardinality((Constraint)constraint, 2L);
        this.validateFilterResults((Constraint)constraint, 2, false, nodesWithDoubleProp.get(0), nodesWithDoubleProp.get(2));
    }

    @Test
    public void shouldSearchForDatePropertyValueInComparisonConstraint() throws Exception {
        List<String> nodesWithDateProp = this.indexNodes("prop:date", new ModeShapeDateTime("2015-10-13"), new ModeShapeDateTime("2015-10-15"), new ModeShapeDateTime("2015-10-17"));
        Comparison constraint = this.propertyValue("prop:date", Operator.EQUAL_TO, "2015-10-17");
        this.validateCardinality((Constraint)constraint, 1L);
        this.validateFilterResults((Constraint)constraint, 1, false, nodesWithDateProp.get(2));
        constraint = this.propertyValue("prop:date", Operator.GREATER_THAN, "2015-10-13");
        this.validateCardinality((Constraint)constraint, 2L);
        this.validateFilterResults((Constraint)constraint, 1, false, nodesWithDateProp.get(1), nodesWithDateProp.get(2));
        constraint = this.propertyValue("prop:date", Operator.GREATER_THAN_OR_EQUAL_TO, "2015-10-13");
        this.validateCardinality((Constraint)constraint, 3L);
        this.validateFilterResults((Constraint)constraint, 2, false, nodesWithDateProp.toArray(new String[3]));
        constraint = this.propertyValue("prop:date", Operator.LESS_THAN, "2015-10-15");
        this.validateCardinality((Constraint)constraint, 1L);
        this.validateFilterResults((Constraint)constraint, 2, false, nodesWithDateProp.get(0));
        constraint = this.propertyValue("prop:date", Operator.LESS_THAN_OR_EQUAL_TO, "2015-10-15");
        this.validateCardinality((Constraint)constraint, 2L);
        this.validateFilterResults((Constraint)constraint, 2, false, nodesWithDateProp.get(0), nodesWithDateProp.get(1));
        constraint = this.propertyValue("prop:date", Operator.LIKE, "2015-10-15%");
        try {
            this.validateCardinality((Constraint)constraint, 3L);
            Assert.fail((String)"Should not be able to use the LIKE operator on DOUBLE values");
        }
        catch (ValueFormatException valueFormatException) {
            // empty catch block
        }
        constraint = this.propertyValue("prop:date", Operator.NOT_EQUAL_TO, "2015-10-15");
        this.validateCardinality((Constraint)constraint, 2L);
        this.validateFilterResults((Constraint)constraint, 2, false, nodesWithDateProp.get(0), nodesWithDateProp.get(2));
    }

    @Test
    public void shouldSearchForBooleanPropertyValueInComparisonConstraint() throws Exception {
        List<String> nodesWithBooleanProp = this.indexNodes("prop:boolean", false, true, false);
        Comparison constraint = this.propertyValue("prop:boolean", Operator.EQUAL_TO, true);
        this.validateCardinality((Constraint)constraint, 1L);
        this.validateFilterResults((Constraint)constraint, 1, false, nodesWithBooleanProp.get(1));
        constraint = this.propertyValue("prop:boolean", Operator.GREATER_THAN, false);
        this.validateCardinality((Constraint)constraint, 1L);
        this.validateFilterResults((Constraint)constraint, 1, false, nodesWithBooleanProp.get(1));
        constraint = this.propertyValue("prop:boolean", Operator.GREATER_THAN, true);
        this.validateCardinality((Constraint)constraint, 0L);
        constraint = this.propertyValue("prop:boolean", Operator.GREATER_THAN_OR_EQUAL_TO, false);
        this.validateCardinality((Constraint)constraint, 3L);
        this.validateFilterResults((Constraint)constraint, 2, false, nodesWithBooleanProp.toArray(new String[3]));
        constraint = this.propertyValue("prop:boolean", Operator.LESS_THAN, true);
        this.validateCardinality((Constraint)constraint, 2L);
        this.validateFilterResults((Constraint)constraint, 2, false, nodesWithBooleanProp.get(0), nodesWithBooleanProp.get(1));
        constraint = this.propertyValue("prop:boolean", Operator.LESS_THAN, false);
        this.validateCardinality((Constraint)constraint, 0L);
        constraint = this.propertyValue("prop:boolean", Operator.LESS_THAN_OR_EQUAL_TO, true);
        this.validateCardinality((Constraint)constraint, 3L);
        this.validateFilterResults((Constraint)constraint, 2, false, nodesWithBooleanProp.toArray(new String[3]));
        constraint = this.propertyValue("prop:boolean", Operator.LIKE, "true%");
        try {
            this.validateCardinality((Constraint)constraint, 3L);
            Assert.fail((String)"Should not be able to use the LIKE operator on DOUBLE values");
        }
        catch (LuceneIndexException luceneIndexException) {
            // empty catch block
        }
        constraint = this.propertyValue("prop:boolean", Operator.NOT_EQUAL_TO, true);
        this.validateCardinality((Constraint)constraint, 2L);
        this.validateFilterResults((Constraint)constraint, 2, false, nodesWithBooleanProp.get(0), nodesWithBooleanProp.get(2));
    }

    @Test
    public void shouldSearchForReferencePropertyValueInComparisonConstraint() throws Exception {
        String ref1 = UUID.randomUUID().toString();
        String ref2 = UUID.randomUUID().toString();
        List<String> nodesWithRefProp = this.indexNodes("prop:ref", ref1, ref2);
        Comparison constraint = this.propertyValue("prop:ref", Operator.EQUAL_TO, ref1);
        this.validateCardinality((Constraint)constraint, 1L);
        this.validateFilterResults((Constraint)constraint, 1, false, nodesWithRefProp.get(0));
        constraint = this.propertyValue("prop:ref", Operator.NOT_EQUAL_TO, ref1);
        this.validateCardinality((Constraint)constraint, 1L);
        this.validateFilterResults((Constraint)constraint, 1, false, nodesWithRefProp.get(1));
    }

    @Test
    public void shouldSearchForReferenceValueInComparisonConstraint() throws Exception {
        String ref1 = UUID.randomUUID().toString();
        String ref2 = UUID.randomUUID().toString();
        List<String> nodesWithRefProp = this.indexNodes("prop:ref", ref1, ref2);
        Comparison constraint = this.referenceValue("prop:ref", Operator.EQUAL_TO, ref1, true, true);
        this.validateCardinality((Constraint)constraint, 1L);
        this.validateFilterResults((Constraint)constraint, 1, false, nodesWithRefProp.get(0));
        constraint = this.referenceValue(null, Operator.EQUAL_TO, ref1, true, true);
        this.validateCardinality((Constraint)constraint, 1L);
        this.validateFilterResults((Constraint)constraint, 1, false, nodesWithRefProp.get(0));
    }

    @Test
    public void shouldSearchForLengthInComparisonConstraint() throws Exception {
        String stringVal = "1234";
        String stringNode = this.indexNodes("prop:string", stringVal).get(0);
        NameFactory nameFactory = this.valueFactories.getNameFactory();
        StringFactory stringFactory = this.valueFactories.getStringFactory();
        String nameVal = (String)stringFactory.create((Name)nameFactory.create("jcr:value"));
        String nameNode = this.indexNodes("prop:name", nameVal).get(0);
        PathFactory pathFactory = this.valueFactories.getPathFactory();
        String pathVal = (String)stringFactory.create((Path)pathFactory.create("/a/b"));
        String pathNode = this.indexNodes("prop:path", pathVal).get(0);
        BigDecimal decimal = BigDecimal.valueOf(12.4);
        String decimalStr = (String)stringFactory.create(decimal);
        String decimalNode = this.indexNodes("prop:decimal", decimal).get(0);
        long longValue = 1234L;
        String longStr = (String)stringFactory.create(longValue);
        String longNode = this.indexNodes("prop:long", longValue).get(0);
        double doubleValue = 12346.35;
        String doubleStr = (String)stringFactory.create(doubleValue);
        String doubleNode = this.indexNodes("prop:double", doubleValue).get(0);
        DateTime dateValue = (DateTime)this.valueFactories.getDateFactory().create("2015-10-10");
        String dateStr = (String)stringFactory.create(dateValue);
        String dateNode = this.indexNodes("prop:date", dateValue).get(0);
        String ref = UUID.randomUUID().toString();
        String refNode = this.indexNodes("prop:ref", ref).get(0);
        boolean booleanValue = true;
        String booleanStr = (String)stringFactory.create(booleanValue);
        String booleanNode = this.indexNodes("prop:boolean", booleanValue).get(0);
        BinaryValue binaryValue = (BinaryValue)this.valueFactories.getBinaryFactory().create("some_binary");
        String binaryNode = this.indexNodes("prop:binary", binaryValue).get(0);
        this.assertLengthComparisonConstraint("prop:string", stringNode, stringVal.length());
        this.assertLengthComparisonConstraint("prop:name", nameNode, nameVal.length());
        this.assertLengthComparisonConstraint("prop:path", pathNode, pathVal.length());
        this.assertLengthComparisonConstraint("prop:decimal", decimalNode, decimalStr.length());
        this.assertLengthComparisonConstraint("prop:long", longNode, longStr.length());
        this.assertLengthComparisonConstraint("prop:double", doubleNode, doubleStr.length());
        this.assertLengthComparisonConstraint("prop:date", dateNode, dateStr.length());
        this.assertLengthComparisonConstraint("prop:ref", refNode, ref.length());
        this.assertLengthComparisonConstraint("prop:boolean", booleanNode, booleanStr.length());
        this.assertLengthComparisonConstraint("prop:binary", binaryNode, (int)binaryValue.getSize());
    }

    @Test
    public void shouldSearchForLowerAndUpperCasesInComparisonConstraint() throws Exception {
        List<String> nodeKeys = this.indexNodes("prop:string", "A", "b");
        Comparison constraint = this.lowerCase("prop:string", Operator.EQUAL_TO, "a");
        this.validateCardinality((Constraint)constraint, 1L);
        this.validateFilterResults((Constraint)constraint, 1, false, nodeKeys.get(0));
        constraint = this.lowerCase("prop:string", Operator.EQUAL_TO, "b");
        this.validateCardinality((Constraint)constraint, 1L);
        this.validateFilterResults((Constraint)constraint, 1, false, nodeKeys.get(1));
        constraint = this.upperCase("prop:string", Operator.EQUAL_TO, "B");
        this.validateCardinality((Constraint)constraint, 1L);
        this.validateFilterResults((Constraint)constraint, 1, false, nodeKeys.get(1));
        constraint = this.upperCase("prop:string", Operator.EQUAL_TO, "A");
        this.validateCardinality((Constraint)constraint, 1L);
        this.validateFilterResults((Constraint)constraint, 1, false, nodeKeys.get(0));
    }

    @Test
    public void shouldSearchForAndConstraint() throws Exception {
        List<String> nodeKeys = this.indexNodes("prop:long", 1L, 3L, 5L);
        Constraint constraint = this.and((Constraint)this.propertyValue("prop:long", Operator.GREATER_THAN, 1), (Constraint)this.propertyValue("prop:long", Operator.LESS_THAN, 5));
        this.validateCardinality(constraint, 1L);
        this.validateFilterResults(constraint, 1, false, nodeKeys.get(1));
    }

    @Test
    public void shouldSearchForOrConstraint() throws Exception {
        List<String> nodeKeys = this.indexNodes("prop:long", 1L, 3L, 5L);
        Constraint constraint = this.or((Constraint)this.propertyValue("prop:long", Operator.GREATER_THAN, 1), (Constraint)this.propertyValue("prop:long", Operator.LESS_THAN, 5));
        this.validateCardinality(constraint, 3L);
        this.validateFilterResults(constraint, 3, false, nodeKeys.toArray(new String[nodeKeys.size()]));
    }

    @Test
    public void shouldSearchForNotConstraint() throws Exception {
        List<String> nodeKeys = this.indexNodes("prop:long", 1L, 3L, 5L);
        Constraint constraint = this.not((Constraint)this.propertyValue("prop:long", Operator.GREATER_THAN, 1));
        this.validateCardinality(constraint, 1L);
        this.validateFilterResults(constraint, 1, false, nodeKeys.get(0));
    }

    @Test
    public void shouldSearchForSetConstraint() throws Exception {
        List<String> nodeKeys = this.indexNodes("prop:long", 1L, 3L, 5L);
        Constraint constraint = this.set("prop:long", 1, 2, 3, 4);
        this.validateCardinality(constraint, 2L);
        this.validateFilterResults(constraint, 2, false, nodeKeys.get(0), nodeKeys.get(1));
    }

    @Test
    public void shouldSearchForPropertyExistence() throws Exception {
        String longNode = this.indexNodes("prop:long", 1L).get(0);
        PropertyExistence constraint = this.propertyExistence("prop:long");
        this.validateCardinality((Constraint)constraint, 1L);
        this.validateFilterResults((Constraint)constraint, 1, false, longNode);
        String stringNode = this.indexNodes("prop:string", "a").get(0);
        constraint = this.propertyExistence("prop:string");
        this.validateCardinality((Constraint)constraint, 1L);
        this.validateFilterResults((Constraint)constraint, 1, false, stringNode);
        constraint = this.propertyExistence("prop:date");
        this.validateCardinality((Constraint)constraint, 0L);
    }

    @Test
    public void shouldSearchForBetweenConstraint() throws Exception {
        List<String> nodeKeys = this.indexNodes("prop:long", 1L, 3L);
        Constraint between = this.between("prop:long", 0, false, 2, false);
        this.validateCardinality(between, 1L);
        this.validateFilterResults(between, 1, false, nodeKeys.get(0));
        between = this.between("prop:long", 1, true, 2, false);
        this.validateCardinality(between, 1L);
        this.validateFilterResults(between, 1, false, nodeKeys.get(0));
        between = this.between("prop:long", 1, false, 2, false);
        this.validateCardinality(between, 0L);
        between = this.between("prop:long", 2, false, 4, false);
        this.validateCardinality(between, 1L);
        this.validateFilterResults(between, 1, false, nodeKeys.get(1));
        between = this.between("prop:long", 3, false, 5, false);
        this.validateCardinality(between, 0L);
    }

    @Test
    public void shouldSearchForRelikeConstraint() throws Exception {
        String node = this.indexNodes("prop:string", "string%").get(0);
        Constraint relike = this.relike("string-1", "prop:string");
        this.validateCardinality(relike, 1L);
        this.validateFilterResults(relike, 1, false, node);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void shouldSupportFTSConstraint() throws Exception {
        this.validateCardinality(this.fullTextSearch("prop:string", "some string"), 1L);
    }

    @Test
    @Ignore(value="perf test")
    public void stringSearchPerfTest() throws Exception {
        int nodeCount = 500000;
        ArrayList<String> nodeKeys = new ArrayList<String>(nodeCount);
        ArrayList<String> evenKeys = new ArrayList<String>(nodeCount / 2);
        for (int i = 0; i < nodeCount; ++i) {
            boolean even = i % 2 == 0;
            String value = "string_" + (even ? "even" : "odd");
            List<String> keys = this.indexNodes("prop:string", value);
            nodeKeys.addAll(keys);
            if (!even) continue;
            evenKeys.addAll(keys);
        }
        this.index.commit();
        Assert.assertEquals((long)nodeCount, (long)this.index.estimateTotalCount());
        long start = System.nanoTime();
        Comparison constraint = this.propertyValue("prop:string", Operator.EQUAL_TO, "string_even");
        this.validateCardinality((Constraint)constraint, nodeCount / 2);
        this.validateFilterResults((Constraint)constraint, 1000, false, evenKeys.toArray(new String[evenKeys.size()]));
        long duration = System.nanoTime() - start;
        long searchTime = TimeUnit.MILLISECONDS.convert(duration, TimeUnit.NANOSECONDS);
        System.out.println(Thread.currentThread().getName() + ": (" + this.index.getName() + ") Total time to search " + nodeKeys.size() + " nodes: " + (double)searchTime / 1000.0 + " seconds");
    }

    @Test
    @FixFor(value={"MODE-2567"})
    public void shouldSearchForLikeConstraintContainingSpaceAmpersand() throws Exception {
        List<String> nodeKeys = this.indexNodes("prop:string", "Law & Order - S01E01");
        Comparison constraint = this.propertyValue("prop:string", Operator.LIKE, "%&%");
        this.validateCardinality((Constraint)constraint, 1L);
        this.validateFilterResults((Constraint)constraint, 1, false, nodeKeys.get(0));
        constraint = this.propertyValue("prop:string", Operator.LIKE, "% &%");
        this.validateCardinality((Constraint)constraint, 1L);
        this.validateFilterResults((Constraint)constraint, 1, false, nodeKeys.get(0));
        constraint = this.propertyValue("prop:string", Operator.LIKE, "%& %");
        this.validateCardinality((Constraint)constraint, 1L);
        this.validateFilterResults((Constraint)constraint, 1, false, nodeKeys.get(0));
        constraint = this.propertyValue("prop:string", Operator.LIKE, "%Law & Order%");
        this.validateCardinality((Constraint)constraint, 1L);
        this.validateFilterResults((Constraint)constraint, 1, false, nodeKeys.get(0));
    }
}

