/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.persistence.relational;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.modeshape.common.annotation.NotThreadSafe;
import org.modeshape.common.logging.Logger;
import org.modeshape.persistence.relational.RelationalDbConfig;
import org.modeshape.persistence.relational.RelationalProviderException;
import org.modeshape.persistence.relational.Statements;
import org.modeshape.schematic.document.Bson;
import org.modeshape.schematic.document.Document;

public class DefaultStatements
implements Statements {
    protected static final int DEFAULT_MAX_STATEMENT_PARAM_COUNT = 1000;
    private static final String PLACEHOLDER_STRING = "#";
    protected final Logger logger = Logger.getLogger(this.getClass());
    private final Map<String, String> statements;
    private final RelationalDbConfig config;

    protected DefaultStatements(RelationalDbConfig config, Map<String, String> statements) {
        this.statements = statements;
        this.config = config;
    }

    @Override
    public Void createTable(Connection connection) throws SQLException {
        this.logTableInfo("Creating table {0}...");
        try (PreparedStatement createStmt = connection.prepareStatement(this.statements.get("create_table"));){
            if (createStmt.executeUpdate() > 0) {
                this.logTableInfo("Table {0} created");
            } else {
                this.logTableInfo("Table {0} already exists");
            }
        }
        return null;
    }

    @Override
    public Void dropTable(Connection connection) throws SQLException {
        this.logTableInfo("Dropping table {0}...");
        try (PreparedStatement createStmt = connection.prepareStatement(this.statements.get("delete_table"));){
            if (createStmt.executeUpdate() > 0) {
                this.logTableInfo("Table {0} dropped");
            } else {
                this.logTableInfo("Table {0} does not exist");
            }
        }
        return null;
    }

    @Override
    public List<String> getAllIds(Connection connection) throws SQLException {
        this.logTableInfo("Returning all ids from {0}");
        try (PreparedStatement ps = connection.prepareStatement(this.statements.get("get_all_ids"));){
            ArrayList<String> result = new ArrayList<String>();
            ps.setFetchSize(this.config.fetchSize());
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result.add(rs.getString(1));
                }
            }
            ArrayList<String> arrayList = result;
            return arrayList;
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public Document getById(Connection connection, String id) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public <R> List<R> load(Connection connection, List<String> ids, Function<Document, R> parser) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String formatStatementWithMultipleParams(String statement, int paramCount) {
        String multipleSelectionClause = this.statements.get("multiple_selection_clause");
        int maxStatementParamCount = this.maxStatementParamCount();
        int inClauseSegments = paramCount / maxStatementParamCount;
        int lastInClauseSize = paramCount % maxStatementParamCount;
        StringBuilder multipleSelectionStatement = new StringBuilder();
        if (inClauseSegments > 0) {
            String multipleSelectionSegment = multipleSelectionClause.replace(PLACEHOLDER_STRING, IntStream.range(0, maxStatementParamCount).mapToObj(nr -> "?").collect(Collectors.joining(",")));
            IntStream.range(0, inClauseSegments).forEach(i -> {
                if (multipleSelectionStatement.length() > 0) {
                    multipleSelectionStatement.append(" OR ");
                }
                multipleSelectionStatement.append(multipleSelectionSegment);
            });
        }
        if (lastInClauseSize > 0) {
            String lastSelectionSegment = multipleSelectionClause.replace(PLACEHOLDER_STRING, IntStream.range(0, lastInClauseSize).mapToObj(nr -> "?").collect(Collectors.joining(",")));
            if (multipleSelectionStatement.length() > 0) {
                multipleSelectionStatement.append(" OR ");
            }
            multipleSelectionStatement.append(lastSelectionSegment);
        }
        return statement.replaceAll(PLACEHOLDER_STRING, multipleSelectionStatement.toString());
    }

    /*
     * Loose catch block
     */
    @Override
    public boolean lockForWriting(Connection connection, List<String> ids) throws SQLException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Attempting to lock ids {0} from {1}", new Object[]{ids.toString(), this.tableName()});
        }
        String lockContentStatement = this.statements.get("lock_content");
        if (ids.isEmpty()) {
            return false;
        }
        String formattedStatement = this.formatStatementWithMultipleParams(lockContentStatement, ids.size());
        Throwable throwable = null;
        try (PreparedStatement ps = connection.prepareStatement(formattedStatement);){
            boolean bl;
            Throwable throwable2;
            ResultSet rs;
            block35: {
                block36: {
                    int paramIdx = 1;
                    for (String id : ids) {
                        ps.setString(paramIdx++, id);
                    }
                    rs = ps.executeQuery();
                    throwable2 = null;
                    this.logger.debug("successfully locked ids", new Object[0]);
                    bl = true;
                    if (rs == null) break block35;
                    if (throwable2 == null) break block36;
                    try {
                        rs.close();
                    }
                    catch (Throwable throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    break block35;
                }
                rs.close();
            }
            return bl;
            catch (Throwable throwable4) {
                try {
                    try {
                        try {
                            throwable2 = throwable4;
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            if (rs != null) {
                                if (throwable2 != null) {
                                    try {
                                        rs.close();
                                    }
                                    catch (Throwable throwable6) {
                                        throwable2.addSuppressed(throwable6);
                                    }
                                } else {
                                    rs.close();
                                }
                            }
                            throw throwable5;
                        }
                    }
                    catch (SQLException e) {
                        this.logger.debug((Throwable)e, " cannot lock ids", new Object[0]);
                        boolean bl2 = false;
                        if (ps != null) {
                            if (throwable != null) {
                                try {
                                    ps.close();
                                }
                                catch (Throwable throwable7) {
                                    throwable.addSuppressed(throwable7);
                                }
                            } else {
                                ps.close();
                            }
                        }
                        return bl2;
                    }
                }
                catch (Throwable throwable8) {
                    throwable = throwable8;
                    throw throwable8;
                }
                catch (Throwable throwable9) {
                    throw throwable9;
                }
            }
        }
    }

    @Override
    public DefaultBatchUpdate batchUpdate(Connection connection) {
        return new DefaultBatchUpdate(connection);
    }

    @Override
    public boolean exists(Connection connection, String id) throws SQLException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Checking if the content with ID {0} exists in {1}", new Object[]{id, this.tableName()});
        }
        try (PreparedStatement ps = connection.prepareStatement(this.statements.get("content_exists"));){
            ps.setString(1, id);
            ResultSet rs = ps.executeQuery();
            boolean bl = rs.next();
            return bl;
        }
    }

    @Override
    public Void removeAll(Connection connection) throws SQLException {
        this.logTableInfo("Removing all content from {0}");
        try (PreparedStatement ps = connection.prepareStatement(this.statements.get("remove_all_content"));){
            ps.executeUpdate();
        }
        return null;
    }

    protected int maxStatementParamCount() {
        return 1000;
    }

    protected void logTableInfo(String message) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(message, new Object[]{this.tableName()});
        }
    }

    protected String tableName() {
        return this.config.tableName();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Document readDocument(InputStream is) {
        try (InputStream contentStream = this.config.compress() ? new GZIPInputStream(is) : is;){
            Document document = Bson.read((InputStream)contentStream);
            return document;
        }
        catch (IOException e) {
            throw new RelationalProviderException(e);
        }
    }

    protected byte[] writeDocument(Document content) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            try (OutputStream out = this.config.compress() ? new GZIPOutputStream(bos) : bos;){
                Bson.write((Document)content, (OutputStream)out);
            }
            return bos.toByteArray();
        }
        catch (IOException e) {
            throw new RelationalProviderException(e);
        }
    }

    @NotThreadSafe
    protected class DefaultBatchUpdate
    implements Statements.BatchUpdate {
        private final Connection connection;

        protected DefaultBatchUpdate(Connection connection) {
            this.connection = connection;
        }

        @Override
        public void insert(Map<String, Document> documentsById) throws SQLException {
            if (documentsById.isEmpty()) {
                return;
            }
            String sql = (String)DefaultStatements.this.statements.get("insert_content");
            PreparedStatement insert = this.connection.prepareStatement(sql);
            documentsById.forEach((id, document) -> {
                if (DefaultStatements.this.logger.isDebugEnabled()) {
                    DefaultStatements.this.logger.debug("adding batch statement: {0}", new Object[]{sql.replaceFirst("\\?", (String)id)});
                }
                this.insertDocument(insert, (String)id, (Document)document);
            });
            insert.executeBatch();
        }

        protected void insertDocument(PreparedStatement statement, String id, Document document) {
            try {
                statement.setString(1, id);
                byte[] content = DefaultStatements.this.writeDocument(document);
                statement.setBytes(2, content);
                statement.addBatch();
            }
            catch (SQLException e) {
                throw new RelationalProviderException(e);
            }
        }

        @Override
        public void update(Map<String, Document> documentsById) throws SQLException {
            if (documentsById.isEmpty()) {
                return;
            }
            String sql = (String)DefaultStatements.this.statements.get("update_content");
            PreparedStatement update = this.connection.prepareStatement(sql);
            documentsById.forEach((id, document) -> {
                if (DefaultStatements.this.logger.isDebugEnabled()) {
                    DefaultStatements.this.logger.debug("adding batch statement: {0}", new Object[]{sql.replaceFirst(" ID.*=.*\\?", " ID = " + id)});
                }
                this.updateDocument(update, (String)id, (Document)document);
            });
            update.executeBatch();
        }

        protected void updateDocument(PreparedStatement statement, String id, Document document) {
            try {
                byte[] content = DefaultStatements.this.writeDocument(document);
                statement.setBytes(1, content);
                statement.setString(2, id);
                statement.addBatch();
            }
            catch (SQLException e) {
                throw new RelationalProviderException(e);
            }
        }

        @Override
        public void remove(List<String> ids) throws SQLException {
            if (ids.isEmpty()) {
                return;
            }
            String removeStatement = (String)DefaultStatements.this.statements.get("remove_content");
            String formattedStatement = DefaultStatements.this.formatStatementWithMultipleParams(removeStatement, ids.size());
            if (DefaultStatements.this.logger.isDebugEnabled()) {
                DefaultStatements.this.logger.debug("running statement: {0}", new Object[]{formattedStatement});
            }
            try (PreparedStatement remove = this.connection.prepareStatement(formattedStatement);){
                int paramIdx = 1;
                for (String id : ids) {
                    remove.setString(paramIdx++, id);
                }
                remove.executeUpdate();
            }
        }
    }
}

