/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.persistence.relational;

import com.zaxxer.hikari.HikariDataSource;
import java.io.InputStream;
import org.junit.Assert;
import org.junit.Test;
import org.modeshape.common.database.DatabaseType;
import org.modeshape.persistence.relational.DataSourceManager;
import org.modeshape.persistence.relational.RelationalDb;
import org.modeshape.persistence.relational.RelationalDbConfig;
import org.modeshape.schematic.Schematic;
import org.modeshape.schematic.document.Document;
import org.modeshape.schematic.document.ParsingException;
import org.modeshape.schematic.internal.annotation.FixFor;
import org.modeshape.schematic.internal.document.BasicDocument;

public class RelationalProviderTest {
    @Test
    public void shouldReturnDefaultDbWhenNoExplicitConfigurationGiven() {
        BasicDocument configDocument = new BasicDocument("type", (Object)"db");
        RelationalDb db = (RelationalDb)Schematic.getDb((Document)configDocument);
        Assert.assertNotNull((Object)db);
        Assert.assertEquals((Object)"jdbc:h2:mem:modeshape;DB_CLOSE_DELAY=0;MVCC=TRUE", (Object)db.id());
        RelationalDbConfig config = db.config();
        Assert.assertNotNull((Object)config);
        Assert.assertTrue((boolean)config.createOnStart());
        Assert.assertFalse((boolean)config.dropOnExit());
        Assert.assertEquals((Object)"MODESHAPE_REPOSITORY", (Object)config.tableName());
        Assert.assertEquals((long)1000L, (long)config.fetchSize());
        Assert.assertFalse((boolean)config.compress());
        DataSourceManager dsManager = db.dsManager();
        Assert.assertNotNull((Object)dsManager);
        Assert.assertEquals((Object)DatabaseType.Name.H2, (Object)dsManager.dbType().name());
    }

    @Test
    public void shouldReturnDbConfiguredFromDocument() throws ParsingException {
        RelationalDb db = (RelationalDb)Schematic.getDb((InputStream)RelationalProviderTest.class.getClassLoader().getResourceAsStream("db-config-h2-full.json"));
        Assert.assertNotNull((Object)db);
        Assert.assertEquals((Object)"jdbc:h2:mem:modeshape", (Object)db.id());
        RelationalDbConfig config = db.config();
        Assert.assertNotNull((Object)config);
        Assert.assertFalse((boolean)config.createOnStart());
        Assert.assertTrue((boolean)config.dropOnExit());
        Assert.assertEquals((Object)"REPO", (Object)config.tableName());
        Assert.assertEquals((long)100L, (long)config.fetchSize());
        Assert.assertFalse((boolean)config.compress());
        DataSourceManager dsManager = db.dsManager();
        Assert.assertNotNull((Object)dsManager);
        Assert.assertEquals((Object)DatabaseType.Name.H2, (Object)dsManager.dbType().name());
        HikariDataSource dataSource = (HikariDataSource)dsManager.dataSource();
        Assert.assertEquals((long)Integer.valueOf("1").intValue(), (long)dataSource.getMinimumIdle());
        Assert.assertEquals((long)Integer.valueOf("5").intValue(), (long)dataSource.getMaximumPoolSize());
        Assert.assertEquals((long)Integer.valueOf(RelationalDbConfig.DEFAULT_IDLE_TIMEOUT).intValue(), (long)dataSource.getIdleTimeout());
    }

    @Test
    @FixFor(value={"MODE-2674"})
    public void shouldAllowCustomHikariPassthroughProperties() throws ParsingException {
        RelationalDb db = (RelationalDb)Schematic.getDb((InputStream)RelationalProviderTest.class.getClassLoader().getResourceAsStream("db-config-custom-props.json"));
        Assert.assertNotNull((Object)db);
        DataSourceManager dsManager = db.dsManager();
        HikariDataSource dataSource = (HikariDataSource)dsManager.dataSource();
        Assert.assertEquals((long)4L, (long)dataSource.getMinimumIdle());
        Assert.assertEquals((long)4000L, (long)dataSource.getLeakDetectionThreshold());
        Assert.assertEquals((long)5L, (long)dataSource.getMaximumPoolSize());
        Assert.assertFalse((boolean)dataSource.isReadOnly());
        Assert.assertEquals((Object)"testPool", (Object)dataSource.getPoolName());
    }
}

