/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.repository;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import net.jcip.annotations.Immutable;
import org.modeshape.common.collection.Problem;
import org.modeshape.common.collection.Problems;
import org.modeshape.common.collection.SimpleProblems;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.Logger;
import org.modeshape.common.util.NamedThreadFactory;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.Graph;
import org.modeshape.graph.Location;
import org.modeshape.graph.Node;
import org.modeshape.graph.Subgraph;
import org.modeshape.graph.connector.RepositoryConnectionFactory;
import org.modeshape.graph.connector.RepositoryContext;
import org.modeshape.graph.connector.RepositorySource;
import org.modeshape.graph.mimetype.ExtensionBasedMimeTypeDetector;
import org.modeshape.graph.mimetype.MimeTypeDetector;
import org.modeshape.graph.mimetype.MimeTypeDetectorConfig;
import org.modeshape.graph.mimetype.MimeTypeDetectors;
import org.modeshape.graph.observe.ObservationBus;
import org.modeshape.graph.observe.Observer;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PathExpression;
import org.modeshape.graph.property.PathNotFoundException;
import org.modeshape.graph.property.Property;
import org.modeshape.repository.ModeShapeConfiguration;
import org.modeshape.repository.ModeShapeLexicon;
import org.modeshape.repository.RepositoryI18n;
import org.modeshape.repository.RepositoryService;
import org.modeshape.repository.SimpleRepositoryContext;
import org.modeshape.repository.sequencer.SequencerConfig;
import org.modeshape.repository.sequencer.SequencingService;

@Immutable
public class ModeShapeEngine {
    public static final String CONFIGURATION_REPOSITORY_NAME = "dna:configuration";
    protected final ModeShapeConfiguration.ConfigurationDefinition configuration;
    private final ConfigurationScanner scanner;
    private final Problems problems = new SimpleProblems();
    protected final ExecutionContext context;
    private final RepositoryService repositoryService;
    private final SequencingService sequencingService;
    private final ExecutorService executorService;
    private final MimeTypeDetectors detectors = new MimeTypeDetectors();

    protected ModeShapeEngine(ExecutionContext context, ModeShapeConfiguration.ConfigurationDefinition configuration) {
        this.context = context.with((MimeTypeDetector)this.detectors);
        this.configuration = configuration;
        this.scanner = new ConfigurationScanner(this.problems, this.context, this.configuration);
        for (MimeTypeDetectorConfig config : this.scanner.getMimeTypeDetectors()) {
            this.detectors.addDetector(config);
        }
        this.detectors.addDetector(new MimeTypeDetectorConfig("ExtensionDetector", "Extension-based MIME type detector", ExtensionBasedMimeTypeDetector.class));
        ObservationBus configurationChangeBus = new ObservationBus();
        SimpleRepositoryContext configContext = new SimpleRepositoryContext(context, (Observer)configurationChangeBus, null);
        RepositorySource configSource = this.configuration.getRepositorySource();
        configSource.initialize((RepositoryContext)configContext);
        Path pathToConfigurationRoot = this.configuration.getPath();
        String configWorkspaceName = this.configuration.getWorkspace();
        this.repositoryService = new RepositoryService(configSource, configWorkspaceName, pathToConfigurationRoot, context, this.problems);
        configurationChangeBus.register((Observer)this.repositoryService);
        NamedThreadFactory threadPoolFactory = new NamedThreadFactory(configuration.getName());
        this.executorService = Executors.newScheduledThreadPool(10, (ThreadFactory)threadPoolFactory);
        this.sequencingService = new SequencingService();
        this.sequencingService.setExecutionContext(context);
        this.sequencingService.setExecutorService(this.executorService);
        this.sequencingService.setRepositoryLibrary(this.repositoryService.getRepositoryLibrary());
        for (SequencerConfig sequencerConfig : this.scanner.getSequencingConfigurations()) {
            this.sequencingService.addSequencer(sequencerConfig);
        }
    }

    public Problems getProblems() {
        return this.problems;
    }

    public final ExecutionContext getExecutionContext() {
        return this.context;
    }

    public final RepositorySource getRepositorySource(String repositoryName) {
        this.checkRunning();
        return this.repositoryService.getRepositoryLibrary().getSource(repositoryName);
    }

    public final RepositoryConnectionFactory getRepositoryConnectionFactory() {
        this.checkRunning();
        return this.repositoryService.getRepositoryLibrary();
    }

    public final RepositoryService getRepositoryService() {
        this.checkRunning();
        return this.repositoryService;
    }

    public final Graph getGraph(String sourceName) {
        CheckArg.isNotNull((Object)sourceName, (String)"sourceName");
        return this.getGraph(this.getExecutionContext(), sourceName);
    }

    public final Graph getGraph(ExecutionContext context, String sourceName) {
        CheckArg.isNotNull((Object)context, (String)"context");
        CheckArg.isNotNull((Object)sourceName, (String)"sourceName");
        this.checkRunning();
        Graph graph = Graph.create((String)sourceName, (RepositoryConnectionFactory)this.getRepositoryService().getRepositoryLibrary(), (ExecutionContext)context);
        if (this.configuration.getRepositorySource().getName().equals(sourceName) && this.configuration.getWorkspace() != null) {
            graph.useWorkspace(this.configuration.getWorkspace());
        }
        return graph;
    }

    public final SequencingService getSequencingService() {
        this.checkRunning();
        return this.sequencingService;
    }

    protected final MimeTypeDetector getMimeTypeDetector() {
        this.checkRunning();
        return this.detectors;
    }

    protected final boolean checkRunning() {
        if (this.repositoryService.getAdministrator().isStarted() && this.sequencingService.getAdministrator().isStarted()) {
            return true;
        }
        throw new IllegalStateException(RepositoryI18n.engineIsNotRunning.text(new Object[0]));
    }

    public void start() {
        if (this.getProblems().hasErrors()) {
            Logger log = Logger.getLogger(this.getClass());
            log.error(RepositoryI18n.errorsPreventStarting, new Object[0]);
            for (Problem problem : this.getProblems()) {
                log.error(problem.getMessage(), problem.getParameters());
            }
            throw new IllegalStateException(RepositoryI18n.errorsPreventStarting.text(new Object[0]));
        }
        this.repositoryService.getAdministrator().start();
        this.sequencingService.getAdministrator().start();
    }

    public void shutdown() {
        this.executorService.shutdown();
        this.sequencingService.getAdministrator().shutdown();
        this.repositoryService.getAdministrator().shutdown();
    }

    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        if (!this.sequencingService.getAdministrator().awaitTermination(timeout, unit)) {
            return false;
        }
        if (!this.executorService.awaitTermination(timeout, unit)) {
            return false;
        }
        return this.repositoryService.getAdministrator().awaitTermination(timeout, unit);
    }

    protected Graph getConfigurationGraph() {
        Graph result = Graph.create((RepositorySource)this.configuration.getRepositorySource(), (ExecutionContext)this.context);
        if (this.configuration.getWorkspace() != null) {
            result.useWorkspace(this.configuration.getWorkspace());
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ConfigurationScanner {
        private final Problems problems;
        private final ExecutionContext context;
        private final ModeShapeConfiguration.ConfigurationDefinition configurationRepository;

        protected ConfigurationScanner(Problems problems, ExecutionContext context, ModeShapeConfiguration.ConfigurationDefinition configurationRepository) {
            this.problems = problems;
            this.context = context;
            this.configurationRepository = configurationRepository;
        }

        public List<MimeTypeDetectorConfig> getMimeTypeDetectors() {
            ArrayList<MimeTypeDetectorConfig> detectors = new ArrayList<MimeTypeDetectorConfig>();
            Graph graph = Graph.create((RepositorySource)this.configurationRepository.getRepositorySource(), (ExecutionContext)this.context);
            Path pathToSequencersNode = this.context.getValueFactories().getPathFactory().create(this.configurationRepository.getPath(), new Name[]{ModeShapeLexicon.MIME_TYPE_DETECTORS});
            try {
                Subgraph subgraph = (Subgraph)graph.getSubgraphOfDepth(2).at(pathToSequencersNode);
                HashSet<Name> skipProperties = new HashSet<Name>();
                skipProperties.add(ModeShapeLexicon.READABLE_NAME);
                skipProperties.add(ModeShapeLexicon.DESCRIPTION);
                skipProperties.add(ModeShapeLexicon.CLASSNAME);
                skipProperties.add(ModeShapeLexicon.CLASSPATH);
                skipProperties.add(ModeShapeLexicon.PATH_EXPRESSION);
                HashSet<String> skipNamespaces = new HashSet<String>();
                skipNamespaces.add("http://www.jcp.org/jcr/1.0");
                skipNamespaces.add("http://www.jcp.org/jcr/nt/1.0");
                skipNamespaces.add("http://www.jcp.org/jcr/mix/1.0");
                for (Location detectorLocation : subgraph.getRoot().getChildren()) {
                    Node node = subgraph.getNode(detectorLocation);
                    String name = this.stringValueOf(node, ModeShapeLexicon.READABLE_NAME);
                    if (name == null) {
                        name = this.stringValueOf(node);
                    }
                    String desc = this.stringValueOf(node, ModeShapeLexicon.DESCRIPTION);
                    String classname = this.stringValueOf(node, ModeShapeLexicon.CLASSNAME);
                    String[] classpath = this.stringValuesOf(node, ModeShapeLexicon.CLASSPATH);
                    HashMap<String, Object> properties = new HashMap<String, Object>();
                    for (Property property : node.getProperties()) {
                        Name propertyName = property.getName();
                        if (skipNamespaces.contains(propertyName.getNamespaceUri()) || skipProperties.contains(propertyName)) continue;
                        if (property.isSingle()) {
                            properties.put(propertyName.getLocalName(), property.getFirstValue());
                            continue;
                        }
                        properties.put(propertyName.getLocalName(), property.getValuesAsArray());
                    }
                    MimeTypeDetectorConfig config = new MimeTypeDetectorConfig(name, desc, properties, classname, classpath);
                    detectors.add(config);
                }
            }
            catch (PathNotFoundException e) {
                // empty catch block
            }
            return detectors;
        }

        public List<SequencerConfig> getSequencingConfigurations() {
            ArrayList<SequencerConfig> configs = new ArrayList<SequencerConfig>();
            Graph graph = Graph.create((RepositorySource)this.configurationRepository.getRepositorySource(), (ExecutionContext)this.context);
            Path pathToSequencersNode = this.context.getValueFactories().getPathFactory().create(this.configurationRepository.getPath(), new Name[]{ModeShapeLexicon.SEQUENCERS});
            try {
                Subgraph subgraph = (Subgraph)graph.getSubgraphOfDepth(2).at(pathToSequencersNode);
                HashSet<Name> skipProperties = new HashSet<Name>();
                skipProperties.add(ModeShapeLexicon.READABLE_NAME);
                skipProperties.add(ModeShapeLexicon.DESCRIPTION);
                skipProperties.add(ModeShapeLexicon.CLASSNAME);
                skipProperties.add(ModeShapeLexicon.CLASSPATH);
                skipProperties.add(ModeShapeLexicon.PATH_EXPRESSION);
                HashSet<String> skipNamespaces = new HashSet<String>();
                skipNamespaces.add("http://www.jcp.org/jcr/1.0");
                skipNamespaces.add("http://www.jcp.org/jcr/nt/1.0");
                skipNamespaces.add("http://www.jcp.org/jcr/mix/1.0");
                for (Location sequencerLocation : subgraph.getRoot().getChildren()) {
                    Node sequencerNode = subgraph.getNode(sequencerLocation);
                    String name = this.stringValueOf(sequencerNode, ModeShapeLexicon.READABLE_NAME);
                    if (name == null) {
                        name = this.stringValueOf(sequencerNode);
                    }
                    String desc = this.stringValueOf(sequencerNode, ModeShapeLexicon.DESCRIPTION);
                    String classname = this.stringValueOf(sequencerNode, ModeShapeLexicon.CLASSNAME);
                    String[] classpath = this.stringValuesOf(sequencerNode, ModeShapeLexicon.CLASSPATH);
                    String[] expressionStrings = this.stringValuesOf(sequencerNode, ModeShapeLexicon.PATH_EXPRESSION);
                    ArrayList<PathExpression> pathExpressions = new ArrayList<PathExpression>();
                    if (expressionStrings != null) {
                        for (String expressionString : expressionStrings) {
                            try {
                                pathExpressions.add(PathExpression.compile((String)expressionString));
                            }
                            catch (Throwable t) {
                                this.problems.addError(t, RepositoryI18n.pathExpressionIsInvalidOnSequencer, new Object[]{expressionString, name, t.getLocalizedMessage()});
                            }
                        }
                    }
                    String[] goodExpressionStrings = new String[pathExpressions.size()];
                    for (int i = 0; i != pathExpressions.size(); ++i) {
                        PathExpression expression = (PathExpression)pathExpressions.get(i);
                        goodExpressionStrings[i] = expression.getExpression();
                    }
                    HashMap<String, Object> properties = new HashMap<String, Object>();
                    for (Property property : sequencerNode.getProperties()) {
                        Name propertyName = property.getName();
                        if (skipNamespaces.contains(propertyName.getNamespaceUri()) || skipProperties.contains(propertyName)) continue;
                        if (property.isSingle()) {
                            properties.put(propertyName.getLocalName(), property.getFirstValue());
                            continue;
                        }
                        properties.put(propertyName.getLocalName(), property.getValuesAsArray());
                    }
                    SequencerConfig config = new SequencerConfig(name, desc, properties, classname, classpath, goodExpressionStrings);
                    configs.add(config);
                }
            }
            catch (PathNotFoundException e) {
                // empty catch block
            }
            return configs;
        }

        private String stringValueOf(Node node) {
            return node.getLocation().getPath().getLastSegment().getString(this.context.getNamespaceRegistry());
        }

        private String stringValueOf(Node node, Name propertyName) {
            Property property = node.getProperty(propertyName);
            if (property == null) {
                return null;
            }
            if (property.isEmpty()) {
                return null;
            }
            return (String)this.context.getValueFactories().getStringFactory().create(property.getFirstValue());
        }

        private String[] stringValuesOf(Node node, Name propertyName) {
            Property property = node.getProperty(propertyName);
            if (property == null) {
                return null;
            }
            return (String[])this.context.getValueFactories().getStringFactory().create(property.getValuesAsArray());
        }
    }
}

