/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.repository;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.jcip.annotations.ThreadSafe;
import org.modeshape.common.util.CheckArg;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.Graph;
import org.modeshape.graph.Subgraph;
import org.modeshape.graph.connector.RepositoryConnection;
import org.modeshape.graph.connector.RepositoryConnectionFactory;
import org.modeshape.graph.connector.RepositoryConnectionPool;
import org.modeshape.graph.connector.RepositoryContext;
import org.modeshape.graph.connector.RepositorySource;
import org.modeshape.graph.observe.Observable;
import org.modeshape.graph.observe.ObservationBus;
import org.modeshape.graph.observe.Observer;
import org.modeshape.graph.property.Path;
import org.modeshape.repository.RepositoryI18n;
import org.modeshape.repository.service.AbstractServiceAdministrator;
import org.modeshape.repository.service.ServiceAdministrator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class RepositoryLibrary
implements RepositoryConnectionFactory,
Observable {
    private final ServiceAdministrator administrator = new Administrator();
    private final ReadWriteLock sourcesLock = new ReentrantReadWriteLock();
    private final Map<String, RepositoryConnectionPool> pools = new HashMap<String, RepositoryConnectionPool>();
    private RepositoryConnectionFactory delegate;
    private final ExecutionContext executionContext;
    private final ObservationBus observationBus = new ObservationBus();
    private final RepositorySource configurationSource;
    private final String configurationWorkspaceName;
    private final Path pathToConfigurationRoot;

    public RepositoryLibrary(RepositorySource configurationSource, String configurationWorkspaceName, Path pathToSourcesConfigurationRoot, ExecutionContext context) {
        CheckArg.isNotNull((Object)configurationSource, (String)"configurationSource");
        CheckArg.isNotNull((Object)context, (String)"context");
        CheckArg.isNotNull((Object)pathToSourcesConfigurationRoot, (String)"pathToSourcesConfigurationRoot");
        this.executionContext = context;
        this.configurationSource = configurationSource;
        this.configurationWorkspaceName = configurationWorkspaceName;
        this.pathToConfigurationRoot = pathToSourcesConfigurationRoot;
    }

    protected Path getPathToConfigurationRoot() {
        return this.pathToConfigurationRoot;
    }

    protected RepositorySource getConfigurationSource() {
        return this.configurationSource;
    }

    protected String getConfigurationWorkspaceName() {
        return this.configurationWorkspaceName;
    }

    public boolean register(Observer observer) {
        if (observer == null) {
            return false;
        }
        return this.observationBus.register(observer);
    }

    public boolean unregister(Observer observer) {
        return this.observationBus.unregister(observer);
    }

    public ExecutionContext getExecutionContext() {
        return this.executionContext;
    }

    public ServiceAdministrator getAdministrator() {
        return this.administrator;
    }

    protected void start() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shutdown() {
        try {
            this.sourcesLock.readLock().lock();
            for (RepositoryConnectionPool pool : this.pools.values()) {
                pool.shutdown();
                pool.getRepositorySource().close();
            }
        }
        finally {
            this.sourcesLock.readLock().unlock();
        }
        this.observationBus.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        try {
            this.sourcesLock.readLock().lock();
            for (RepositoryConnectionPool pool : this.pools.values()) {
                if (pool.awaitTermination(timeout, unit)) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.sourcesLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTerminating() {
        try {
            this.sourcesLock.readLock().lock();
            for (RepositoryConnectionPool pool : this.pools.values()) {
                if (!pool.isTerminating()) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.sourcesLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTerminated() {
        try {
            this.sourcesLock.readLock().lock();
            for (RepositoryConnectionPool pool : this.pools.values()) {
                if (pool.isTerminated()) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.sourcesLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> getSourceNames() {
        try {
            this.sourcesLock.readLock().lock();
            Collection<String> collection = Collections.unmodifiableCollection(new HashSet<String>(this.pools.keySet()));
            return collection;
        }
        finally {
            this.sourcesLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<RepositorySource> getSources() {
        LinkedList<RepositorySource> sources = new LinkedList<RepositorySource>();
        try {
            this.sourcesLock.readLock().lock();
            for (RepositoryConnectionPool pool : this.pools.values()) {
                sources.add(pool.getRepositorySource());
            }
            Collection<RepositorySource> collection = Collections.unmodifiableCollection(sources);
            return collection;
        }
        finally {
            this.sourcesLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RepositorySource getSource(String sourceName) {
        try {
            this.sourcesLock.readLock().lock();
            RepositoryConnectionPool existingPool = this.pools.get(sourceName);
            RepositorySource repositorySource = existingPool == null ? null : existingPool.getRepositorySource();
            return repositorySource;
        }
        finally {
            this.sourcesLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RepositoryConnectionPool getConnectionPool(String sourceName) {
        try {
            this.sourcesLock.readLock().lock();
            RepositoryConnectionPool repositoryConnectionPool = this.pools.get(sourceName);
            return repositoryConnectionPool;
        }
        finally {
            this.sourcesLock.readLock().unlock();
        }
    }

    public boolean addSource(RepositorySource source) {
        return this.addSource(source, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addSource(RepositorySource source, boolean replaceIfExisting) {
        if (source == null) {
            return false;
        }
        final String sourceName = source.getName();
        if (!replaceIfExisting) {
            try {
                this.sourcesLock.readLock().lock();
                if (this.pools.containsKey(sourceName)) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.sourcesLock.readLock().unlock();
            }
        }
        final ObservationBus observationBus = this.observationBus;
        RepositoryContext repositoryContext = new RepositoryContext(){

            public ExecutionContext getExecutionContext() {
                return RepositoryLibrary.this.getExecutionContext();
            }

            public RepositoryConnectionFactory getRepositoryConnectionFactory() {
                return RepositoryLibrary.this;
            }

            public Observer getObserver() {
                return observationBus.hasObservers() ? observationBus : null;
            }

            public Subgraph getConfiguration(int depth) {
                Subgraph result = null;
                RepositorySource configSource = RepositoryLibrary.this.getConfigurationSource();
                if (configSource != null) {
                    Graph config = Graph.create((RepositorySource)configSource, (ExecutionContext)this.getExecutionContext());
                    String workspaceName = RepositoryLibrary.this.getConfigurationWorkspaceName();
                    if (workspaceName != null) {
                        config.useWorkspace(workspaceName);
                    }
                    Path configPath = RepositoryLibrary.this.getPathToConfigurationRoot();
                    Path sourcePath = this.getExecutionContext().getValueFactories().getPathFactory().create(configPath, sourceName);
                    result = (Subgraph)config.getSubgraphOfDepth(depth).at(sourcePath);
                }
                return result;
            }
        };
        source.initialize(repositoryContext);
        RepositoryConnectionPool pool = new RepositoryConnectionPool(source);
        try {
            this.sourcesLock.writeLock().lock();
            RepositoryConnectionPool existingPool = this.pools.remove(sourceName);
            if (existingPool != null) {
                existingPool.shutdown();
            }
            this.pools.put(sourceName, pool);
            boolean bl = true;
            return bl;
        }
        finally {
            this.sourcesLock.writeLock().unlock();
        }
    }

    public boolean removeSource(RepositorySource source, long timeToAwait, TimeUnit unit) throws InterruptedException {
        return this.removeSource(source.getName(), timeToAwait, unit) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RepositorySource removeSource(String name) {
        try {
            this.sourcesLock.writeLock().lock();
            RepositoryConnectionPool existingPool = this.pools.remove(name);
            if (existingPool != null) {
                existingPool.shutdown();
                RepositorySource repositorySource = existingPool.getRepositorySource();
                return repositorySource;
            }
        }
        finally {
            this.sourcesLock.writeLock().unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RepositorySource removeSource(String name, long timeToAwait, TimeUnit unit) throws InterruptedException {
        try {
            this.sourcesLock.writeLock().lock();
            RepositoryConnectionPool existingPool = this.pools.remove(name);
            if (existingPool != null) {
                existingPool.shutdown();
                if (timeToAwait > 0L) {
                    existingPool.awaitTermination(timeToAwait, unit);
                }
                RepositorySource repositorySource = existingPool.getRepositorySource();
                return repositorySource;
            }
        }
        finally {
            this.sourcesLock.writeLock().unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RepositoryConnection createConnection(String sourceName) {
        try {
            this.sourcesLock.readLock().lock();
            RepositoryConnectionPool existingPool = this.pools.get(sourceName);
            if (existingPool != null) {
                RepositoryConnection repositoryConnection = existingPool.getConnection();
                return repositoryConnection;
            }
            RepositoryConnectionFactory delegate = this.delegate;
            if (delegate != null) {
                RepositoryConnection repositoryConnection = delegate.createConnection(sourceName);
                return repositoryConnection;
            }
        }
        finally {
            this.sourcesLock.readLock().unlock();
        }
        return null;
    }

    protected class Administrator
    extends AbstractServiceAdministrator {
        protected Administrator() {
            super(RepositoryI18n.federationServiceName, ServiceAdministrator.State.STARTED);
        }

        protected void doStart(ServiceAdministrator.State fromState) {
            super.doStart(fromState);
            RepositoryLibrary.this.start();
        }

        protected void doShutdown(ServiceAdministrator.State fromState) {
            super.doShutdown(fromState);
            RepositoryLibrary.this.shutdown();
        }

        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            return RepositoryLibrary.this.awaitTermination(timeout, unit);
        }

        protected boolean doCheckIsTerminated() {
            return RepositoryLibrary.this.isTerminated();
        }
    }
}

