/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.repository.sequencer;

import java.io.Serializable;
import java.util.HashMap;
import java.util.regex.Pattern;
import net.jcip.annotations.Immutable;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.HashCode;
import org.modeshape.graph.property.PathExpression;
import org.modeshape.repository.RepositoryI18n;
import org.modeshape.repository.sequencer.InvalidSequencerPathExpression;

@Immutable
public class SequencerPathExpression
implements Serializable {
    private static final long serialVersionUID = 229464314137494765L;
    private static final Pattern TWO_PART_PATTERN = Pattern.compile("((?:[^=]|=(?!>))+)(?:=>(.+))?");
    protected static final String DEFAULT_OUTPUT_EXPRESSION = ".";
    private static final String PARENT_PATTERN_STRING = "[^/]+/\\.\\./";
    private static final Pattern PARENT_PATTERN = Pattern.compile("[^/]+/\\.\\./");
    private static final String REPLACEMENT_VARIABLE_PATTERN_STRING = "(?<!\\\\)\\$(\\d+)";
    private static final Pattern REPLACEMENT_VARIABLE_PATTERN = Pattern.compile("(?<!\\\\)\\$(\\d+)");
    private final PathExpression selectExpression;
    private final String outputExpression;
    private final int hc;

    public static final SequencerPathExpression compile(String expression) throws InvalidSequencerPathExpression {
        CheckArg.isNotNull((Object)expression, (String)"sequencer path expression");
        expression = expression.trim();
        if (expression.length() == 0) {
            throw new InvalidSequencerPathExpression(RepositoryI18n.pathExpressionMayNotBeBlank.text(new Object[0]));
        }
        java.util.regex.Matcher matcher = TWO_PART_PATTERN.matcher(expression);
        if (!matcher.matches()) {
            throw new InvalidSequencerPathExpression(RepositoryI18n.pathExpressionIsInvalid.text(new Object[]{expression}));
        }
        String selectExpression = matcher.group(1);
        String outputExpression = matcher.group(2);
        return new SequencerPathExpression(PathExpression.compile((String)selectExpression), outputExpression);
    }

    protected SequencerPathExpression(PathExpression selectExpression, String outputExpression) throws InvalidSequencerPathExpression {
        CheckArg.isNotNull((Object)selectExpression, (String)"select expression");
        this.selectExpression = selectExpression;
        this.outputExpression = outputExpression != null ? outputExpression.trim() : DEFAULT_OUTPUT_EXPRESSION;
        this.hc = HashCode.compute((Object[])new Object[]{this.selectExpression, this.outputExpression});
    }

    public String getSelectExpression() {
        return this.selectExpression.getSelectExpression();
    }

    public String getOutputExpression() {
        return this.outputExpression;
    }

    public int hashCode() {
        return this.hc;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof SequencerPathExpression) {
            SequencerPathExpression that = (SequencerPathExpression)obj;
            if (!this.selectExpression.equals((Object)that.selectExpression)) {
                return false;
            }
            return this.outputExpression.equalsIgnoreCase(that.outputExpression);
        }
        return false;
    }

    public String toString() {
        return this.selectExpression + "=>" + this.outputExpression;
    }

    public Matcher matcher(String absolutePath) {
        PathExpression.Matcher inputMatcher = this.selectExpression.matcher(absolutePath);
        String outputPath = null;
        if (inputMatcher.matches()) {
            HashMap<Integer, String> replacements = new HashMap<Integer, String>();
            int count = inputMatcher.groupCount();
            for (int i = 0; i <= count; ++i) {
                replacements.put(i, inputMatcher.group(i));
            }
            String selectedPath = inputMatcher.getSelectedNodePath();
            outputPath = this.outputExpression;
            if (!DEFAULT_OUTPUT_EXPRESSION.equals(outputPath)) {
                java.util.regex.Matcher replacementMatcher = REPLACEMENT_VARIABLE_PATTERN.matcher(outputPath);
                StringBuffer sb = new StringBuffer();
                if (replacementMatcher.find()) {
                    do {
                        String variable;
                        String replacement;
                        if ((replacement = (String)replacements.get(Integer.valueOf(variable = replacementMatcher.group(1)))) == null) {
                            replacement = replacementMatcher.group(0);
                        }
                        replacementMatcher.appendReplacement(sb, replacement);
                    } while (replacementMatcher.find());
                    replacementMatcher.appendTail(sb);
                    outputPath = sb.toString();
                }
                if (!outputPath.endsWith("/")) {
                    outputPath = outputPath + "/";
                }
                outputPath = outputPath.replaceAll("/\\./", "/");
                java.util.regex.Matcher parentMatcher = PARENT_PATTERN.matcher(outputPath);
                while (parentMatcher.find()) {
                    outputPath = parentMatcher.replaceAll("");
                    if (!outputPath.endsWith("/")) {
                        outputPath = outputPath + "/";
                    }
                    parentMatcher = PARENT_PATTERN.matcher(outputPath);
                }
                outputPath = outputPath.replaceAll("/{2,}", "/");
                outputPath = outputPath.replaceAll("/@[^/\\[\\]]+$", "");
                if ((outputPath = outputPath.replaceAll("/$", "")).length() == 0) {
                    outputPath = DEFAULT_OUTPUT_EXPRESSION;
                }
            }
            if (DEFAULT_OUTPUT_EXPRESSION.equals(outputPath)) {
                outputPath = selectedPath;
            }
        }
        return new Matcher(inputMatcher, outputPath);
    }

    @Immutable
    public static class Matcher {
        private final PathExpression.Matcher inputMatcher;
        private final String outputPath;
        private final int hc;

        protected Matcher(PathExpression.Matcher inputMatcher, String outputPath) {
            this.inputMatcher = inputMatcher;
            this.outputPath = outputPath;
            this.hc = HashCode.compute((Object[])new Object[]{super.hashCode(), this.outputPath});
        }

        public boolean matches() {
            return this.inputMatcher.matches() && this.outputPath != null;
        }

        public String getInputPath() {
            return this.inputMatcher.getInputPath();
        }

        public String getSelectedPath() {
            return this.inputMatcher.getSelectedNodePath();
        }

        public String getOutputPath() {
            return this.outputPath;
        }

        public int hashCode() {
            return this.hc;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Matcher) {
                Matcher that = (Matcher)obj;
                if (!super.equals(that)) {
                    return false;
                }
                return this.outputPath.equalsIgnoreCase(that.outputPath);
            }
            return false;
        }

        public String toString() {
            return this.inputMatcher + " => " + this.outputPath;
        }
    }
}

