/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.repository;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import javax.jcr.observation.Event;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsInstanceOf;
import org.hamcrest.core.IsNull;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.modeshape.common.collection.Problem;
import org.modeshape.graph.connector.RepositoryConnection;
import org.modeshape.graph.connector.RepositorySource;
import org.modeshape.graph.connector.inmemory.InMemoryRepositorySource;
import org.modeshape.graph.connector.path.cache.InMemoryWorkspaceCache;
import org.modeshape.graph.mimetype.ExtensionBasedMimeTypeDetector;
import org.modeshape.graph.mimetype.MimeTypeDetector;
import org.modeshape.repository.FakeRepositorySource;
import org.modeshape.repository.ModeShapeConfiguration;
import org.modeshape.repository.ModeShapeEngine;
import org.modeshape.repository.RepositoryLibrary;
import org.modeshape.repository.sequencer.MockStreamSequencerA;
import org.modeshape.repository.sequencer.SequencingService;

public class ModeShapeEngineTest {
    private ModeShapeEngine engine;

    @Before
    public void beforeEach() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void afterEach() throws Exception {
        if (this.engine != null) {
            try {
                this.engine.shutdown();
                this.engine.awaitTermination(3L, TimeUnit.SECONDS);
            }
            finally {
                this.engine = null;
            }
        }
    }

    @Test
    public void shouldAllowCreatingWithEmptyConfig() {
        this.engine = new ModeShapeConfiguration().build();
    }

    @Test
    public void shouldAllowCreatingWithConfigRepository() throws InterruptedException {
        InMemoryRepositorySource configSource = new InMemoryRepositorySource();
        configSource.setName("config repo");
        this.engine = new ModeShapeConfiguration().loadFrom((RepositorySource)configSource).build();
        this.engine.start();
        Assert.assertThat((Object)this.engine.getRepositorySource("config repo"), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)this.engine.getRepositorySource("config repo"), (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(InMemoryRepositorySource.class)));
        RepositoryLibrary library = this.engine.getRepositoryService().getRepositoryLibrary();
        Assert.assertThat((Object)library.getConnectionPool("config repo").getInUseCount(), (Matcher)Is.is((Object)0));
        RepositoryConnection connection = library.getConnectionPool("config repo").getConnection();
        Assert.assertThat((Object)connection.ping(500L, TimeUnit.MILLISECONDS), (Matcher)Is.is((Object)true));
        connection.close();
    }

    @Test
    public void shouldAllowCreatingMultipleRepositorySources() throws Exception {
        InMemoryRepositorySource configSource = new InMemoryRepositorySource();
        configSource.setName("config repo");
        this.engine = ((ModeShapeConfiguration)((ModeShapeConfiguration.RepositorySourceDefinition)((ModeShapeConfiguration.RepositorySourceDefinition)((ModeShapeConfiguration.RepositorySourceDefinition)new ModeShapeConfiguration().loadFrom((RepositorySource)configSource).and().repositorySource("JCR").usingClass(InMemoryRepositorySource.class)).setDescription("Backing Repository for JCR Implementation")).setProperty("name", "JCR")).and()).save().build();
        this.engine.start();
        Assert.assertThat((Object)this.engine.getRepositorySource("config repo"), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)this.engine.getRepositorySource("config repo"), (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(InMemoryRepositorySource.class)));
        Assert.assertThat((Object)this.engine.getRepositorySource("JCR"), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)this.engine.getRepositorySource("JCR"), (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(InMemoryRepositorySource.class)));
        Assert.assertThat((Object)this.engine.getRepositorySource("JCR").getName(), (Matcher)Is.is((Object)"JCR"));
        RepositoryLibrary library = this.engine.getRepositoryService().getRepositoryLibrary();
        RepositoryConnection connection = library.getConnectionPool("JCR").getConnection();
        Assert.assertThat((Object)connection.ping(500L, TimeUnit.MILLISECONDS), (Matcher)Is.is((Object)true));
        connection.close();
    }

    @Test
    public void shouldAllowAddingMimeTypeDetectors() throws Exception {
        InMemoryRepositorySource configSource = new InMemoryRepositorySource();
        configSource.setName("config repo");
        this.engine = ((ModeShapeConfiguration)((ModeShapeConfiguration.MimeTypeDetectorDefinition)((ModeShapeConfiguration.MimeTypeDetectorDefinition)((ModeShapeConfiguration)((ModeShapeConfiguration.RepositorySourceDefinition)((ModeShapeConfiguration.RepositorySourceDefinition)((ModeShapeConfiguration.RepositorySourceDefinition)new ModeShapeConfiguration().loadFrom((RepositorySource)configSource).and().repositorySource("JCR").usingClass(InMemoryRepositorySource.class)).setDescription("Backing Repository for JCR Implementation")).setProperty("name", "JCR")).and()).mimeTypeDetector("default").usingClass(ExtensionBasedMimeTypeDetector.class)).setDescription("Default MimeTypeDetector")).and()).build();
        this.engine.start();
        Assert.assertThat((Object)this.engine.getRepositorySource("config repo"), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)this.engine.getRepositorySource("config repo"), (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(InMemoryRepositorySource.class)));
        MimeTypeDetector detector = this.engine.getExecutionContext().getMimeTypeDetector();
        Assert.assertThat((Object)detector.mimeTypeOf("test", (InputStream)new ByteArrayInputStream("This is useless data".getBytes())), (Matcher)Is.is((Object)"text/plain"));
    }

    @Test
    public void shouldAllowAddingSequencers() throws Exception {
        InMemoryRepositorySource configSource = new InMemoryRepositorySource();
        configSource.setName("config repo");
        this.engine = ((ModeShapeConfiguration)((ModeShapeConfiguration.SequencerDefinition)((ModeShapeConfiguration.SequencerDefinition)((ModeShapeConfiguration)((ModeShapeConfiguration.RepositorySourceDefinition)((ModeShapeConfiguration.RepositorySourceDefinition)((ModeShapeConfiguration.RepositorySourceDefinition)new ModeShapeConfiguration().loadFrom((RepositorySource)configSource).and().repositorySource("JCR").usingClass(InMemoryRepositorySource.class)).setDescription("Backing Repository for JCR Implementation")).setProperty("name", "JCR")).and()).sequencer("Mock Sequencer A").usingClass(MockStreamSequencerA.class)).setDescription("A Mock Sequencer")).sequencingFrom("/**").andOutputtingTo("/").and()).build();
        this.engine.start();
        Assert.assertThat((Object)this.engine.getRepositorySource("config repo"), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)this.engine.getRepositorySource("config repo"), (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(InMemoryRepositorySource.class)));
        SequencingService sequencer = this.engine.getSequencingService();
        Assert.assertThat((Object)sequencer.getStatistics().getNumberOfNodesSequenced(), (Matcher)Is.is((Object)0L));
        Event e1 = (Event)Mockito.mock(Event.class);
        Mockito.when((Object)e1.getType()).thenReturn((Object)1);
        Mockito.when((Object)e1.getPath()).thenReturn((Object)"/test");
        Mockito.when((Object)e1.getUserID()).thenReturn((Object)"Test");
    }

    @Test
    public void shouldSetCachePolicyDefinedInConfigFile() throws Exception {
        this.engine = new ModeShapeConfiguration().loadFrom("src/test/resources/config/cacheConfigRepository.xml").build();
        this.engine.start();
        for (Problem problem : this.engine.getProblems()) {
            System.err.println(problem.toString());
        }
        Assert.assertThat((Object)this.engine.getProblems().isEmpty(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.engine.getRepositorySource("Cache"), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)this.engine.getRepositorySource("Cache"), (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(FakeRepositorySource.class)));
        FakeRepositorySource source = (FakeRepositorySource)this.engine.getRepositorySource("Cache");
        Assert.assertThat((Object)source.getCachePolicy(), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)source.getCachePolicy(), (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(InMemoryWorkspaceCache.InMemoryCachePolicy.class)));
        InMemoryWorkspaceCache.InMemoryCachePolicy cachePolicy = (InMemoryWorkspaceCache.InMemoryCachePolicy)source.getCachePolicy();
        Assert.assertThat((Object)cachePolicy.getTimeToLive(), (Matcher)Is.is((Object)30L));
    }

    public static class MockMimeTypeDetector
    implements MimeTypeDetector {
        private String mimeType = "";

        public void setMimeType(String mimeType) {
            this.mimeType = mimeType;
        }

        public String mimeTypeOf(String name, InputStream is) {
            return this.mimeType;
        }
    }
}

