/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.repository.sequencer;

import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.hamcrest.core.IsSame;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.matchers.JUnitMatchers;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.Graph;
import org.modeshape.graph.connector.RepositorySource;
import org.modeshape.graph.connector.inmemory.InMemoryRepositorySource;
import org.modeshape.graph.property.Path;
import org.modeshape.repository.RepositoryLibrary;
import org.modeshape.repository.sequencer.MockSequencerA;
import org.modeshape.repository.sequencer.SequencerConfig;
import org.modeshape.repository.sequencer.SequencingService;
import org.modeshape.repository.service.ServiceAdministrator;

public class SequencingServiceTest {
    public static final int ALL_EVENT_TYPES = 31;
    public static final String REPOSITORY_SOURCE_NAME = "repository";
    public static final String REPOSITORY_WORKSPACE_NAME = "testRepository-Workspace";
    private RepositoryLibrary sources;
    private SequencingService sequencingService;
    private ExecutionContext executionContext;

    @Before
    public void beforeEach() {
        ExecutionContext context = new ExecutionContext();
        InMemoryRepositorySource configSource = new InMemoryRepositorySource();
        configSource.setDefaultWorkspaceName("default");
        Path configPath = (Path)context.getValueFactories().getPathFactory().create("/");
        this.sources = new RepositoryLibrary((RepositorySource)configSource, "default", configPath, context);
        InMemoryRepositorySource source = new InMemoryRepositorySource();
        source.setName(REPOSITORY_SOURCE_NAME);
        this.sources.addSource((RepositorySource)source);
        this.executionContext = new ExecutionContext();
        this.sequencingService = new SequencingService();
        this.sequencingService.setExecutionContext(this.executionContext);
        this.sequencingService.setRepositoryLibrary(this.sources);
    }

    @After
    public void afterEach() throws Exception {
        this.sequencingService.getAdministrator().shutdown();
        this.sequencingService.getAdministrator().awaitTermination(5L, TimeUnit.SECONDS);
    }

    @Test
    public void shouldHaveTheDefaultSelectorUponConstruction() {
        Assert.assertThat((Object)this.sequencingService.getSequencerSelector(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)SequencingService.DEFAULT_SEQUENCER_SELECTOR)));
    }

    @Test
    public void shouldHaveNoExecutorServiceUponConstruction() {
        Assert.assertThat((Object)this.sequencingService.getExecutorService(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    @Test
    public void shouldCreateDefaultExecutorServiceWhenStartedIfNoExecutorServiceHasBeenSet() {
        Assert.assertThat((Object)this.sequencingService.getExecutorService(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        this.sequencingService.getAdministrator().start();
        Assert.assertThat((Object)this.sequencingService.getExecutorService(), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }

    @Test
    public void shouldCreateExecutorServiceWhenStarted() {
        Assert.assertThat((Object)this.sequencingService.getExecutorService(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        this.sequencingService.getAdministrator().start();
        Assert.assertThat((Object)this.sequencingService.getExecutorService(), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailToSetStateToUnknownString() {
        this.sequencingService.getAdministrator().setState("asdf");
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailToSetStateToNullString() {
        this.sequencingService.getAdministrator().setState((String)null);
    }

    @Test
    public void shouldSetStateUsingLowercaseString() {
        Assert.assertThat((Object)this.sequencingService.getAdministrator().setState("started").isStarted(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.sequencingService.getAdministrator().setState("paused").isPaused(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.sequencingService.getAdministrator().setState("shutdown").isShutdown(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldSetStateUsingMixedCaseString() {
        Assert.assertThat((Object)this.sequencingService.getAdministrator().setState("StarTeD").isStarted(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.sequencingService.getAdministrator().setState("PauSed").isPaused(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.sequencingService.getAdministrator().setState("ShuTDowN").isShutdown(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldSetStateUsingUppercasString() {
        Assert.assertThat((Object)this.sequencingService.getAdministrator().setState("STARTED").isStarted(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.sequencingService.getAdministrator().setState("PAUSED").isPaused(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.sequencingService.getAdministrator().setState("SHUTDOWN").isShutdown(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldBePausedUponConstruction() {
        Assert.assertThat((Object)this.sequencingService.getAdministrator().isPaused(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.sequencingService.getAdministrator().getState(), (Matcher)Is.is((Object)ServiceAdministrator.State.PAUSED));
        Assert.assertThat((Object)this.sequencingService.getAdministrator().isShutdown(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.sequencingService.getAdministrator().isStarted(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldBeAbleToShutdownWhenNotStarted() {
        Assert.assertThat((Object)this.sequencingService.getAdministrator().isShutdown(), (Matcher)Is.is((Object)false));
        for (int i = 0; i != 3; ++i) {
            Assert.assertThat((Object)this.sequencingService.getAdministrator().shutdown().isShutdown(), (Matcher)Is.is((Object)true));
            Assert.assertThat((Object)this.sequencingService.getAdministrator().isPaused(), (Matcher)Is.is((Object)false));
            Assert.assertThat((Object)this.sequencingService.getAdministrator().isStarted(), (Matcher)Is.is((Object)false));
            ServiceAdministrator.State actualState = this.sequencingService.getAdministrator().getState();
            Assert.assertThat((Object)(actualState == ServiceAdministrator.State.SHUTDOWN || actualState == ServiceAdministrator.State.TERMINATED ? 1 : 0), (Matcher)Is.is((Object)true));
        }
    }

    @Test
    public void shouldBeAbleToBePauseAndRestarted() {
        Assert.assertThat((Object)this.sequencingService.getAdministrator().isShutdown(), (Matcher)Is.is((Object)false));
        for (int i = 0; i != 3; ++i) {
            Assert.assertThat((Object)this.sequencingService.getAdministrator().pause().isPaused(), (Matcher)Is.is((Object)true));
            Assert.assertThat((Object)this.sequencingService.getAdministrator().isStarted(), (Matcher)Is.is((Object)false));
            Assert.assertThat((Object)this.sequencingService.getAdministrator().isShutdown(), (Matcher)Is.is((Object)false));
            Assert.assertThat((Object)this.sequencingService.getAdministrator().getState(), (Matcher)Is.is((Object)ServiceAdministrator.State.PAUSED));
            Assert.assertThat((Object)this.sequencingService.getAdministrator().start().isStarted(), (Matcher)Is.is((Object)true));
            Assert.assertThat((Object)this.sequencingService.getAdministrator().isPaused(), (Matcher)Is.is((Object)false));
            Assert.assertThat((Object)this.sequencingService.getAdministrator().isShutdown(), (Matcher)Is.is((Object)false));
            Assert.assertThat((Object)this.sequencingService.getAdministrator().getState(), (Matcher)Is.is((Object)ServiceAdministrator.State.STARTED));
        }
    }

    @Test(expected=IllegalStateException.class)
    public void shouldNotBeAbleToBeRestartedAfterBeingShutdown() {
        Assert.assertThat((Object)this.sequencingService.getAdministrator().isShutdown(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.sequencingService.getAdministrator().shutdown().isShutdown(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.sequencingService.getAdministrator().isPaused(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.sequencingService.getAdministrator().isStarted(), (Matcher)Is.is((Object)false));
        ServiceAdministrator.State actualState = this.sequencingService.getAdministrator().getState();
        Assert.assertThat((Object)(actualState == ServiceAdministrator.State.SHUTDOWN || actualState == ServiceAdministrator.State.TERMINATED ? 1 : 0), (Matcher)Is.is((Object)true));
        this.sequencingService.getAdministrator().start();
    }

    @Test
    @Ignore
    public void shouldExecuteSequencersUponChangesToRepositoryThatMatchSequencerPathExpressions() throws Exception {
        String name = "MockSequencerA";
        String desc = "A mock sequencer that accumulates the number of times it's called";
        String classname = MockSequencerA.class.getName();
        String[] classpath = null;
        String[] pathExpressions = new String[]{"/testnodeC/testnodeD/@description => ."};
        SequencerConfig configA = new SequencerConfig(name, desc, Collections.emptyMap(), classname, classpath, pathExpressions);
        this.sequencingService.addSequencer(configA);
        Assert.assertThat((Object)this.sequencingService.getAdministrator().start().isStarted(), (Matcher)Is.is((Object)true));
        Graph graph = Graph.create((RepositorySource)this.sources.getSource(REPOSITORY_SOURCE_NAME), (ExecutionContext)this.executionContext);
        MockSequencerA sequencerA = (MockSequencerA)this.sequencingService.getSequencerLibrary().getInstances().get(0);
        Assert.assertThat((Object)sequencerA, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)sequencerA.getCounter(), (Matcher)Is.is((Object)0));
        sequencerA.setExpectedCount(1);
        Assert.assertThat((Object)this.sequencingService.getSequencerLibrary().getInstances(), (Matcher)JUnitMatchers.hasItem((Object)sequencerA));
        ((Graph.Batch)graph.batch().create("/testnodeC").with("jcr:primaryType", new Object[]{"nt:unstructured"}).and()).execute();
        Assert.assertThat((Object)sequencerA.getCounter(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)this.sequencingService.getSequencerLibrary().getInstances(), (Matcher)JUnitMatchers.hasItem((Object)sequencerA));
        ((Graph.Batch)graph.batch().create("/testnodeC/testnodeD").with("jcr:primaryType", new Object[]{"nt:unstructured"}).and()).execute();
        Assert.assertThat((Object)sequencerA.getCounter(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)this.sequencingService.getSequencerLibrary().getInstances(), (Matcher)JUnitMatchers.hasItem((Object)sequencerA));
        ((Graph.Batch)((Graph.BatchConjunction)((Graph.SetValuesTo)graph.batch().set("description").on("/testnodeC/testnodeD")).to("This is the value")).and()).execute();
        sequencerA.awaitExecution(4L, TimeUnit.SECONDS);
        Assert.assertThat((Object)sequencerA.getCounter(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)this.sequencingService.getSequencerLibrary().getInstances(), (Matcher)JUnitMatchers.hasItem((Object)sequencerA));
    }
}

