/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.repository.sequencer;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.hamcrest.core.IsSame;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.modeshape.common.collection.Problems;
import org.modeshape.common.collection.SimpleProblems;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.Graph;
import org.modeshape.graph.Location;
import org.modeshape.graph.Node;
import org.modeshape.graph.connector.RepositoryConnection;
import org.modeshape.graph.connector.inmemory.InMemoryRepositorySource;
import org.modeshape.graph.mimetype.MimeTypeDetector;
import org.modeshape.graph.mimetype.MimeTypeDetectors;
import org.modeshape.graph.observe.NetChangeObserver;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PathNotFoundException;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.sequencer.SequencerOutput;
import org.modeshape.graph.sequencer.StreamSequencer;
import org.modeshape.graph.sequencer.StreamSequencerContext;
import org.modeshape.repository.sequencer.SequencerConfig;
import org.modeshape.repository.sequencer.SequencerContext;
import org.modeshape.repository.sequencer.SequencerException;
import org.modeshape.repository.sequencer.SequencerOutputMap;
import org.modeshape.repository.sequencer.StreamSequencerAdapter;
import org.modeshape.repository.util.RepositoryNodePath;

public class StreamSequencerAdapterTest {
    private StreamSequencer streamSequencer;
    private StreamSequencerAdapter sequencer;
    private final String[] validExpressions = new String[]{"/a/* => /output"};
    private final SequencerConfig validConfig = new SequencerConfig("name", "desc", Collections.emptyMap(), "something.class", null, this.validExpressions);
    private SequencerOutputMap sequencerOutput;
    private final String sampleData = "The little brown fox didn't something bad.";
    private ExecutionContext context;
    private SequencerContext seqContext;
    private final String repositorySourceName = "repository";
    private final String repositoryWorkspaceName = "";
    private Problems problems;
    private Graph graph;
    private Property sequencedProperty;

    @Before
    public void beforeEach() {
        this.problems = new SimpleProblems();
        this.context = new ExecutionContext().with((MimeTypeDetector)new MimeTypeDetectors());
        final SequencerOutputMap finalOutput = this.sequencerOutput = new SequencerOutputMap(this.context.getValueFactories());
        InMemoryRepositorySource source = new InMemoryRepositorySource();
        source.setName("repository");
        this.graph = Graph.create((RepositoryConnection)source.getConnection(), (ExecutionContext)this.context);
        this.streamSequencer = new StreamSequencer(){

            public void sequence(InputStream stream, SequencerOutput output, StreamSequencerContext context) {
                for (SequencerOutputMap.Entry entry : finalOutput) {
                    Path nodePath = entry.getPath();
                    for (SequencerOutputMap.PropertyValue property : entry.getPropertyValues()) {
                        output.setProperty(nodePath, property.getName(), new Object[]{property.getValue()});
                    }
                }
            }
        };
        this.sequencer = new StreamSequencerAdapter(this.streamSequencer);
        this.seqContext = new SequencerContext(this.context, this.graph);
    }

    protected void testSequencer(final StreamSequencer sequencer) throws Throwable {
        StreamSequencer streamSequencer = new StreamSequencer(){

            public void sequence(InputStream stream, SequencerOutput output, StreamSequencerContext context) {
                sequencer.sequence(stream, output, context);
            }
        };
        StreamSequencerAdapter adapter = new StreamSequencerAdapter(streamSequencer);
        ((Graph)((Graph)this.graph.create("/a").and()).create("/a/b").and()).create("/a/b/c").and();
        ((Graph)this.graph.create("/d").and()).create("/d/e").and();
        ((Graph.SetValuesTo)this.graph.set("sequencedProperty").on("/a/b/c")).to((Object)new ByteArrayInputStream("The little brown fox didn't something bad.".getBytes()));
        Node inputNode = this.graph.getNodeAt("/a/b/c");
        Location location = Location.create((Path)((Path)this.context.getValueFactories().getPathFactory().create("/a/b/c")));
        Property sequencedProperty = inputNode.getProperty("sequencedProperty");
        NetChangeObserver.NetChange nodeChange = new NetChangeObserver.NetChange("", location, EnumSet.of(NetChangeObserver.ChangeType.PROPERTY_CHANGED), null, Collections.singleton(sequencedProperty), null);
        HashSet<RepositoryNodePath> outputPaths = new HashSet<RepositoryNodePath>();
        outputPaths.add(new RepositoryNodePath("repository", "", "/d/e"));
        this.sequencerOutput.setProperty("alpha/beta", "isSomething", new Object[]{true});
        adapter.execute(inputNode, "sequencedProperty", nodeChange, outputPaths, this.seqContext, this.problems);
    }

    @Test
    public void shouldNotHaveSequencerUponInstantiation() {
        Assert.assertThat((Object)this.sequencer.getConfiguration(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        this.sequencer.setConfiguration(this.validConfig);
        Assert.assertThat((Object)this.sequencer.getConfiguration(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.validConfig)));
    }

    @Test
    public void shouldExtractNullMixinTypesFromNullValue() {
        Assert.assertThat((Object)this.sequencer.extractMixinTypes(null), (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    @Test
    public void shouldExtractMixinTypesFromStringValue() {
        Assert.assertThat((Object)this.sequencer.extractMixinTypes((Object)"value"), (Matcher)Is.is((Object)new String[]{"value"}));
        Assert.assertThat((Object)this.sequencer.extractMixinTypes((Object)""), (Matcher)Is.is((Object)new String[]{""}));
    }

    @Test
    public void shouldExtractMixinTypesFromStringArrayValue() {
        Assert.assertThat((Object)this.sequencer.extractMixinTypes((Object)new String[]{"value1"}), (Matcher)Is.is((Object)new String[]{"value1"}));
        Assert.assertThat((Object)this.sequencer.extractMixinTypes((Object)new String[]{"value1", "value2"}), (Matcher)Is.is((Object)new String[]{"value1", "value2"}));
    }

    @Test
    public void shouldExtractMixinTypesFromStringArrayWithNullValue() {
        Assert.assertThat((Object)this.sequencer.extractMixinTypes((Object)new String[]{"value1", null, "value2"}), (Matcher)Is.is((Object)new String[]{"value1", null, "value2"}));
    }

    @Test
    public void shouldExecuteSequencerOnExistingNodeAndOutputToExistingNode() throws Exception {
        ((Graph)((Graph)this.graph.create("/a").and()).create("/a/b").and()).create("/a/b/c").and();
        ((Graph)this.graph.create("/d").and()).create("/d/e").and();
        ((Graph.SetValuesTo)this.graph.set("sequencedProperty").on("/a/b/c")).to((Object)new ByteArrayInputStream("The little brown fox didn't something bad.".getBytes()));
        Node nodeC = this.graph.getNodeAt("/a/b/c");
        Node nodeE = this.graph.getNodeAt("/d/e");
        Assert.assertThat((Object)nodeC, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)nodeE, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)nodeE.getChildren().size(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)nodeE.getProperties().size(), (Matcher)Is.is((Object)1));
        Location location = Location.create((Path)((Path)this.context.getValueFactories().getPathFactory().create("/a/b/c")));
        Property sequencedProperty = nodeC.getProperty("sequencedProperty");
        NetChangeObserver.NetChange nodeChange = new NetChangeObserver.NetChange("", location, EnumSet.of(NetChangeObserver.ChangeType.PROPERTY_CHANGED), null, Collections.singleton(sequencedProperty), null);
        HashSet<RepositoryNodePath> outputPaths = new HashSet<RepositoryNodePath>();
        outputPaths.add(new RepositoryNodePath("repository", "", "/d/e"));
        this.sequencerOutput.setProperty("alpha/beta", "isSomething", new Object[]{true});
        this.sequencer.execute(nodeC, "sequencedProperty", nodeChange, outputPaths, this.seqContext, this.problems);
    }

    @Test(expected=SequencerException.class)
    public void shouldExecuteSequencerOnExistingNodeWithMissingSequencedPropertyAndOutputToExistingNode() throws Exception {
        ((Graph)((Graph)this.graph.create("/a").and()).create("/a/b").and()).create("/a/b/c").and();
        ((Graph)this.graph.create("/d").and()).create("/d/e").and();
        Node nodeC = this.graph.getNodeAt("/a/b/c");
        Node nodeE = this.graph.getNodeAt("/d/e");
        Assert.assertThat((Object)nodeC, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)nodeE, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)nodeE.getChildren().size(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)nodeE.getProperties().size(), (Matcher)Is.is((Object)1));
        ((Graph.SetValuesTo)this.graph.set("sequencedProperty").on(nodeC.getLocation())).to((String)null);
        Location location = Location.create((Path)((Path)this.context.getValueFactories().getPathFactory().create("/a/b/c")));
        Property sequencedProperty = nodeC.getProperty("sequencedProperty");
        NetChangeObserver.NetChange nodeChange = new NetChangeObserver.NetChange("", location, EnumSet.of(NetChangeObserver.ChangeType.PROPERTY_CHANGED), null, Collections.singleton(sequencedProperty), null);
        HashSet<RepositoryNodePath> outputPaths = new HashSet<RepositoryNodePath>();
        outputPaths.add(new RepositoryNodePath("repository", "", "/d/e"));
        this.sequencerOutput.setProperty("alpha/beta", "isSomething", new Object[]{true});
        this.sequencer.execute(nodeC, "sequencedProperty", nodeChange, outputPaths, this.seqContext, this.problems);
    }

    @Test
    public void shouldExecuteSequencerOnExistingNodeAndOutputToMultipleExistingNodes() throws Exception {
        ((Graph)((Graph)this.graph.create("/a").and()).create("/a/b").and()).create("/a/b/c").and();
        ((Graph)this.graph.create("/d").and()).create("/d/e").and();
        ((Graph.SetValuesTo)this.graph.set("sequencedProperty").on("/a/b/c")).to((Object)new ByteArrayInputStream("The little brown fox didn't something bad.".getBytes()));
        Node nodeC = this.graph.getNodeAt("/a/b/c");
        Node nodeE = this.graph.getNodeAt("/d/e");
        Assert.assertThat((Object)nodeC, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)nodeE, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)nodeE.getChildren().size(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)nodeE.getProperties().size(), (Matcher)Is.is((Object)1));
        Location location = Location.create((Path)((Path)this.context.getValueFactories().getPathFactory().create("/a/b/c")));
        Property sequencedProperty = nodeC.getProperty("sequencedProperty");
        NetChangeObserver.NetChange nodeChange = new NetChangeObserver.NetChange("", location, EnumSet.of(NetChangeObserver.ChangeType.PROPERTY_CHANGED), null, Collections.singleton(sequencedProperty), null);
        HashSet<RepositoryNodePath> outputPaths = new HashSet<RepositoryNodePath>();
        outputPaths.add(new RepositoryNodePath("repository", "", "/d/e"));
        outputPaths.add(new RepositoryNodePath("repository", "", "/x/y/z"));
        this.sequencerOutput.setProperty("alpha/beta", "isSomething", new Object[]{true});
        this.sequencer.execute(nodeC, "sequencedProperty", nodeChange, outputPaths, this.seqContext, this.problems);
        Assert.assertThat((Object)this.graph.getNodeAt("/d/e"), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)this.graph.getNodeAt("/x/y/z"), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }

    @Test
    public void shouldExecuteSequencerOnExistingNodeAndOutputToNonExistingNode() throws Exception {
        ((Graph)((Graph)this.graph.create("/a").and()).create("/a/b").and()).create("/a/b/c").and();
        ((Graph.SetValuesTo)this.graph.set("sequencedProperty").on("/a/b/c")).to((Object)new ByteArrayInputStream("The little brown fox didn't something bad.".getBytes()));
        Node nodeC = this.graph.getNodeAt("/a/b/c");
        try {
            this.graph.getNodeAt("/d");
            Assert.fail();
        }
        catch (PathNotFoundException pnfe) {
            // empty catch block
        }
        Assert.assertThat((Object)nodeC, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Location location = Location.create((Path)((Path)this.context.getValueFactories().getPathFactory().create("/a/b/c")));
        Property sequencedProperty = nodeC.getProperty("sequencedProperty");
        NetChangeObserver.NetChange nodeChange = new NetChangeObserver.NetChange("", location, EnumSet.of(NetChangeObserver.ChangeType.PROPERTY_CHANGED), null, Collections.singleton(sequencedProperty), null);
        HashSet<RepositoryNodePath> outputPaths = new HashSet<RepositoryNodePath>();
        outputPaths.add(new RepositoryNodePath("repository", "", "/d/e"));
        this.sequencerOutput.setProperty("alpha/beta", "isSomething", new Object[]{true});
        this.sequencer.execute(nodeC, "sequencedProperty", nodeChange, outputPaths, this.seqContext, this.problems);
        Assert.assertThat((Object)this.graph.getNodeAt("/d/e"), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }

    @Test
    public void shouldExecuteSequencerOnExistingNodeAndOutputToMultipleNonExistingNodes() throws Exception {
        ((Graph)((Graph)this.graph.create("/a").and()).create("/a/b").and()).create("/a/b/c").and();
        ((Graph.SetValuesTo)this.graph.set("sequencedProperty").on("/a/b/c")).to((Object)new ByteArrayInputStream("The little brown fox didn't something bad.".getBytes()));
        Node nodeC = this.graph.getNodeAt("/a/b/c");
        try {
            this.graph.getNodeAt("/d");
            Assert.fail();
        }
        catch (PathNotFoundException pnfe) {
            // empty catch block
        }
        try {
            this.graph.getNodeAt("/x");
            Assert.fail();
        }
        catch (PathNotFoundException pnfe) {
            // empty catch block
        }
        Assert.assertThat((Object)nodeC, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Location location = Location.create((Path)((Path)this.context.getValueFactories().getPathFactory().create("/a/b/c")));
        Property sequencedProperty = nodeC.getProperty("sequencedProperty");
        NetChangeObserver.NetChange nodeChange = new NetChangeObserver.NetChange("", location, EnumSet.of(NetChangeObserver.ChangeType.PROPERTY_CHANGED), null, Collections.singleton(sequencedProperty), null);
        HashSet<RepositoryNodePath> outputPaths = new HashSet<RepositoryNodePath>();
        outputPaths.add(new RepositoryNodePath("repository", "", "/d/e"));
        outputPaths.add(new RepositoryNodePath("repository", "", "/x/y/z"));
        outputPaths.add(new RepositoryNodePath("repository", "", "/x/z"));
        this.sequencerOutput.setProperty("alpha/beta", "isSomething", new Object[]{true});
        this.sequencer.execute(nodeC, "sequencedProperty", nodeChange, outputPaths, this.seqContext, this.problems);
        Assert.assertThat((Object)this.graph.getNodeAt("/d/e"), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)this.graph.getNodeAt("/x/y/z"), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)this.graph.getNodeAt("/x/z"), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)this.graph.getNodeAt("/d/e/alpha/beta").getProperty("isSomething").getFirstValue().toString(), (Matcher)Is.is((Object)"true"));
        Assert.assertThat((Object)this.graph.getNodeAt("/x/y/z/alpha/beta").getProperty("isSomething").getFirstValue().toString(), (Matcher)Is.is((Object)"true"));
        Assert.assertThat((Object)this.graph.getNodeAt("/x/z/alpha/beta").getProperty("isSomething").getFirstValue().toString(), (Matcher)Is.is((Object)"true"));
    }

    @Test
    public void shouldSequencerOutputProvideAccessToNamespaceRegistry() {
        Assert.assertThat((Object)this.context.getNamespaceRegistry(), (Matcher)IsNull.notNullValue());
    }

    @Test
    public void shouldPassNonNullInputStreamToSequencer() throws Throwable {
        this.testSequencer(new StreamSequencer(){

            public void sequence(InputStream stream, SequencerOutput output, StreamSequencerContext context) {
                Assert.assertThat((Object)stream, (Matcher)IsNull.notNullValue());
            }
        });
    }

    @Test
    public void shouldPassNonNullSequencerOutputToSequencer() throws Throwable {
        this.testSequencer(new StreamSequencer(){

            public void sequence(InputStream stream, SequencerOutput output, StreamSequencerContext context) {
                Assert.assertThat((Object)output, (Matcher)IsNull.notNullValue());
            }
        });
    }

    @Test
    public void shouldPassNonNullSequencerContextToSequencer() throws Throwable {
        this.testSequencer(new StreamSequencer(){

            public void sequence(InputStream stream, SequencerOutput output, StreamSequencerContext context) {
                Assert.assertThat((Object)context, (Matcher)IsNull.notNullValue());
            }
        });
    }

    @Test
    public void shouldProvideNamespaceRegistry() throws Exception {
        this.sequencedProperty = (Property)Mockito.mock(Property.class);
        ((Graph)((Graph)this.graph.create("/a").and()).create("/a/b").and()).create("/a/b/c").and();
        Node input = this.graph.getNodeAt("/a/b/c");
        StreamSequencerContext sequencerContext = this.sequencer.createStreamSequencerContext(input, this.sequencedProperty, this.seqContext, this.problems);
        Assert.assertThat((Object)sequencerContext.getNamespaceRegistry(), (Matcher)IsNull.notNullValue());
    }

    @Test
    public void shouldProvideValueFactories() throws Exception {
        this.sequencedProperty = (Property)Mockito.mock(Property.class);
        ((Graph)((Graph)this.graph.create("/a").and()).create("/a/b").and()).create("/a/b/c").and();
        Node input = this.graph.getNodeAt("/a/b/c");
        StreamSequencerContext sequencerContext = this.sequencer.createStreamSequencerContext(input, this.sequencedProperty, this.seqContext, this.problems);
        Assert.assertThat((Object)sequencerContext.getValueFactories(), (Matcher)IsNull.notNullValue());
    }

    @Test
    public void shouldProvidePathToInput() throws Exception {
        this.sequencedProperty = (Property)Mockito.mock(Property.class);
        ((Graph)((Graph)this.graph.create("/a").and()).create("/a/b").and()).create("/a/b/c").and();
        Node input = this.graph.getNodeAt("/a/b/c");
        StreamSequencerContext sequencerContext = this.sequencer.createStreamSequencerContext(input, this.sequencedProperty, this.seqContext, this.problems);
        Assert.assertThat((Object)sequencerContext.getInputPath(), (Matcher)Is.is((Object)this.context.getValueFactories().getPathFactory().create("/a/b/c")));
    }

    @Test
    public void shouldNeverReturnNullInputProperties() throws Exception {
        this.sequencedProperty = (Property)Mockito.mock(Property.class);
        ((Graph)((Graph)this.graph.create("/a").and()).create("/a/b").and()).create("/a/b/c").and();
        Node input = this.graph.getNodeAt("/a/b/c");
        StreamSequencerContext sequencerContext = this.sequencer.createStreamSequencerContext(input, this.sequencedProperty, this.seqContext, this.problems);
        Assert.assertThat((Object)sequencerContext.getInputProperties(), (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)sequencerContext.getInputProperties().isEmpty(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldProvideInputProperties() throws Exception {
        this.sequencedProperty = (Property)Mockito.mock(Property.class);
        ((Graph)((Graph)this.graph.create("/a").and()).create("/a/b").and()).create("/a/b/c").and();
        ((Graph.SetValuesTo)this.graph.set("x").on("/a/b/c")).to(true);
        ((Graph.SetValuesTo)this.graph.set("y").on("/a/b/c")).to(Arrays.asList("asdf", "xyzzy"));
        Node input = this.graph.getNodeAt("/a/b/c");
        StreamSequencerContext sequencerContext = this.sequencer.createStreamSequencerContext(input, this.sequencedProperty, this.seqContext, this.problems);
        Assert.assertThat((Object)sequencerContext.getInputProperties(), (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)sequencerContext.getInputProperties().isEmpty(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)sequencerContext.getInputProperties().size(), (Matcher)Is.is((Object)3));
        this.verifyProperty(sequencerContext, "x", true);
        this.verifyProperty(sequencerContext, "y", "asdf", "xyzzy");
    }

    @Test
    public void shouldCreateSequencerContextThatProvidesMimeType() throws Exception {
        this.sequencedProperty = (Property)Mockito.mock(Property.class);
        ((Graph)((Graph)this.graph.create("/a").and()).create("/a/b").and()).create("/a/b/c").and();
        Node input = this.graph.getNodeAt("/a/b/c");
        StreamSequencerContext sequencerContext = this.sequencer.createStreamSequencerContext(input, this.sequencedProperty, this.seqContext, this.problems);
        Assert.assertThat((Object)sequencerContext.getMimeType(), (Matcher)Is.is((Object)"text/plain"));
    }

    private Name nameFor(String raw) {
        return (Name)this.context.getValueFactories().getNameFactory().create(raw);
    }

    @Test
    public void shouldNotCreateExtraNodesWhenSavingOutput() throws Exception {
        SequencerOutputMap output = new SequencerOutputMap(this.context.getValueFactories());
        output.setProperty("a", "property1", new Object[]{"value1"});
        output.setProperty("a/b", "property1", new Object[]{"value1"});
        output.setProperty("a/b", "property2", new Object[]{"value2"});
        output.setProperty("a/b[2]", "property1", new Object[]{"value1"});
        output.setProperty("a/b[2]/c", "property1", new Object[]{"value1"});
        HashSet builtPaths = new HashSet();
        this.sequencer.saveOutput("/", output, this.seqContext, builtPaths);
        this.seqContext.getDestination().submit();
        Node rootNode = this.graph.getNodeAt("/");
        Assert.assertThat((Object)rootNode.getChildren().size(), (Matcher)Is.is((Object)1));
        Node nodeA = this.graph.getNodeAt("/a");
        Map props = nodeA.getPropertiesByName();
        Assert.assertThat((Object)nodeA.getChildren().size(), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)props.size(), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)((Property)props.get(this.nameFor("property1"))).getFirstValue().toString(), (Matcher)Is.is((Object)"value1"));
        Node nodeB = this.graph.getNodeAt("/a/b[1]");
        props = nodeB.getPropertiesByName();
        Assert.assertThat((Object)props.size(), (Matcher)Is.is((Object)3));
        Assert.assertThat((Object)((Property)props.get(this.nameFor("property1"))).getFirstValue().toString(), (Matcher)Is.is((Object)"value1"));
        Assert.assertThat((Object)((Property)props.get(this.nameFor("property2"))).getFirstValue().toString(), (Matcher)Is.is((Object)"value2"));
        Node nodeB2 = this.graph.getNodeAt("/a/b[2]");
        props = nodeB2.getPropertiesByName();
        Assert.assertThat((Object)props.size(), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)((Property)props.get(this.nameFor("property1"))).getFirstValue().toString(), (Matcher)Is.is((Object)"value1"));
        Node nodeC = this.graph.getNodeAt("/a/b[2]/c");
        props = nodeC.getPropertiesByName();
        Assert.assertThat((Object)props.size(), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)((Property)props.get(this.nameFor("property1"))).getFirstValue().toString(), (Matcher)Is.is((Object)"value1"));
    }

    private void verifyProperty(StreamSequencerContext context, String name, Object ... values) {
        Property prop = context.getInputProperty((Name)context.getValueFactories().getNameFactory().create(name));
        Assert.assertThat((Object)prop, (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)prop.getName(), (Matcher)Is.is((Object)context.getValueFactories().getNameFactory().create(name)));
        Assert.assertThat((Object)prop.isEmpty(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)prop.size(), (Matcher)Is.is((Object)values.length));
        Assert.assertThat((Object)prop.isMultiple(), (Matcher)Is.is((Object)(values.length > 1 ? 1 : 0)));
        Assert.assertThat((Object)prop.isSingle(), (Matcher)Is.is((Object)(values.length == 1 ? 1 : 0)));
        Iterator iter = prop.getValues();
        for (Object val : values) {
            Assert.assertThat((Object)iter.hasNext(), (Matcher)Is.is((Object)true));
            Assert.assertThat(iter.next(), (Matcher)Is.is((Object)val));
        }
    }
}

