/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.repository.util;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.jcr.Credentials;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import org.modeshape.common.SystemFailureException;
import org.modeshape.common.util.CheckArg;
import org.modeshape.repository.util.SessionFactory;

public abstract class AbstractSessionFactory
implements SessionFactory {
    protected static char[] DEFAULT_DELIMITERS = new char[]{'/'};
    private final char[] workspaceDelims;
    private final String workspaceDelimsRegexCharacterSet;
    private final Map<String, Credentials> credentials = new ConcurrentHashMap<String, Credentials>();

    public AbstractSessionFactory() {
        this(null);
    }

    public AbstractSessionFactory(char ... workspaceDelimiters) {
        this.workspaceDelims = workspaceDelimiters == null || workspaceDelimiters.length == 0 ? DEFAULT_DELIMITERS : workspaceDelimiters;
        StringBuilder sb = new StringBuilder();
        block6: for (char delim : this.workspaceDelims) {
            switch (delim) {
                case '\\': {
                    sb.append("\\");
                    continue block6;
                }
                case ']': {
                    sb.append("\\]");
                    continue block6;
                }
                case '-': {
                    sb.append("\\-");
                    continue block6;
                }
                case '^': {
                    sb.append("\\^");
                    continue block6;
                }
                default: {
                    sb.append(delim);
                }
            }
        }
        this.workspaceDelimsRegexCharacterSet = sb.toString();
    }

    public void registerRepository(String name, Repository repository) {
        assert (name != null);
        name = name.replaceAll("[" + this.workspaceDelimsRegexCharacterSet + "]+$", "");
        if (repository != null) {
            this.doRegisterRepository(name, repository);
        } else {
            this.doUnregisterRepository(name);
        }
    }

    protected abstract void doRegisterRepository(String var1, Repository var2) throws SystemFailureException;

    protected abstract void doUnregisterRepository(String var1) throws SystemFailureException;

    protected abstract Repository findRegisteredRepository(String var1) throws SystemFailureException;

    public boolean registerCredentials(String name, String username, char[] password) {
        if (password == null && username != null) {
            password = new char[]{};
        }
        SimpleCredentials creds = username == null ? null : new SimpleCredentials(username, password);
        return this.registerCredentials(name, (Credentials)creds);
    }

    public boolean registerCredentials(String name, Credentials credentials) {
        boolean foundExisting = false;
        String string = name = name != null ? name.trim() : null;
        foundExisting = credentials == null ? this.credentials.remove(name) != null : this.credentials.put(name, credentials) != null;
        return foundExisting;
    }

    public boolean removeCredentials(String name) {
        return this.registerCredentials(name, null);
    }

    @Override
    public Session createSession(String name) throws RepositoryException {
        CheckArg.isNotNull((Object)name, (String)"session name");
        name = name.trim();
        String repositoryName = this.getRepositoryName(name);
        Repository repository = this.findRegisteredRepository(repositoryName);
        String workspaceName = this.getWorkspaceName(name);
        Credentials creds = this.credentials.get(name);
        return repository.login(creds, workspaceName);
    }

    protected String getWorkspaceName(String name) {
        assert (name != null);
        int index = this.getIndexOfLastWorkspaceDelimiter(name);
        if (index == -1) {
            return null;
        }
        if (index + 1 == name.length()) {
            return null;
        }
        return name.substring(index + 1);
    }

    protected String getRepositoryName(String name) {
        assert (name != null);
        int index = this.getIndexOfLastWorkspaceDelimiter(name);
        if (index == -1) {
            return name;
        }
        if (index + 1 == name.length()) {
            return name.substring(0, index);
        }
        return name.substring(0, index);
    }

    protected int getIndexOfLastWorkspaceDelimiter(String name) {
        int index = -1;
        for (char delim : this.workspaceDelims) {
            int i = name.lastIndexOf(delim);
            index = Math.max(index, i);
        }
        return index;
    }
}

