/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.repository.util;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.jcr.Repository;
import org.modeshape.common.SystemFailureException;
import org.modeshape.repository.RepositoryI18n;
import org.modeshape.repository.util.AbstractSessionFactory;

public class SimpleSessionFactory
extends AbstractSessionFactory {
    private final Map<String, Repository> repositories = new ConcurrentHashMap<String, Repository>();

    public SimpleSessionFactory() {
    }

    public SimpleSessionFactory(char ... workspaceDelimiters) {
        super(workspaceDelimiters);
    }

    @Override
    protected void doRegisterRepository(String name, Repository repository) {
        this.repositories.put(name, repository);
    }

    @Override
    protected void doUnregisterRepository(String name) throws SystemFailureException {
        if (this.repositories.remove(name) == null) {
            throw new SystemFailureException(RepositoryI18n.unableToRemoveRepository.text(new Object[]{name}));
        }
    }

    @Override
    protected Repository findRegisteredRepository(String name) throws SystemFailureException {
        Repository repository = this.repositories.get(name);
        if (repository == null) {
            throw new SystemFailureException(RepositoryI18n.unableToFindRepositoryWithName.text(new Object[]{name}));
        }
        return repository;
    }
}

