/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.repository.sequencer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.jcip.annotations.Immutable;
import net.jcip.annotations.NotThreadSafe;
import org.modeshape.common.util.CheckArg;
import org.modeshape.graph.JcrLexicon;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PathFactory;
import org.modeshape.graph.property.ValueFactories;
import org.modeshape.graph.property.ValueFactory;
import org.modeshape.graph.sequencer.SequencerOutput;

@NotThreadSafe
public class SequencerOutputMap
implements SequencerOutput,
Iterable<Entry> {
    private final Map<Path, List<PropertyValue>> data;
    private transient boolean valuesSorted = true;
    private final ValueFactories factories;

    public SequencerOutputMap(ValueFactories factories) {
        CheckArg.isNotNull((Object)factories, (String)"factories");
        this.data = new LinkedHashMap<Path, List<PropertyValue>>();
        this.factories = factories;
    }

    ValueFactories getFactories() {
        return this.factories;
    }

    public void setProperty(Path nodePath, Name propertyName, Object ... values) {
        CheckArg.isNotNull((Object)nodePath, (String)"nodePath");
        CheckArg.isNotNull((Object)propertyName, (String)"property");
        List<PropertyValue> properties = this.data.get(nodePath);
        if (properties == null) {
            if (values == null || values.length == 0 || values.length == 1 && values[0] == null) {
                return;
            }
            properties = new ArrayList<PropertyValue>();
            this.data.put(nodePath, properties);
        }
        if (values == null || values.length == 0 || values.length == 1 && values[0] == null) {
            properties.remove(new PropertyValue(propertyName, null));
        } else {
            Object[] propValue = values.length == 1 ? values[0] : values;
            PropertyValue value = new PropertyValue(propertyName, propValue);
            properties.add(value);
            this.valuesSorted = false;
        }
    }

    @Deprecated
    public void setProperty(String nodePath, String property, Object ... values) {
        CheckArg.isNotEmpty((String)nodePath, (String)"nodePath");
        CheckArg.isNotEmpty((String)property, (String)"property");
        Path path = (Path)this.factories.getPathFactory().create(nodePath);
        Name propertyName = (Name)this.factories.getNameFactory().create(property);
        this.setProperty(path, propertyName, values);
    }

    @Deprecated
    public void setReference(String nodePath, String propertyName, String ... paths) {
        PathFactory pathFactory = this.factories.getPathFactory();
        Path path = (Path)pathFactory.create(nodePath);
        Name name = (Name)this.factories.getNameFactory().create(propertyName);
        Path[] values = null;
        if (paths != null && paths.length != 0) {
            values = new Path[paths.length];
            int len = paths.length;
            for (int i = 0; i != len; ++i) {
                String pathValue = paths[i];
                values[i] = pathFactory.create(pathValue);
            }
        }
        this.setProperty(path, name, values);
    }

    public int size() {
        return this.data.size();
    }

    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    protected List<PropertyValue> removeProperties(Path nodePath) {
        return this.data.remove(nodePath);
    }

    protected List<PropertyValue> getProperties(Path nodePath) {
        return this.data.get(nodePath);
    }

    @Override
    public Iterator<Entry> iterator() {
        return new EntryIterator(this.data.keySet().iterator());
    }

    protected void sortValues() {
        if (!this.valuesSorted) {
            for (List<PropertyValue> values : this.data.values()) {
                if (values.size() <= 1) continue;
                Collections.sort(values);
            }
            this.valuesSorted = true;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        ValueFactory strings = this.factories.getStringFactory();
        for (Map.Entry<Path, List<PropertyValue>> entry : this.data.entrySet()) {
            sb.append((String)strings.create(entry.getKey())).append(" = ");
            List<PropertyValue> values = entry.getValue();
            if (values.size() == 1) {
                sb.append((String)strings.create((Object)values.get(0)));
            } else {
                boolean first = true;
                sb.append('[');
                for (PropertyValue value : values) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(", ");
                    }
                    sb.append((String)strings.create((Object)value));
                }
                sb.append(']');
            }
            sb.append('\n');
        }
        return sb.toString();
    }

    protected class EntryIterator
    implements Iterator<Entry> {
        private Path last;
        private final Iterator<Path> iter;

        protected EntryIterator(Iterator<Path> iter) {
            this.iter = iter;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public Entry next() {
            this.last = this.iter.next();
            return new Entry(this.last, SequencerOutputMap.this.getProperties(this.last));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove() {
            if (this.last == null) {
                throw new IllegalStateException();
            }
            try {
                SequencerOutputMap.this.removeProperties(this.last);
            }
            finally {
                this.last = null;
            }
        }
    }

    @Immutable
    public class Entry {
        private final Path path;
        private final Name primaryType;
        private final List<PropertyValue> properties;

        protected Entry(Path path, List<PropertyValue> properties) {
            assert (path != null);
            assert (properties != null);
            this.path = path;
            this.properties = properties;
            if (this.properties.size() > 0 && this.properties.get(0).getName().equals("jcr:primaryType")) {
                PropertyValue primaryTypeProperty = this.properties.remove(0);
                this.primaryType = (Name)SequencerOutputMap.this.getFactories().getNameFactory().create(primaryTypeProperty.getValue());
            } else {
                this.primaryType = null;
            }
        }

        public Path getPath() {
            return this.path;
        }

        public Name getPrimaryTypeValue() {
            return this.primaryType;
        }

        public List<PropertyValue> getPropertyValues() {
            return SequencerOutputMap.this.getProperties(this.path);
        }
    }

    @Immutable
    public class PropertyValue
    implements Comparable<PropertyValue> {
        private final Name name;
        private final Object value;

        protected PropertyValue(Name propertyName, Object value) {
            this.name = propertyName;
            this.value = value;
        }

        public Name getName() {
            return this.name;
        }

        public Object getValue() {
            return this.value;
        }

        @Override
        public int compareTo(PropertyValue that) {
            if (this == that) {
                return 0;
            }
            if (this.name.equals(JcrLexicon.PRIMARY_TYPE)) {
                return -1;
            }
            if (that.name.equals(JcrLexicon.PRIMARY_TYPE)) {
                return 1;
            }
            return this.name.compareTo((Object)that.name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof PropertyValue) {
                PropertyValue that = (PropertyValue)obj;
                return this.getName().equals(that.getName());
            }
            return false;
        }

        public String toString() {
            return "[" + this.name + "=" + this.value + "]";
        }
    }
}

