/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.schematic.internal.schema;

import java.io.InputStream;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNot;
import org.hamcrest.core.IsSame;
import org.infinispan.schematic.SchemaLibrary;
import org.infinispan.schematic.SchemaValidationTest;
import org.infinispan.schematic.Schematic;
import org.infinispan.schematic.document.Document;
import org.infinispan.schematic.document.Json;
import org.infinispan.schematic.document.ParsingException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class DocumentTransformerTest {
    protected static final String PARTS_SCHEMA_URI = "json/schema/spec-example-doc.json";
    private static SchemaLibrary schemas;
    private static boolean print;

    @BeforeClass
    public static void beforeAll() throws Exception {
        schemas = Schematic.createSchemaLibrary();
        schemas.put("http://json-schema.org/draft-03/schema#", Json.read((InputStream)DocumentTransformerTest.resource("json/schema/draft-03/schema.json")));
        schemas.put(PARTS_SCHEMA_URI, Json.read((InputStream)DocumentTransformerTest.resource("json/schema/spec-example.json")));
    }

    @Before
    public void beforeEach() {
        print = false;
    }

    @Test
    public void shouldNotTransformDocumentWithNoMismatchedValues() throws Exception {
        Document doc = DocumentTransformerTest.doc("{ 'name' : 'Acme Bottle Opener', 'id' : 123 , 'price' : 2.99, 'tags' : [ 'easy', 'under-10-dollars' ] }");
        DocumentTransformerTest.transform(doc, PARTS_SCHEMA_URI, 0);
    }

    @Test
    public void shouldTransformDocumentWithStringValueWhereIntegerExpected() throws Exception {
        print = true;
        Document doc = DocumentTransformerTest.doc("{ 'name' : 'Acme Bottle Opener', 'id' : '123' , 'price' : 2.99, 'tags' : [ 'easy', 'under-10-dollars' ] }");
        DocumentTransformerTest.transform(doc, PARTS_SCHEMA_URI, 1);
    }

    protected static InputStream resource(String resourcePath) {
        InputStream result = SchemaValidationTest.class.getClassLoader().getResourceAsStream(resourcePath);
        assert (result != null) : "Could not find resource \"" + resourcePath + "\"";
        return result;
    }

    protected static Document doc(String content) throws ParsingException {
        Document doc = Json.read((String)content);
        if (print) {
            System.out.println(doc);
        }
        return doc;
    }

    protected static Document transform(Document doc, String schemaUri, int numExpectedMismatchedValues) {
        SchemaLibrary.Results results = schemas.validate(doc, schemaUri);
        if (print) {
            System.out.println(results);
        }
        if (numExpectedMismatchedValues > 0) {
            Assert.assertThat((String)"expected mismatch errors, but found none", (Object)results.hasOnlyTypeMismatchErrors(), (Matcher)Is.is((Object)true));
            Assert.assertThat((String)"expected different number of mismatches", (Object)results.errorCount(), (Matcher)Is.is((Object)numExpectedMismatchedValues));
        } else {
            Assert.assertThat((String)"expected no mismatch errors", (Object)results.hasOnlyTypeMismatchErrors(), (Matcher)Is.is((Object)false));
            Assert.assertThat((String)"expected to find problems", (Object)results.hasProblems(), (Matcher)Is.is((Object)false));
        }
        Document output = schemas.convertValues(doc, results);
        if (numExpectedMismatchedValues > 0) {
            Assert.assertThat((Object)output, (Matcher)Is.is((Matcher)IsNot.not((Matcher)IsSame.sameInstance((Object)doc))));
            SchemaLibrary.Results newResults = schemas.validate(output, schemaUri);
            Assert.assertThat((Object)newResults.hasErrors(), (Matcher)Is.is((Object)false));
            if (print) {
                System.out.println("After converting: " + output);
                System.out.println(newResults);
            }
        } else {
            Assert.assertThat((Object)output, (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)doc)));
        }
        return output;
    }
}

