/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.schematic.document;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Set;
import org.infinispan.marshall.AbstractExternalizer;
import org.infinispan.schematic.document.Immutable;
import org.infinispan.schematic.internal.document.BsonUtils;
import org.infinispan.util.Base64;
import org.infinispan.util.Util;

@Immutable
public final class ObjectId {
    private final int time;
    private final int machine;
    private final int process;
    private final int inc;

    public ObjectId(int time, int machine, int process, int inc) {
        this.time = time;
        this.machine = machine;
        this.process = process;
        this.inc = inc;
    }

    public int getTime() {
        return this.time;
    }

    public int getMachine() {
        return this.machine;
    }

    public int getProcess() {
        return this.process;
    }

    public int getInc() {
        return this.inc;
    }

    public byte[] getBytes() {
        byte[] b = new byte[12];
        BsonUtils.writeObjectId(this, b);
        return b;
    }

    public String getBytesInBase64() {
        return Base64.encodeBytes((byte[])this.getBytes());
    }

    public String getBytesInBase16() {
        byte[] b = this.getBytes();
        StringBuilder buf = new StringBuilder(24);
        for (int i = 0; i < b.length; ++i) {
            int x = b[i] & 0xFF;
            String s = Integer.toHexString(x);
            if (s.length() == 1) {
                buf.append("0");
            }
            buf.append(s);
        }
        return buf.toString();
    }

    public int hashCode() {
        return this.getTime();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ObjectId) {
            ObjectId that = (ObjectId)obj;
            return this.getTime() == that.getTime() && this.getMachine() == that.getMachine() && this.getProcess() == this.getProcess() && this.getInc() == that.getInc();
        }
        return false;
    }

    public String toString() {
        return "ObjectID(" + this.time + ':' + this.machine + ':' + this.process + ':' + this.inc + ')';
    }

    public static class Externalizer
    extends AbstractExternalizer<ObjectId> {
        private static final long serialVersionUID = 1L;

        public void writeObject(ObjectOutput output, ObjectId id) throws IOException {
            output.write(id.getMachine());
            output.write(id.getTime());
            output.write(id.getProcess());
            output.write(id.getInc());
        }

        public ObjectId readObject(ObjectInput input) throws IOException {
            int time = input.readInt();
            int mach = input.readInt();
            int proc = input.readInt();
            int inc = input.readInt();
            return new ObjectId(time, mach, proc, inc);
        }

        public Integer getId() {
            return 1617;
        }

        public Set<Class<? extends ObjectId>> getTypeClasses() {
            return Util.asSet((Object[])new Class[]{ObjectId.class});
        }
    }
}

