/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.schematic.internal;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.infinispan.atomic.Delta;
import org.infinispan.atomic.DeltaAware;
import org.infinispan.marshall.AbstractExternalizer;
import org.infinispan.schematic.internal.SchematicEntryLiteral;
import org.infinispan.schematic.internal.delta.DocumentObserver;
import org.infinispan.schematic.internal.delta.Operation;
import org.infinispan.util.Util;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class SchematicEntryDelta
implements Delta,
DocumentObserver {
    private static final Log log = LogFactory.getLog(SchematicEntryDelta.class);
    private static final boolean trace = log.isTraceEnabled();
    private List<Operation> changeLog;

    public DeltaAware merge(DeltaAware d) {
        SchematicEntryLiteral other = d != null && d instanceof SchematicEntryLiteral ? (SchematicEntryLiteral)d : new SchematicEntryLiteral();
        if (this.changeLog != null) {
            for (Operation o : this.changeLog) {
                o.replay(other.mutableMetadata());
            }
        }
        other.commit();
        return other;
    }

    @Override
    public void addOperation(Operation o) {
        if (this.changeLog == null) {
            this.changeLog = new LinkedList<Operation>();
        }
        this.changeLog.add(o);
    }

    public String toString() {
        return "SchematicValueDelta{changeLog=" + this.changeLog + '}';
    }

    public int getChangeLogSize() {
        return this.changeLog == null ? 0 : this.changeLog.size();
    }

    public static class Externalizer
    extends AbstractExternalizer<SchematicEntryDelta> {
        private static final long serialVersionUID = 1L;

        public void writeObject(ObjectOutput output, SchematicEntryDelta delta) throws IOException {
            if (trace) {
                log.tracef("Serializing changeLog %s", (Object)delta.changeLog);
            }
            output.writeObject(delta.changeLog);
        }

        public SchematicEntryDelta readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            SchematicEntryDelta delta = new SchematicEntryDelta();
            delta.changeLog = (List)input.readObject();
            if (trace) {
                log.tracef("Deserialized changeLog %s", (Object)delta.changeLog);
            }
            return delta;
        }

        public Integer getId() {
            return 1601;
        }

        public Set<Class<? extends SchematicEntryDelta>> getTypeClasses() {
            return Util.asSet((Object[])new Class[]{SchematicEntryDelta.class});
        }
    }
}

