/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.schematic.internal;

import org.infinispan.Cache;
import org.infinispan.batch.AutoBatchSupport;
import org.infinispan.batch.BatchContainer;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.InvocationContextContainer;
import org.infinispan.marshall.MarshalledValue;
import org.infinispan.schematic.SchematicEntry;
import org.infinispan.schematic.document.Binary;
import org.infinispan.schematic.document.Document;
import org.infinispan.schematic.document.EditableDocument;
import org.infinispan.schematic.internal.SchematicEntryLiteral;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class SchematicEntryProxy
extends AutoBatchSupport
implements SchematicEntry {
    private static final Log log = LogFactory.getLog(SchematicEntryProxy.class);
    private static final boolean trace = log.isTraceEnabled();
    final Cache<String, SchematicEntry> cache;
    final String key;
    final InvocationContextContainer icc;
    volatile boolean startedReadingValue = false;

    SchematicEntryProxy(Cache<String, SchematicEntry> cache, String key, BatchContainer batchContainer, InvocationContextContainer icc) {
        this.key = key;
        this.cache = cache;
        this.batchContainer = batchContainer;
        this.icc = icc;
    }

    protected SchematicEntryLiteral toValue(Object object) {
        Object value = object instanceof MarshalledValue ? ((MarshalledValue)object).get() : object;
        return (SchematicEntryLiteral)value;
    }

    private void assertValid(SchematicEntryLiteral value) {
        if (this.startedReadingValue && (value == null || value.removed)) {
            throw new IllegalStateException("SchematicValue stored under key " + this.key + " has been concurrently removed!");
        }
    }

    private SchematicEntryLiteral getDeltaValueForRead() {
        SchematicEntryLiteral value = this.toValue(this.cache.get((Object)this.key));
        if (value != null && !this.startedReadingValue) {
            this.startedReadingValue = true;
        }
        this.assertValid(value);
        return value;
    }

    private SchematicEntryLiteral getDeltaValueForWrite(InvocationContext ctx) {
        SchematicEntryLiteral value;
        boolean lockedAndCopied;
        CacheEntry lookedUpEntry = ctx.lookupEntry((Object)this.key);
        boolean bl = lockedAndCopied = lookedUpEntry != null && lookedUpEntry.isChanged() && this.toValue((Object)lookedUpEntry.getValue()).copied;
        if (lockedAndCopied) {
            return this.getDeltaValueForRead();
        }
        boolean suppressLocks = ctx.hasFlag(Flag.SKIP_LOCKING);
        if (!suppressLocks) {
            ctx.setFlags(new Flag[]{Flag.FORCE_WRITE_LOCK});
        }
        if (trace) {
            if (suppressLocks) {
                log.trace((Object)"Skip locking flag used.  Skipping locking.");
            } else {
                log.trace((Object)"Forcing write lock even for reads");
            }
        }
        SchematicEntryLiteral copy = (value = this.getDeltaValueForRead()) == null ? new SchematicEntryLiteral(this.key, true) : value.copyForWrite();
        copy.initForWriting();
        if (suppressLocks) {
            ctx.setFlags(new Flag[]{Flag.SKIP_LOCKING});
        }
        this.cache.put((Object)this.key, (Object)copy);
        return copy;
    }

    @Override
    public Document getMetadata() {
        SchematicEntryLiteral value = this.getDeltaValueForRead();
        return value.getMetadata();
    }

    @Override
    public String getContentType() {
        SchematicEntryLiteral value = this.getDeltaValueForRead();
        return value.getContentType();
    }

    @Override
    public Object getContent() {
        SchematicEntryLiteral value = this.getDeltaValueForRead();
        return value.getContent();
    }

    @Override
    public Document getContentAsDocument() {
        SchematicEntryLiteral value = this.getDeltaValueForRead();
        return value.getContentAsDocument();
    }

    @Override
    public Binary getContentAsBinary() {
        SchematicEntryLiteral value = this.getDeltaValueForRead();
        return value.getContentAsBinary();
    }

    @Override
    public boolean hasDocumentContent() {
        SchematicEntryLiteral value = this.getDeltaValueForRead();
        return value.hasDocumentContent();
    }

    @Override
    public boolean hasBinaryContent() {
        SchematicEntryLiteral value = this.getDeltaValueForRead();
        return value.hasBinaryContent();
    }

    public String toString() {
        return "SchematicValueProxy{key=" + this.key + '}';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setContent(Binary content, Document metadata, String defaultContentType) {
        try {
            this.startAtomic();
            InvocationContext ic = this.icc.createInvocationContext(true);
            this.getDeltaValueForWrite(ic).setContent(content, metadata, defaultContentType);
        }
        finally {
            this.endAtomic();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setContent(Document content, Document metadata, String defaultContentType) {
        try {
            this.startAtomic();
            InvocationContext ic = this.icc.createInvocationContext(true);
            this.getDeltaValueForWrite(ic).setContent(content, metadata, defaultContentType);
        }
        finally {
            this.endAtomic();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EditableDocument editDocumentContent() {
        try {
            this.startAtomic();
            InvocationContext ic = this.icc.createInvocationContext(true);
            EditableDocument editableDocument = this.getDeltaValueForWrite(ic).editDocumentContent();
            return editableDocument;
        }
        finally {
            this.endAtomic();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EditableDocument editMetadata() {
        try {
            this.startAtomic();
            InvocationContext ic = this.icc.createInvocationContext(true);
            EditableDocument editableDocument = this.getDeltaValueForWrite(ic).editMetadata();
            return editableDocument;
        }
        finally {
            this.endAtomic();
        }
    }
}

