/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.schematic.internal.document;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Set;
import org.infinispan.marshall.AbstractExternalizer;
import org.infinispan.schematic.document.Bson;
import org.infinispan.schematic.document.Document;
import org.infinispan.schematic.document.Json;
import org.infinispan.schematic.internal.document.BasicArray;
import org.infinispan.schematic.internal.document.BasicDocument;
import org.infinispan.util.Util;

public class DocumentExternalizer
extends AbstractExternalizer<Document> {
    private static final long serialVersionUID = 1L;

    public void writeObject(ObjectOutput output, Document doc) throws IOException {
        output.writeByte(1);
        byte[] bytes = Bson.write(doc);
        output.writeInt(bytes.length);
        output.write(bytes);
        try {
            Bson.read(new ByteArrayInputStream(bytes));
        }
        catch (RuntimeException e) {
            System.err.println("Failed to write and read BSON document: ");
            System.err.println(Json.write(doc));
        }
    }

    public Document readObject(ObjectInput input) throws IOException {
        if (input.available() < 5) {
            return null;
        }
        byte type = input.readByte();
        assert (type == 1);
        int length = input.readInt();
        if (length == 0) {
            return new BasicDocument();
        }
        byte[] bytes = new byte[length];
        input.readFully(bytes);
        return Bson.read(new ByteArrayInputStream(bytes));
    }

    public Integer getId() {
        return 1614;
    }

    public Set<Class<? extends Document>> getTypeClasses() {
        return Util.asSet((Object[])new Class[]{BasicDocument.class, BasicArray.class});
    }
}

