/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.schematic.internal.document;

import org.infinispan.schematic.document.EditableArray;
import org.infinispan.schematic.document.EditableDocument;
import org.infinispan.schematic.document.Path;
import org.infinispan.schematic.internal.delta.DocumentObserver;
import org.infinispan.schematic.internal.delta.PutOperation;
import org.infinispan.schematic.internal.delta.RemoveOperation;
import org.infinispan.schematic.internal.document.BasicDocument;
import org.infinispan.schematic.internal.document.DocumentEditor;
import org.infinispan.schematic.internal.document.DocumentValueFactory;
import org.infinispan.schematic.internal.document.MutableArray;
import org.infinispan.schematic.internal.document.MutableDocument;
import org.infinispan.schematic.internal.document.ObservableArrayEditor;

public class ObservableDocumentEditor
extends DocumentEditor {
    private static final long serialVersionUID = 1L;
    private final Path path;
    private final DocumentObserver observer;

    public ObservableDocumentEditor(MutableDocument document, Path path, DocumentObserver delta, DocumentValueFactory factory) {
        super(document, factory);
        this.path = path;
        this.observer = delta;
    }

    @Override
    protected Object doSetValue(String name, Object newValue) {
        Object oldValue = super.doSetValue(name, newValue);
        this.observer.addOperation(new PutOperation(this.path, name, this.copy(oldValue), this.copy(newValue)));
        return oldValue;
    }

    @Override
    public Object remove(String name) {
        Object oldValue = super.remove(name);
        this.observer.addOperation(new RemoveOperation(this.path, name, this.copy(oldValue)));
        return oldValue;
    }

    protected Object copy(Object value) {
        if (value instanceof MutableArray) {
            return ((MutableArray)value).clone();
        }
        if (value instanceof MutableDocument) {
            return ((MutableDocument)value).clone();
        }
        return value;
    }

    @Override
    public void removeAll() {
        super.removeAll();
        this.observer.addOperation(new PutOperation(this.path.parent(), this.path.getLast(), this.copy(this.unwrap()), new BasicDocument()));
    }

    @Override
    protected EditableDocument createEditableDocument(MutableDocument document, String fieldName, DocumentValueFactory factory) {
        return new ObservableDocumentEditor(document, this.path.with(fieldName), this.observer, factory);
    }

    @Override
    protected EditableArray createEditableArray(MutableArray array, String fieldName, DocumentValueFactory factory) {
        return new ObservableArrayEditor(array, this.path.with(fieldName), this.observer, factory);
    }
}

