/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.schematic.internal.document;

import de.undercouch.bson4jackson.types.JavaScript;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.bson.BSONCallback;
import org.bson.BSONObject;
import org.bson.BasicBSONCallback;
import org.bson.BasicBSONDecoder;
import org.bson.BasicBSONEncoder;
import org.bson.BasicBSONObject;
import org.bson.types.BSONTimestamp;
import org.bson.types.BasicBSONList;
import org.bson.types.Binary;
import org.bson.types.Code;
import org.bson.types.CodeWScope;
import org.bson.types.ObjectId;
import org.bson.types.Symbol;
import org.codehaus.jackson.JsonToken;
import org.infinispan.schematic.TestUtil;
import org.infinispan.schematic.document.CodeWithScope;
import org.infinispan.schematic.document.Document;
import org.infinispan.schematic.document.Json;
import org.infinispan.schematic.document.MaxKey;
import org.infinispan.schematic.document.MinKey;
import org.infinispan.schematic.document.Timestamp;
import org.infinispan.schematic.internal.document.BasicArray;
import org.infinispan.schematic.internal.document.BasicDocument;
import org.infinispan.schematic.internal.document.BsonReader;
import org.infinispan.schematic.internal.document.BsonWriter;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class BsonReadingAndWritingTest {
    protected BsonReader reader;
    protected BsonWriter writer;
    protected Document input;
    protected Document output;
    protected boolean print;

    @Before
    public void beforeTest() {
        this.reader = new BsonReader();
        this.writer = new BsonWriter();
        this.print = false;
    }

    @After
    public void afterTest() {
        this.reader = null;
        this.writer = null;
    }

    @Test
    public void shouldReadExampleBsonStream() throws IOException {
        byte[] bytes = new byte[]{22, 0, 0, 0, 2, 104, 101, 108, 108, 111, 0, 6, 0, 0, 0, 119, 111, 114, 108, 100, 0, 0};
        this.output = this.reader.read((InputStream)new ByteArrayInputStream(bytes));
        String json = Json.write((Document)this.output);
        String expected = "{ \"hello\" : \"world\" }";
        if (this.print) {
            System.out.println(json);
            System.out.flush();
        }
        assert (expected.equals(json));
    }

    @Test
    public void shouldRoundTripSimpleBsonObjectWithStringValue() {
        this.input = new BasicDocument("name", (Object)"Joe");
        this.assertRoundtrip(this.input);
    }

    @Test
    public void shouldRoundTripSimpleBsonObjectWithBooleanValue() {
        this.input = new BasicDocument("foo", (Object)3L);
        this.assertRoundtrip(this.input);
    }

    @Test
    public void shouldRoundTripSimpleBsonObjectWithIntValue() {
        this.input = new BasicDocument("foo", (Object)3);
        this.assertRoundtrip(this.input);
    }

    @Test
    public void shouldRoundTripSimpleBsonObjectWithLongValue() {
        this.input = new BasicDocument("foo", (Object)3L);
        this.assertRoundtrip(this.input);
    }

    @Test
    public void shouldRoundTripSimpleBsonObjectWithFloatValue() {
        this.input = new BasicDocument("foo", (Object)Float.valueOf(3.0f));
        this.assertRoundtrip(this.input);
    }

    @Test
    public void shouldRoundTripSimpleBsonObjectWithDoubleValue() {
        this.input = new BasicDocument("foo", (Object)3.0);
        this.assertRoundtrip(this.input);
    }

    @Test
    public void shouldRoundTripSimpleBsonObjectWithDateValue() {
        this.input = new BasicDocument("foo", (Object)new Date(this.now()));
        this.assertRoundtrip(this.input);
    }

    @Test
    public void shouldRoundTripSimpleBsonObjectWithTimestampValue() {
        this.input = new BasicDocument("foo", (Object)new Timestamp(new Date(this.now())));
        this.assertRoundtrip(this.input);
    }

    @Test
    public void shouldRoundTripSimpleBsonObjectWithObjectId() {
        int time = (int)(this.now() / 1000L);
        if (this.print) {
            System.out.println("time value: " + time);
        }
        this.input = new BasicDocument("foo", (Object)new org.infinispan.schematic.document.ObjectId(time, 1, 2, 3));
        this.assertRoundtrip(this.input);
    }

    @Test
    public void shouldRoundTripSimpleBsonObjectWithCode() {
        this.input = new BasicDocument("foo", (Object)new org.infinispan.schematic.document.Code("bar"));
        this.assertRoundtrip(this.input);
    }

    @Test
    public void shouldRoundTripSimpleBsonObjectWithCodeWithScope() {
        BasicDocument scope = new BasicDocument("baz", (Object)"bam", "bak", (Object)"bat");
        this.input = new BasicDocument("foo", (Object)new CodeWithScope("bar", (Document)scope));
        this.assertRoundtrip(this.input);
    }

    @Test
    public void shouldRoundTripSimpleBsonObjectWithMaxKey() {
        this.input = new BasicDocument("foo", (Object)MaxKey.getInstance());
        this.assertRoundtrip(this.input, false);
    }

    @Test
    public void shouldRoundTripSimpleBsonObjectWithMinKey() {
        this.input = new BasicDocument("foo", (Object)MinKey.getInstance());
        this.assertRoundtrip(this.input, false);
    }

    @Test
    public void shouldRoundTripSimpleBsonObjectWithSymbol() {
        this.input = new BasicDocument("foo", (Object)new org.infinispan.schematic.document.Symbol("bar"));
        this.assertRoundtrip(this.input);
    }

    @Test
    public void shouldRoundTripSimpleBsonObjectWithNull() {
        this.input = new BasicDocument("foo", null);
        this.assertRoundtrip(this.input);
    }

    @Test
    public void shouldRoundTripSimpleBsonObjectWithBinary() {
        byte[] data = new byte[]{22, 0, 0, 0, 2, 104, 101, 108};
        this.input = new BasicDocument("foo", (Object)new org.infinispan.schematic.document.Binary(data));
        this.assertRoundtrip(this.input);
    }

    @Test
    public void shouldRoundTripSimpleBsonObjectWithUuid() {
        this.input = new BasicDocument("foo", (Object)UUID.randomUUID());
        this.assertRoundtrip(this.input);
    }

    @Test
    public void shouldRoundTripSimpleBsonObjectWithPattern() {
        this.input = new BasicDocument("foo", (Object)Pattern.compile("[CH]at\\s+"));
        this.assertRoundtrip(this.input);
    }

    @Test
    public void shouldRoundTripSimpleBsonObjectWithPatternAndFlags() {
        this.input = new BasicDocument("foo", (Object)Pattern.compile("[CH]at\\s+", 10));
        this.assertRoundtrip(this.input);
    }

    @Test
    public void shouldRoundTripSimpleBsonObjectWithArray() {
        BasicArray array = new BasicArray();
        array.addValue((Object)"value1");
        array.addValue((Object)new org.infinispan.schematic.document.Symbol("value2"));
        array.addValue((Object)30);
        array.addValue((Object)40L);
        array.addValue((Object)4.33);
        array.addValue((Object)false);
        array.addValue(null);
        array.addValue((Object)"value2");
        this.input = new BasicDocument("foo", (Object)array);
        this.assertRoundtrip(this.input);
    }

    @Test
    public void shouldRoundTripBsonObjectWithTwoFields() {
        this.input = new BasicDocument("name", (Object)"Joe", "age", (Object)35);
        this.assertRoundtrip(this.input);
    }

    @Test
    public void shouldRoundTripBsonObjectWithThreeFields() {
        this.input = new BasicDocument("name", (Object)"Joe", "age", (Object)35, "nick", (Object)"joey");
        this.assertRoundtrip(this.input);
    }

    @Test
    public void shouldRoundTripBsonObjectWithNestedDocument() {
        BasicDocument address = new BasicDocument("street", (Object)"100 Main", "city", (Object)"Springfield", "zip", (Object)12345);
        this.input = new BasicDocument("name", (Object)"Joe", "age", (Object)35, "address", (Object)address, "nick", (Object)"joey");
        this.assertRoundtrip(this.input);
    }

    @Test
    public void shouldRoundTripLargeModeShapeDocument() throws Exception {
        Document doc = Json.read((InputStream)TestUtil.resource("json/sample-large-modeshape-doc.json"));
        this.assertRoundtrip(doc);
    }

    protected void assertRoundtrip(Document input) {
        this.assertRoundtrip(input, true);
    }

    protected void assertRoundtrip(Document input, boolean compareToOtherImpls) {
        assert (input != null);
        Document output = this.writeThenRead(input, compareToOtherImpls);
        if (this.print) {
            System.out.println("********************************************************************************");
            System.out.println("INPUT :  " + input);
            System.out.println();
            System.out.println("OUTPUT:  " + output);
            System.out.println("********************************************************************************");
            System.out.flush();
        }
        assert (input.equals(output));
    }

    protected long now() {
        return System.currentTimeMillis();
    }

    protected Document writeThenRead(Document object, boolean compareToOtherImpls) {
        try {
            long start = System.nanoTime();
            byte[] bytes = this.writer.write((Object)object);
            long writeTime = System.nanoTime() - start;
            start = System.nanoTime();
            Document result = this.reader.read((InputStream)new ByteArrayInputStream(bytes));
            long readTime = System.nanoTime() - start;
            if (compareToOtherImpls) {
                BSONObject mongoData = this.createMongoData(object);
                start = System.nanoTime();
                byte[] mongoBytes = new BasicBSONEncoder().encode(mongoData);
                long mongoWriteTime = System.nanoTime() - start;
                this.assertSame(bytes, mongoBytes, "BSON   ", "Mongo  ");
                start = System.nanoTime();
                new BasicBSONDecoder().decode(bytes, (BSONCallback)new BasicBSONCallback());
                long mongoReadTime = System.nanoTime() - start;
                Document fromMongo = this.reader.read((InputStream)new ByteArrayInputStream(mongoBytes));
                if (!fromMongo.equals(result)) {
                    System.out.println("from Schematic: " + result);
                    System.out.println("from Mongo:     " + fromMongo);
                    assert (false) : "Document read from bytes written by Mongo did not match expected document: " + result;
                }
                if (this.print) {
                    System.out.println("Reading with Schematic:  " + this.percent(readTime, mongoReadTime) + " than Mongo");
                    System.out.println("Writing with Schematic:  " + this.percent(writeTime, mongoWriteTime) + " than Mongo");
                }
            }
            return result;
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    protected String time(long nanos) {
        return "" + TimeUnit.NANOSECONDS.convert(nanos, TimeUnit.NANOSECONDS) + "ns";
    }

    protected String percent(long nanos1, long nanos2) {
        float percent = 100.0f * (float)(((double)nanos2 - (double)nanos1) / (double)nanos1);
        if ((double)percent < 0.0) {
            return "" + -percent + "% slower";
        }
        return "" + percent + "% faster";
    }

    protected BSONObject createMongoData(Document document) {
        BasicBSONObject obj = new BasicBSONObject();
        for (Document.Field field : document.fields()) {
            Object value = field.getValue();
            obj.put(field.getName(), this.createMongoData(value));
        }
        return obj;
    }

    protected Object createMongoData(Object value) {
        if (value instanceof MinKey) {
            value = "MinKey";
        } else if (value instanceof MaxKey) {
            value = "MaxKey";
        } else if (value instanceof org.infinispan.schematic.document.Symbol) {
            org.infinispan.schematic.document.Symbol symbol = (org.infinispan.schematic.document.Symbol)value;
            value = new Symbol(symbol.getSymbol());
        } else if (value instanceof org.infinispan.schematic.document.ObjectId) {
            org.infinispan.schematic.document.ObjectId id = (org.infinispan.schematic.document.ObjectId)value;
            value = new ObjectId(id.getBytes());
        } else if (value instanceof Timestamp) {
            Timestamp ts = (Timestamp)value;
            value = new BSONTimestamp(ts.getTime(), ts.getInc());
        } else if (value instanceof CodeWithScope) {
            CodeWithScope code = (CodeWithScope)value;
            value = new CodeWScope(code.getCode(), this.createMongoData(code.getScope()));
        } else if (value instanceof org.infinispan.schematic.document.Code) {
            org.infinispan.schematic.document.Code code = (org.infinispan.schematic.document.Code)value;
            value = new Code(code.getCode());
        } else if (value instanceof org.infinispan.schematic.document.Binary) {
            org.infinispan.schematic.document.Binary binary = (org.infinispan.schematic.document.Binary)value;
            value = new Binary(binary.getBytes());
        } else if (value instanceof List) {
            List values = (List)value;
            BasicBSONList newValues = new BasicBSONList();
            for (Object v : values) {
                newValues.add(this.createMongoData(v));
            }
            value = newValues;
        } else if (value instanceof Document) {
            value = this.createMongoData((Document)value);
        }
        return value;
    }

    protected Map<String, Object> createJacksonData(Document document) {
        LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>();
        for (Document.Field field : document.fields()) {
            Object value = field.getValue();
            data.put(field.getName(), this.createJacksonData(value));
        }
        return data;
    }

    protected Object createJacksonData(Object value) {
        if (value instanceof MinKey) {
            value = JsonToken.VALUE_STRING;
        } else if (value instanceof MaxKey) {
            value = JsonToken.VALUE_STRING;
        } else if (value instanceof org.infinispan.schematic.document.Symbol) {
            value = new de.undercouch.bson4jackson.types.Symbol(((org.infinispan.schematic.document.Symbol)value).getSymbol());
        } else if (value instanceof org.infinispan.schematic.document.ObjectId) {
            org.infinispan.schematic.document.ObjectId id = (org.infinispan.schematic.document.ObjectId)value;
            value = new de.undercouch.bson4jackson.types.ObjectId(id.getTime(), id.getMachine(), id.getInc());
        } else if (value instanceof Timestamp) {
            Timestamp ts = (Timestamp)value;
            value = new de.undercouch.bson4jackson.types.Timestamp(ts.getTime(), ts.getInc());
        } else if (value instanceof CodeWithScope) {
            CodeWithScope code = (CodeWithScope)value;
            value = new JavaScript(code.getCode(), this.createJacksonData(code.getScope()));
        } else if (value instanceof org.infinispan.schematic.document.Code) {
            org.infinispan.schematic.document.Code code = (org.infinispan.schematic.document.Code)value;
            value = new JavaScript(code.getCode(), null);
        } else if (value instanceof List) {
            List values = (List)value;
            ArrayList<Object> newValues = new ArrayList<Object>(values.size());
            for (Object v : values) {
                newValues.add(this.createJacksonData(v));
            }
            value = newValues;
        } else if (value instanceof Document) {
            value = this.createJacksonData((Document)value);
        }
        return value;
    }

    protected void assertSame(byte[] b1, byte[] b2, String name1, String name2) {
        String sb2;
        if (b1.equals(b2)) {
            return;
        }
        int s1 = b1.length;
        int s2 = b2.length;
        String sb1 = this.toString(b1);
        if (!sb1.equals(sb2 = this.toString(b2))) {
            System.out.println(name1 + " size: " + this.padLeft(s1, 3) + " content: " + sb1);
            System.out.println(name2 + " size: " + this.padLeft(s2, 3) + " content: " + sb2);
            assert (false);
        }
    }

    protected String padLeft(Object value, int width) {
        String result;
        String string = result = value != null ? value.toString() : "null";
        while (result.length() < width) {
            result = " " + result;
        }
        return result;
    }

    protected String toString(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            sb.append(this.padLeft(b, 4)).append(' ');
        }
        return sb.toString();
    }
}

