/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.schematic.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.infinispan.Cache;
import org.infinispan.config.Configuration;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.schematic.SchemaLibrary;
import org.infinispan.schematic.SchemaValidationTest;
import org.infinispan.schematic.SchematicEntry;
import org.infinispan.schematic.document.Document;
import org.infinispan.schematic.document.Json;
import org.infinispan.schematic.internal.CacheSchematicDb;
import org.infinispan.schematic.internal.document.BasicDocument;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.lookup.DummyTransactionManagerLookup;
import org.infinispan.transaction.lookup.TransactionManagerLookup;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class CacheSchematicDbTest {
    private CacheSchematicDb db;
    private Cache<String, SchematicEntry> cache;
    private EmbeddedCacheManager cm;

    @Before
    public void beforeTest() {
        Configuration c = new Configuration();
        c = c.fluent().invocationBatching().transaction().transactionManagerLookup((TransactionManagerLookup)new DummyTransactionManagerLookup()).build();
        this.cm = TestCacheManagerFactory.createCacheManager((Configuration)c);
        this.cache = this.cm.getCache("documents");
        this.db = new CacheSchematicDb(this.cache);
    }

    @After
    public void afterTest() {
        TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{this.cm});
        this.cache = null;
        this.db = null;
    }

    protected static InputStream resource(String resourcePath) {
        InputStream result = SchemaValidationTest.class.getClassLoader().getResourceAsStream(resourcePath);
        assert (result != null) : "Could not find resource \"" + resourcePath + "\"";
        return result;
    }

    protected void loadSchemas() throws IOException {
        SchemaLibrary schemas = this.db.getSchemaLibrary();
        schemas.put("http://json-schema.org/draft-03/schema#", Json.read((InputStream)CacheSchematicDbTest.resource("json/schema/draft-03/schema.json")));
        schemas.put("json/schema/spec-example.json", Json.read((InputStream)CacheSchematicDbTest.resource("json/schema/spec-example.json")));
    }

    @Test
    public void shouldStoreDocumentWithUnusedKeyAndWithNullMetadata() {
        BasicDocument doc = new BasicDocument();
        doc.put((Object)"k1", (Object)"value1");
        doc.put((Object)"k2", (Object)2);
        String key = "can be anything";
        SchematicEntry prior = this.db.put(key, (Document)doc, null);
        assert (prior == null) : "Should not have found a prior entry";
        SchematicEntry entry = this.db.get(key);
        assert (entry != null) : "Should have found the entry";
        Document read = entry.getContentAsDocument();
        assert (read != null);
        assert ("value1".equals(read.getString("k1")));
        assert (2 == read.getInteger("k2"));
        assert (entry.getContentAsBinary() == null) : "Should not have a Binary value for the entry's content";
    }

    @Test
    public void shouldStoreDocumentAndValidateAfterRefetching() throws Exception {
        this.loadSchemas();
        Document doc = Json.read((InputStream)CacheSchematicDbTest.resource("json/spec-example-doc.json"));
        String key = "json/spec-example-doc.json";
        String schemaUri = "json/schema/spec-example.json";
        BasicDocument metadata = new BasicDocument("$schema", (Object)schemaUri);
        this.db.put(key, doc, (Document)metadata);
        SchemaLibrary.Results results = this.db.getSchemaLibrary().validate(doc, schemaUri);
        assert (!results.hasProblems()) : "There are validation problems: " + results;
        SchematicEntry actualEntry = this.db.get(key);
        Document actualMetadata = actualEntry.getMetadata();
        Document actualDocument = actualEntry.getContentAsDocument();
        assert (actualMetadata != null);
        assert (actualDocument != null);
        assert (schemaUri.equals(actualMetadata.getString("$schema"))) : "The $schema in the metadata doesn't match: " + metadata;
        assert (key.equals(actualMetadata.getString("id"))) : "The id in the metadata doesn't match: " + metadata;
        results = this.db.validate(key);
        assert (!results.hasProblems()) : "There are validation problems: " + results;
        Map resultsByKey = this.db.validate(key, new String[]{"non-existant"});
        assert (resultsByKey != null);
        assert (!resultsByKey.containsKey(key)) : "There are validation problems: " + resultsByKey.get(key);
        resultsByKey = this.db.validateAll();
        assert (resultsByKey != null);
        assert (!resultsByKey.containsKey(key)) : "There are validation problems: " + resultsByKey.get(key);
    }
}

