/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.schematic.document;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Set;
import org.infinispan.marshall.SerializeWith;
import org.infinispan.schematic.document.CodeWithScope;
import org.infinispan.schematic.document.Document;
import org.infinispan.schematic.document.Immutable;
import org.infinispan.schematic.internal.SchematicExternalizer;
import org.infinispan.util.Util;

@Immutable
@SerializeWith(value=Externalizer.class)
public class Code {
    private final String code;

    public Code(String code) {
        this.code = code;
        assert (this.code != null);
    }

    public String getCode() {
        return this.code;
    }

    public int hashCode() {
        return this.code.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Code) {
            Code that = (Code)obj;
            return this.getCode().equals(that.getCode());
        }
        return false;
    }

    public String toString() {
        return "Code (" + this.getCode() + ')';
    }

    public static class Externalizer
    extends SchematicExternalizer<Code> {
        private static final long serialVersionUID = 1L;

        public void writeObject(ObjectOutput output, Code value) throws IOException {
            if (value instanceof CodeWithScope) {
                CodeWithScope withScope = (CodeWithScope)value;
                output.write(2);
                output.writeUTF(withScope.getCode());
                output.writeObject(withScope.getScope());
            } else {
                output.write(1);
                output.writeUTF(value.getCode());
            }
        }

        public Code readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            int type = input.read();
            switch (type) {
                case 1: {
                    String code = input.readUTF();
                    return new Code(code);
                }
                case 2: {
                    String code = input.readUTF();
                    Document scope = (Document)input.readObject();
                    return new CodeWithScope(code, scope);
                }
            }
            throw new UnsupportedOperationException("Unknown Code type: " + type);
        }

        @Override
        public Integer getId() {
            return 1620;
        }

        @Override
        public Set<Class<? extends Code>> getTypeClasses() {
            return Util.asSet((Object[])new Class[]{Code.class, CodeWithScope.class});
        }
    }
}

