/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.schematic.internal.document;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Pattern;
import org.infinispan.schematic.document.Binary;
import org.infinispan.schematic.document.Bson;
import org.infinispan.schematic.document.Code;
import org.infinispan.schematic.document.CodeWithScope;
import org.infinispan.schematic.document.Document;
import org.infinispan.schematic.document.MaxKey;
import org.infinispan.schematic.document.MinKey;
import org.infinispan.schematic.document.ObjectId;
import org.infinispan.schematic.document.Symbol;
import org.infinispan.schematic.document.Timestamp;
import org.infinispan.schematic.internal.document.ArrayEditor;
import org.infinispan.schematic.internal.document.BasicDocument;
import org.infinispan.schematic.internal.document.BsonUtils;
import org.infinispan.schematic.internal.document.DocumentEditor;
import org.infinispan.schematic.internal.document.JsonWriter;

public class CompactJsonWriter
implements JsonWriter {
    @Override
    public void write(Object object, OutputStream stream) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(stream);
        this.write(object, (Writer)writer);
        ((Writer)writer).flush();
    }

    @Override
    public void write(Object object, Writer writer) throws IOException {
        if (object == null) {
            this.writeNull(writer);
        } else if (object instanceof String) {
            this.write((String)object, writer);
        } else if (object instanceof Boolean) {
            this.write((Boolean)object, writer);
        } else if (object instanceof Integer) {
            this.write((Integer)object, writer);
        } else if (object instanceof Long) {
            this.write((Long)object, writer);
        } else if (object instanceof Float) {
            this.write(((Float)object).floatValue(), writer);
        } else if (object instanceof Double) {
            this.write((Double)object, writer);
        } else if (object.getClass().isArray()) {
            this.writeArray(object, writer);
        } else if (object instanceof ArrayEditor) {
            this.write(((ArrayEditor)object).unwrap(), writer);
        } else if (object instanceof DocumentEditor) {
            this.write(((DocumentEditor)object).unwrap(), writer);
        } else if (object instanceof Iterable) {
            this.write((Iterable)object, writer);
        } else if (object instanceof Map) {
            this.write((Document)object, writer);
        } else if (object instanceof Binary) {
            this.write((Binary)object, writer);
        } else if (object instanceof Symbol) {
            this.write((Symbol)object, writer);
        } else if (object instanceof Pattern) {
            this.write((Pattern)object, writer);
        } else if (object instanceof Date) {
            this.write((Date)object, writer);
        } else if (object instanceof UUID) {
            this.write((UUID)object, writer);
        } else if (object instanceof CodeWithScope) {
            this.write((CodeWithScope)object, writer);
        } else if (object instanceof Code) {
            this.write((Code)object, writer);
        } else if (object instanceof Timestamp) {
            this.write((Timestamp)object, writer);
        } else if (object instanceof Document.Field) {
            this.write((Document.Field)object, writer);
        } else if (object instanceof ObjectId) {
            this.write((ObjectId)object, writer);
        } else if (object instanceof MaxKey) {
            this.write((MaxKey)object, writer);
        } else if (object instanceof MinKey) {
            this.write((MinKey)object, writer);
        }
    }

    @Override
    public void write(Object object, StringBuilder writer) {
        try {
            this.write(object, (Writer)new StringBuilderWriter(writer));
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public String write(Object object) {
        StringBuilder sb = new StringBuilder();
        this.write(object, sb);
        return sb.toString();
    }

    protected void write(boolean value, Writer writer) throws IOException {
        writer.append(Boolean.toString(value));
    }

    protected void write(int value, Writer writer) throws IOException {
        writer.append(Integer.toString(value));
    }

    protected void write(long value, Writer writer) throws IOException {
        writer.append(Long.toString(value));
    }

    protected void write(float value, Writer writer) throws IOException {
        writer.append(Float.toString(value));
    }

    protected void write(double value, Writer writer) throws IOException {
        writer.append(Double.toString(value));
    }

    protected void writeNull(Writer writer) throws IOException {
        writer.append("null");
    }

    protected void write(String value, Writer writer) throws IOException {
        writer.append('\"').append(value).append('\"');
    }

    protected void write(Symbol value, Writer writer) throws IOException {
        writer.append('\"').append(value.getSymbol()).append('\"');
    }

    protected void write(ObjectId value, Writer writer) throws IOException {
        this.write(new BasicDocument("$oid", value.getBytesInBase16()), writer);
    }

    protected void write(Date value, Writer writer) throws IOException {
        String isoDate = Bson.getDateFormatter().format(value);
        this.write(new BasicDocument("$date", isoDate), writer);
    }

    protected void write(Timestamp value, Writer writer) throws IOException {
        this.write(new BasicDocument("$ts", value.getTime(), "$inc", value.getInc()), writer);
    }

    protected void write(MinKey value, Writer writer) throws IOException {
        this.write("MinKey", writer);
    }

    protected void write(MaxKey value, Writer writer) throws IOException {
        this.write("MaxKey", writer);
    }

    protected void write(Pattern value, Writer writer) throws IOException {
        BasicDocument obj = new BasicDocument("$regex", value.pattern());
        String options = BsonUtils.regexFlagsFor(value);
        if (options.length() != 0) {
            obj.put("$options", options);
        }
        this.write(obj, writer);
    }

    protected void write(Binary value, Writer writer) throws IOException {
        int type = value.getType() - 0;
        String base64 = value.getBytesInBase64();
        this.write(new BasicDocument("$type", type, "$base64", base64), writer);
    }

    protected void write(UUID value, Writer writer) throws IOException {
        this.write(new BasicDocument("$uuid", value.toString()), writer);
    }

    protected void write(Code value, Writer writer) throws IOException {
        this.write(new BasicDocument("$code", value.getCode()), writer);
    }

    protected void write(CodeWithScope value, Writer writer) throws IOException {
        this.write(new BasicDocument("$code", value.getCode(), "$scope", value.getScope()), writer);
    }

    protected void write(Document.Field field, Writer writer) throws IOException {
        writer.append('\"').append(field.getName()).append('\"').append(' ').append(':').append(' ');
        this.write(field.getValue(), writer);
    }

    protected void write(Document bson, Writer writer) throws IOException {
        writer.append('{').append(' ');
        Iterator<Document.Field> iter = bson.fields().iterator();
        if (iter.hasNext()) {
            this.write(iter.next(), writer);
            writer.append(' ');
            while (iter.hasNext()) {
                writer.append(',').append(' ');
                this.write(iter.next(), writer);
                writer.append(' ');
            }
        }
        writer.append('}');
    }

    protected void write(Iterable<?> arrayValue, Writer writer) throws IOException {
        writer.append('[');
        Iterator<?> iter = arrayValue.iterator();
        if (iter.hasNext()) {
            writer.append(' ');
            this.write(iter.next(), writer);
            while (iter.hasNext()) {
                writer.append(' ').append(',').append(' ');
                this.write(iter.next(), writer);
            }
        }
        writer.append(' ').append(']');
    }

    protected void writeArray(Object array, Writer writer) throws IOException {
        writer.append('[');
        int len = Array.getLength(array);
        for (int i = 0; i < len; ++i) {
            if (i > 0) {
                writer.append(' ').append(',').append(' ');
            }
            this.write(Array.get(array, i), writer);
        }
        writer.append(' ').append(']');
    }

    protected static final class StringBuilderWriter
    extends Writer {
        private final StringBuilder builder;

        public StringBuilderWriter(StringBuilder builder) {
            this.builder = builder;
        }

        @Override
        public void write(char[] cbuf, int off, int len) {
            this.builder.append(cbuf, off, len);
        }

        @Override
        public Writer append(char c) {
            this.builder.append(c);
            return this;
        }

        @Override
        public Writer append(CharSequence csq) {
            this.builder.append(csq);
            return this;
        }

        @Override
        public Writer append(CharSequence csq, int start, int end) {
            this.builder.append(csq, start, end);
            return this;
        }

        @Override
        public void write(int c) {
            this.builder.append(c);
        }

        @Override
        public void write(char[] cbuf) {
            this.builder.append(cbuf);
        }

        @Override
        public void write(String str) {
            this.builder.append(str);
        }

        @Override
        public void write(String str, int off, int len) {
            this.builder.append(str, off, len);
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() {
        }
    }
}

