/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.schematic.internal.document;

import java.io.InputStream;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.infinispan.schematic.document.Document;
import org.infinispan.schematic.document.Json;
import org.infinispan.schematic.internal.document.AbstractExternalizerTest;
import org.junit.Assert;
import org.junit.Test;

public class DocumentExternalizerTest
extends AbstractExternalizerTest {
    @Test
    public void shouldRoundTripSampleRepositoryConfiguration() throws Exception {
        this.assertRoundTripJsonDocument("json/sample-repo-config.json");
    }

    @Test
    public void shouldRoundTripSimpleDocument() throws Exception {
        this.assertRoundTripJsonDocument("json/spec-example-doc.json");
    }

    @Test
    public void shouldRoundTripEmptyDocument() throws Exception {
        this.assertRoundTripJsonDocument("json/empty.json");
    }

    protected void assertRoundTripJsonDocument(String resourcePath) throws Exception {
        InputStream stream = this.getClass().getClassLoader().getResourceAsStream(resourcePath);
        Assert.assertThat((Object)stream, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Document doc = Json.read((InputStream)stream);
        byte[] bytes = this.marshall(doc);
        Document newDoc = (Document)this.unmarshall(bytes);
        Assert.assertThat((Object)newDoc, (Matcher)Is.is((Object)doc));
    }
}

