/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.entries;

import java.util.LinkedList;
import java.util.List;
import org.infinispan.atomic.AtomicHashMap;
import org.infinispan.atomic.Delta;
import org.infinispan.atomic.DeltaAware;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.StateChangingEntry;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.util.Util;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class DeltaAwareCacheEntry
implements CacheEntry,
StateChangingEntry {
    private static final Log log = LogFactory.getLog(DeltaAwareCacheEntry.class);
    private static final boolean trace = log.isTraceEnabled();
    protected Object key;
    protected CacheEntry wrappedEntry;
    protected DeltaAware value;
    protected DeltaAware oldValue;
    protected final List<Delta> deltas;
    protected byte flags = 0;
    protected AtomicHashMap<?, ?> uncommittedChanges;

    public DeltaAwareCacheEntry(Object key, DeltaAware value, CacheEntry wrappedEntry) {
        this.setValid(true);
        this.key = key;
        this.value = value;
        this.wrappedEntry = wrappedEntry;
        if (value instanceof AtomicHashMap) {
            this.uncommittedChanges = ((AtomicHashMap)value).copy();
        }
        this.deltas = new LinkedList<Delta>();
    }

    @Override
    public byte getStateFlags() {
        if (this.wrappedEntry instanceof StateChangingEntry) {
            return ((StateChangingEntry)((Object)this.wrappedEntry)).getStateFlags();
        }
        return this.flags;
    }

    @Override
    public void copyStateFlagsFrom(StateChangingEntry other) {
        this.flags = other.getStateFlags();
    }

    public void appendDelta(Delta d) {
        this.deltas.add(d);
        d.merge(this.uncommittedChanges);
        this.setChanged(true);
    }

    public AtomicHashMap<?, ?> getUncommittedChages() {
        return this.uncommittedChanges;
    }

    protected final boolean isFlagSet(Flags flag) {
        return (this.flags & flag.mask) != 0;
    }

    protected final void setFlag(Flags flag) {
        this.flags = (byte)(this.flags | flag.mask);
    }

    protected final void unsetFlag(Flags flag) {
        this.flags = (byte)(this.flags & ~flag.mask);
    }

    @Override
    public final long getLifespan() {
        return 0L;
    }

    @Override
    public final long getMaxIdle() {
        return 0L;
    }

    @Override
    public final void setMaxIdle(long maxIdle) {
    }

    @Override
    public final void setLifespan(long lifespan) {
    }

    @Override
    public final Object getKey() {
        return this.key;
    }

    @Override
    public final Object getValue() {
        return this.value;
    }

    @Override
    public final Object setValue(Object value) {
        DeltaAware oldValue = this.value;
        this.value = (DeltaAware)value;
        return oldValue;
    }

    @Override
    public boolean isNull() {
        return false;
    }

    @Override
    public final void commit(DataContainer container, EntryVersion version) {
        if (this.wrappedEntry != null) {
            this.wrappedEntry.commit(container, version);
        }
        if (this.value != null && !this.deltas.isEmpty()) {
            for (Delta delta : this.deltas) {
                delta.merge(this.value);
            }
            this.value.commit();
        }
        this.reset();
    }

    private void reset() {
        this.oldValue = null;
        this.deltas.clear();
        this.flags = 0;
        if (this.uncommittedChanges != null) {
            this.uncommittedChanges.clear();
        }
        this.setValid(true);
    }

    @Override
    public final void rollback() {
        if (this.isChanged()) {
            this.value = this.oldValue;
            this.reset();
        }
    }

    @Override
    public final boolean isChanged() {
        return this.isFlagSet(Flags.CHANGED);
    }

    @Override
    public final void setChanged(boolean changed) {
        this.setFlag(changed, Flags.CHANGED);
    }

    @Override
    public boolean isValid() {
        if (this.wrappedEntry != null) {
            return this.wrappedEntry.isValid();
        }
        return this.isFlagSet(Flags.VALID);
    }

    @Override
    public final void setValid(boolean valid) {
        this.setFlag(valid, Flags.VALID);
    }

    @Override
    public boolean isLockPlaceholder() {
        if (this.wrappedEntry != null) {
            return this.wrappedEntry.isLockPlaceholder();
        }
        return this.isFlagSet(Flags.LOCK_PLACEHOLDER);
    }

    @Override
    public final boolean isCreated() {
        if (this.wrappedEntry != null) {
            return this.wrappedEntry.isCreated();
        }
        return this.isFlagSet(Flags.CREATED);
    }

    @Override
    public final void setCreated(boolean created) {
        this.setFlag(created, Flags.CREATED);
    }

    @Override
    public boolean isRemoved() {
        if (this.wrappedEntry != null) {
            return this.wrappedEntry.isRemoved();
        }
        return this.isFlagSet(Flags.REMOVED);
    }

    @Override
    public boolean isEvicted() {
        if (this.wrappedEntry != null) {
            return this.wrappedEntry.isEvicted();
        }
        return this.isFlagSet(Flags.EVICTED);
    }

    @Override
    public final void setRemoved(boolean removed) {
        this.setFlag(removed, Flags.REMOVED);
    }

    @Override
    public void setEvicted(boolean evicted) {
        this.setFlag(evicted, Flags.EVICTED);
    }

    @Override
    public boolean isLoaded() {
        return this.isFlagSet(Flags.LOADED);
    }

    @Override
    public void setLoaded(boolean loaded) {
        this.setFlag(loaded, Flags.LOADED);
    }

    private void setFlag(boolean enable, Flags flag) {
        if (enable) {
            this.setFlag(flag);
        } else {
            this.unsetFlag(flag);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + Util.hexIdHashCode(this) + "){" + "key=" + this.key + ", value=" + this.value + ", oldValue=" + this.uncommittedChanges + ", isCreated=" + this.isCreated() + ", isChanged=" + this.isChanged() + ", isRemoved=" + this.isRemoved() + ", isValid=" + this.isValid() + '}';
    }

    @Override
    public boolean undelete(boolean doUndelete) {
        if (this.isRemoved() && doUndelete) {
            if (trace) {
                log.trace("Entry is deleted in current scope.  Un-deleting.");
            }
            this.setRemoved(false);
            this.setValid(true);
            return true;
        }
        return false;
    }

    @Override
    public EntryVersion getVersion() {
        return null;
    }

    @Override
    public void setVersion(EntryVersion version) {
    }

    protected static enum Flags {
        CHANGED(1),
        CREATED(2),
        REMOVED(4),
        VALID(8),
        LOCK_PLACEHOLDER(16),
        EVICTED(32),
        LOADED(64);

        final byte mask;

        private Flags(int mask) {
            this.mask = (byte)mask;
        }
    }
}

