/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.schematic.internal.document;

import org.infinispan.schematic.document.Array;
import org.infinispan.schematic.document.Document;
import org.infinispan.schematic.internal.document.BasicArray;
import org.infinispan.schematic.internal.document.BasicDocument;
import org.junit.Before;
import org.junit.Test;

public class BasicDocumentTest {
    private BasicDocument doc;

    @Before
    public void beforeTest() {
        this.doc = new BasicDocument();
        this.doc.put((Object)"foo", (Object)"value for foo");
        this.doc.put((Object)"bar", (Object)"value for bar");
        this.doc.put((Object)"baz", (Object)new BasicDocument("key1", (Object)"value1", "key2", (Object)"value2"));
        this.doc.put((Object)"bom", (Object)new BasicArray(new Object[]{"v1", "v2", "v3", new BasicDocument("v4-Key", (Object)"v4-value")}));
    }

    @Test
    public void shouldBeCloneable() {
        this.assertEquals((Document)this.doc, this.doc.clone());
    }

    protected void assertEquals(Document doc1, Document doc2) {
        assert (doc1 != doc2);
        assert (doc1.equals(doc2));
        for (Document.Field field : doc1.fields()) {
            Object value2 = doc2.get(field.getName());
            assert (value2.equals(field.getValue()));
            if (value2 instanceof Array) {
                assert (value2 != field.getValue());
                this.assertEquals((Array)field.getValue(), (Array)value2);
                continue;
            }
            if (!(value2 instanceof Document)) continue;
            assert (value2 != field.getValue());
            this.assertEquals(field.getValueAsDocument(), (Document)value2);
        }
    }

    protected void assertEquals(Array array1, Array array2) {
        assert (array1 != array2);
        assert (array1.equals(array2));
        for (int i = 0; i != array1.size(); ++i) {
            Object value1 = array1.get(i);
            Object value2 = array2.get(i);
            assert (value1.equals(value2));
            if (value2 instanceof Array) {
                assert (value1 != value2);
                this.assertEquals((Array)value1, (Array)value2);
                continue;
            }
            if (!(value2 instanceof Document)) continue;
            assert (value1 != value2);
            this.assertEquals((Document)value1, (Document)value2);
        }
    }
}

