/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.schematic.internal.document;

import java.io.InputStream;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.infinispan.schematic.document.Document;
import org.infinispan.schematic.document.DocumentSequence;
import org.infinispan.schematic.document.Null;
import org.infinispan.schematic.internal.document.JsonReader;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JsonReaderTest {
    protected JsonReader reader;
    protected boolean print;
    protected Document doc;

    @Before
    public void beforeTest() {
        this.reader = new JsonReader();
        this.print = false;
    }

    @After
    public void afterTest() {
        this.reader = null;
    }

    @Test
    public void shouldParseEmptyDocument() throws Exception {
        this.doc = this.reader.read("{ }");
    }

    @Test
    public void shouldParseEmptyDocumentWithLeadingWhitespace() throws Exception {
        this.doc = this.reader.read("  { }");
    }

    @Test
    public void shouldParseEmptyDocumentWithEmbeddedWhitespace() throws Exception {
        this.doc = this.reader.read("{ \n \t \r\n }  ");
    }

    @Test
    public void shouldParseDocumentWithSingleFieldWithStringValue() throws Exception {
        this.doc = this.reader.read("{ \"foo\" : \"bar\" }");
        this.assertField("foo", "bar");
    }

    @Test
    public void shouldParseDocumentWithSingleFieldWithBooleanFalseValue() throws Exception {
        this.doc = this.reader.read("{ \"foo\" : false }");
        this.assertField("foo", false);
    }

    @Test
    public void shouldParseDocumentWithSingleFieldWithBooleanTrueValue() throws Exception {
        this.doc = this.reader.read("{ \"foo\" : true }");
        this.assertField("foo", true);
    }

    @Test
    public void shouldParseDocumentWithSingleFieldWithIntegerValue() throws Exception {
        this.doc = this.reader.read("{ \"foo\" : 0 }");
        this.assertField("foo", 0);
    }

    @Test
    public void shouldParseDocumentWithSingleFieldWithLongValue() throws Exception {
        long val = 0x80000009L;
        this.doc = this.reader.read("{ \"foo\" : " + val + " }");
        this.assertField("foo", val);
    }

    @Test
    public void shouldParseDocumentWithSingleFieldWithDoubleValue() throws Exception {
        this.doc = this.reader.read("{ \"foo\" : 2.3543 }");
        this.assertField("foo", 2.3543);
    }

    @Test
    public void shouldParseDocumentWithMultipleFieldsAndExtraDelimiters() throws Exception {
        this.doc = this.reader.read("{ \"foo\" : 32 ,, \"nested\" : { \"bar\" : \"baz\", \"bom\" : true } ,}");
        this.assertField("foo", 32);
        this.doc = this.doc.getDocument("nested");
        this.assertField("bar", "baz");
        this.assertField("bom", true);
    }

    @Test
    public void shouldParseMultipleDocuments() throws Exception {
        Document doc;
        InputStream stream = this.getClass().getClassLoader().getResourceAsStream("json/multiple-json-files.txt");
        DocumentSequence seq = this.reader.readMultiple(stream);
        int count = 0;
        while ((doc = seq.nextDocument()) != null) {
            ++count;
        }
        Assert.assertThat((Object)count, (Matcher)Is.is((Object)265));
    }

    protected void assertField(String name, Object value) {
        Object actual = this.doc.get(name);
        if (value == null ? !$assertionsDisabled && !Null.matches((Object)actual) : !$assertionsDisabled && !value.equals(actual)) {
            throw new AssertionError();
        }
    }
}

