/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.schematic.internal;

import java.util.EnumSet;
import javax.transaction.TransactionManager;
import org.infinispan.AdvancedCache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.context.Flag;
import org.infinispan.schematic.SchematicEntry;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.TransactionTable;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

final class CacheContext {
    private static final Log LOGGER = LogFactory.getLog(CacheContext.class);
    private final AdvancedCache<String, SchematicEntry> cache;
    private final AdvancedCache<String, SchematicEntry> cacheForWriting;
    private final AdvancedCache<String, SchematicEntry> cacheForLocking;
    private final TransactionManager txnMgr;
    private final TransactionTable transactionTable;
    private final boolean explicitLockingEnabled;
    private final boolean clustered;

    CacheContext(AdvancedCache<String, SchematicEntry> cache) {
        this.cache = cache;
        Configuration config = cache.getCacheConfiguration();
        this.clustered = config.clustering().cacheMode() != CacheMode.LOCAL;
        EnumSet<Flag> flags = EnumSet.noneOf(Flag.class);
        flags.add(Flag.SKIP_REMOTE_LOOKUP);
        flags.add(Flag.DELTA_WRITE);
        LOGGER.debug((Object)("Deltas will be used to serializing changes to documents in '" + cache.getName() + "'."));
        LOGGER.debug((Object)("Passivation? " + config.loaders().passivation()));
        LOGGER.debug((Object)("Eviction? " + config.eviction().strategy()));
        LOGGER.debug((Object)("Clustering mode? " + config.clustering().cacheMode()));
        LOGGER.debug((Object)("Using cache with flags " + flags + " during SchematicEntry updates"));
        this.cacheForWriting = this.cache.withFlags(flags.toArray(new Flag[flags.size()]));
        this.txnMgr = cache.getTransactionManager();
        this.transactionTable = (TransactionTable)cache.getComponentRegistry().getComponent(TransactionTable.class);
        LockingMode lockingMode = config.transaction().lockingMode();
        boolean bl = this.explicitLockingEnabled = lockingMode == LockingMode.PESSIMISTIC;
        if (this.isExplicitLockingEnabled()) {
            this.cacheForLocking = this.cache.withFlags(new Flag[]{Flag.FAIL_SILENTLY});
            LOGGER.debug((Object)("Explicit locks will be used when modifying documents in '" + cache.getName() + "' (Infinispan's locking mode is PESSIMISTIC)."));
        } else {
            this.cacheForLocking = this.cache;
            LOGGER.debug((Object)("Explicit locks will NOT be used when modifying documents in '" + cache.getName() + "' (Infinispan's locking mode is not PESSIMISTIC)."));
        }
    }

    public AdvancedCache<String, SchematicEntry> getCache() {
        return this.cache;
    }

    public AdvancedCache<String, SchematicEntry> getCacheForWriting() {
        return this.cacheForWriting;
    }

    public AdvancedCache<String, SchematicEntry> getCacheForLocking() {
        return this.cacheForLocking;
    }

    public TransactionTable getTransactionTable() {
        return this.transactionTable;
    }

    public TransactionManager getTransactionManager() {
        return this.txnMgr;
    }

    public boolean isExplicitLockingEnabled() {
        return this.explicitLockingEnabled;
    }

    public boolean isDeltaContainingChangesEnabled() {
        return true;
    }

    public boolean isClustered() {
        return this.clustered;
    }
}

