/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.schematic.internal.document;

import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

public class IndexSequence
implements Set<String> {
    protected static final String[] EMPTY_ARRAY = new String[0];
    protected static final String[] INDEX_VALUES;
    protected static final int MAXIMUM_KEY_COUNT = 250;
    protected final int size;

    public static Iterator<String> indexesTo(int size) {
        return new IndexSequence(size).iterator();
    }

    public static Iterator<String> infiniteSequence() {
        return new IndexSequence(Integer.MAX_VALUE).iterator();
    }

    public IndexSequence(int size) {
        this.size = size;
    }

    @Override
    public boolean add(String e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends String> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(Object o) {
        int index = Integer.parseInt(String.valueOf(o));
        return index >= 0 && index < this.size;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object value : c) {
            if (this.contains(value)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public Iterator<String> iterator() {
        return new Iterator<String>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < IndexSequence.this.size;
            }

            @Override
            public String next() {
                return this.index < 250 ? INDEX_VALUES[this.index++] : String.valueOf(this.index++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Object[] toArray() {
        if (this.size == 0) {
            return EMPTY_ARRAY;
        }
        Object[] copy = new String[this.size];
        System.arraycopy(INDEX_VALUES, 0, copy, 0, this.size);
        return copy;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        throw new UnsupportedOperationException();
    }

    static {
        String[] values = new String[250];
        for (int i = 0; i != 250; ++i) {
            values[i] = Integer.toString(i);
        }
        INDEX_VALUES = values;
    }
}

