/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.schematic.document;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Date;
import java.util.Set;
import org.infinispan.marshall.SerializeWith;
import org.infinispan.schematic.document.Immutable;
import org.infinispan.schematic.internal.SchematicExternalizer;
import org.infinispan.util.Util;

@Immutable
@SerializeWith(value=Externalizer.class)
public final class Timestamp {
    private final Date time;
    private final int inc;

    public Timestamp() {
        this.time = null;
        this.inc = 0;
    }

    public Timestamp(Date date) {
        this((int)(date.getTime() / 1000L), 0);
    }

    public Timestamp(int timeInSeconds, int inc) {
        this.time = new Date((long)timeInSeconds * 1000L);
        this.inc = inc;
    }

    public int getTime() {
        return this.time == null ? 0 : (int)(this.time.getTime() / 1000L);
    }

    public int getInc() {
        return this.inc;
    }

    public Date getAsDate() {
        return new Date(this.time.getTime());
    }

    public int hashCode() {
        return this.getTime();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Timestamp) {
            Timestamp that = (Timestamp)obj;
            return this.getInc() == that.getInc() && this.getTime() == that.getTime();
        }
        return false;
    }

    public String toString() {
        return "TS(" + this.time + ':' + this.inc + ')';
    }

    public static class Externalizer
    extends SchematicExternalizer<Timestamp> {
        private static final long serialVersionUID = 1L;

        public void writeObject(ObjectOutput output, Timestamp timestamp) throws IOException {
            output.writeInt(timestamp.getInc());
            output.writeInt(timestamp.getTime());
        }

        public Timestamp readObject(ObjectInput input) throws IOException {
            int inc = input.readInt();
            int time = input.readInt();
            return new Timestamp(inc, time);
        }

        @Override
        public Integer getId() {
            return 1616;
        }

        @Override
        public Set<Class<? extends Timestamp>> getTypeClasses() {
            return Util.asSet((Object[])new Class[]{Timestamp.class});
        }
    }
}

