/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.schematic;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class TestUtil {
    public static boolean delete(File fileOrDirectory) {
        if (fileOrDirectory == null) {
            return false;
        }
        if (!fileOrDirectory.exists()) {
            return false;
        }
        if (fileOrDirectory.isDirectory()) {
            for (File childFile : fileOrDirectory.listFiles()) {
                TestUtil.delete(childFile);
            }
        }
        return fileOrDirectory.delete();
    }

    public static InputStream resource(String resourcePath) {
        InputStream stream = TestUtil.class.getClassLoader().getResourceAsStream(resourcePath);
        if (stream == null) {
            File file = new File(resourcePath);
            if (!file.exists()) {
                file = new File("src/test/resources" + resourcePath);
            }
            if (!file.exists()) {
                file = new File("src/test/resources/" + resourcePath);
            }
            if (file.exists()) {
                try {
                    stream = new FileInputStream(file);
                }
                catch (IOException e) {
                    throw new AssertionError((Object)("Failed to open stream to \"" + file.getAbsolutePath() + "\""));
                }
            }
        }
        assert (stream != null) : "Resource at \"" + resourcePath + "\" could not be found";
        return stream;
    }
}

