/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.schematic.internal.document;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.concurrent.atomic.AtomicReference;
import org.infinispan.schematic.document.Document;
import org.infinispan.schematic.internal.document.BsonReader;
import org.infinispan.schematic.internal.document.BsonWriter;
import org.infinispan.schematic.internal.document.JsonReader;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.junit.After;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
public class JsonPerformanceTest {
    protected JsonReader reader;
    protected boolean print;

    @Before
    public void beforeTest() {
        this.reader = new JsonReader();
    }

    @After
    public void afterTest() {
        this.reader = null;
        JsonPerformanceTest.gc();
    }

    @Test
    public void shouldReadLargeTestDocumentWithoutDateMatching() throws Exception {
        this.testReadingJson(JsonPerformanceTest.getLargeTestData(), 200, false, false);
    }

    @Test
    public void shouldReadLargeTestDocumentWithDateMatching() throws Exception {
        this.testReadingJson(JsonPerformanceTest.getLargeTestData(), 200, false, true);
    }

    @Test
    public void shouldReadLargeTestDocumentWithoutDataMatchingUsingJsonSimple() throws Exception {
        this.testReadingJsonWithJsonSimple(JsonPerformanceTest.getLargeTestData(), 200, false);
    }

    @Test
    public void shouldReadSmallTestDocumentWithoutDateMatching() throws Exception {
        this.testReadingJson(JsonPerformanceTest.getSmallTestData(), 200, false, false);
    }

    @Test
    public void shouldReadSmallTestDocumentWithDateMatching() throws Exception {
        this.testReadingJson(JsonPerformanceTest.getSmallTestData(), 200, false, true);
    }

    @Test
    public void shouldReadSmallTestDocumentWithoutDataMatchingUsingJsonSimple() throws Exception {
        this.testReadingJsonWithJsonSimple(JsonPerformanceTest.getSmallTestData(), 200, false);
    }

    @Test
    public void shouldReadSmallTestDocumentToAndFromBson() throws Exception {
        this.testReadingJsonThenWritingBsonThenReadingBson(JsonPerformanceTest.getSmallTestData(), 200, false, true);
    }

    public static String getLargeTestData() throws Exception {
        String result = JsonPerformanceTest.read("sample-large-performance.json");
        assert (result.length() != 0);
        return result;
    }

    public static String getSmallTestData() throws Exception {
        String result = JsonPerformanceTest.read("sample-small-performance.json");
        assert (result.length() != 0);
        return result;
    }

    private static String read(String resourcePath) throws IOException {
        return JsonPerformanceTest.read(JsonPerformanceTest.class.getClassLoader().getResourceAsStream(resourcePath));
    }

    private static String read(InputStream stream) throws IOException {
        return JsonPerformanceTest.read(new InputStreamReader(stream));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String read(Reader reader) throws IOException {
        if (reader == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        try {
            int numRead = 0;
            char[] buffer = new char[1024];
            while ((numRead = reader.read(buffer)) > -1) {
                sb.append(buffer, 0, numRead);
            }
        }
        finally {
            reader.close();
        }
        return sb.toString();
    }

    private static void gc() {
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        System.gc();
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runTest(String message, int loops, int testDataLength, boolean print, Runnable function) {
        assert (loops > 0);
        for (int i = 0; i != 3; ++i) {
            function.run();
        }
        long stop = 0L;
        long start = System.nanoTime();
        try {
            for (int i = 0; i != loops; ++i) {
                function.run();
            }
        }
        finally {
            stop = System.nanoTime();
        }
        if (print) {
            while (message.length() < 60) {
                message = message + " ";
            }
            System.out.print(message + " -- data length: " + testDataLength);
            System.out.print(" -- average time: ");
            double delta = (double)(stop - start) / ((double)loops + 0.0);
            String unit = "nanos";
            if (delta > 1000.0) {
                delta /= 1000000.0;
                unit = "millis";
            }
            System.out.println(delta + " " + unit);
        }
    }

    protected void testReadingJson(final String testData, int numberOfRuns, final boolean getValue, final boolean introspectStringValues) throws Exception {
        assert (testData != null);
        final JsonReader reader = new JsonReader();
        final AtomicReference error = new AtomicReference();
        String key = "key";
        JsonPerformanceTest.runTest("JsonReader.read(String," + introspectStringValues + ")", numberOfRuns, testData.length(), this.print, new Runnable(){

            @Override
            public void run() {
                try {
                    Document doc = reader.read(testData, introspectStringValues);
                    if (getValue) {
                        doc.get("key");
                    }
                }
                catch (Exception t) {
                    error.compareAndSet(null, t);
                }
            }
        });
        if (error.get() != null) {
            throw (Exception)error.get();
        }
    }

    protected void testReadingJsonWithJsonSimple(final String testData, int numberOfRuns, final boolean getValue) throws Exception {
        final JSONParser parser = new JSONParser();
        final AtomicReference error = new AtomicReference();
        String key = "key";
        JsonPerformanceTest.runTest("org.json.simple.parser.JSONParser().parse(Reader)", numberOfRuns, testData.length(), this.print, new Runnable(){

            @Override
            public void run() {
                try {
                    JSONObject obj = (JSONObject)parser.parse((Reader)new StringReader(testData));
                    if (getValue) {
                        obj.get((Object)"key");
                    }
                }
                catch (Exception t) {
                    error.compareAndSet(null, t);
                }
            }
        });
        if (error.get() != null) {
            throw (Exception)error.get();
        }
    }

    protected void testReadingJsonThenWritingBsonThenReadingBson(String testData, int numberOfRuns, boolean getValue, boolean introspectStringValues) throws Exception {
        assert (testData != null);
        Document doc = new JsonReader().read(testData, introspectStringValues);
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        new BsonWriter().write((Object)doc, (OutputStream)bytes);
        final byte[] bsonBytes = bytes.toByteArray();
        final BsonReader bsonReader = new BsonReader();
        final AtomicReference error = new AtomicReference();
        String key = "key";
        JsonPerformanceTest.runTest("BsonReader.read(InputStream)", numberOfRuns, testData.length(), this.print, new Runnable(){

            @Override
            public void run() {
                try {
                    ByteArrayInputStream input = new ByteArrayInputStream(bsonBytes);
                    Document doc = bsonReader.read((InputStream)input);
                    doc.get("key");
                }
                catch (Exception t) {
                    error.compareAndSet(null, t);
                }
            }
        });
        if (error.get() != null) {
            throw (Exception)error.get();
        }
    }
}

