/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.schematic.internal.io;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.OutputStream;
import org.infinispan.schematic.internal.io.BsonDataOutput;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class BsonDataOutputTest {
    private BsonDataOutput output;
    private ByteArrayOutputStream bigEndianBytes;
    private DataOutputStream bigEndian;
    private ByteArrayOutputStream littleEndianBytes;

    @Before
    public void beforeMethod() {
        this.output = new BsonDataOutput();
        this.bigEndianBytes = new ByteArrayOutputStream();
        this.bigEndian = new DataOutputStream(this.bigEndianBytes);
        this.littleEndianBytes = new ByteArrayOutputStream();
    }

    @After
    public void afterMethod() {
    }

    @Test
    public void shouldWriteAndReadInteger() throws Exception {
        this.output.writeInt(102);
        this.bigEndian.writeInt(this.toLittleEndian(102));
        this.output.writeTo((OutputStream)this.littleEndianBytes);
        this.assertSame(this.littleEndianBytes.toByteArray(), this.bigEndianBytes.toByteArray(), "littleEndian", "bigEndian");
    }

    @Test
    public void shouldWriteAndReadLong() throws Exception {
        this.output.writeLong(102L);
        this.bigEndian.writeLong(this.toLittleEndian(102L));
        this.output.writeTo((OutputStream)this.littleEndianBytes);
        this.assertSame(this.littleEndianBytes.toByteArray(), this.bigEndianBytes.toByteArray(), "littleEndian", "bigEndian");
    }

    @Test
    public void shouldWriteAndReadShort() throws Exception {
        this.output.writeShort(102);
        this.bigEndian.writeShort(this.toLittleEndian((short)102));
        this.output.writeTo((OutputStream)this.littleEndianBytes);
        this.assertSame(this.littleEndianBytes.toByteArray(), this.bigEndianBytes.toByteArray(), "littleEndian", "bigEndian");
    }

    @Test
    public void shouldWriteAndReadChar() throws Exception {
        this.output.writeChar(99);
        this.bigEndian.writeChar(this.toLittleEndian('c'));
        this.output.writeTo((OutputStream)this.littleEndianBytes);
        this.assertSame(this.littleEndianBytes.toByteArray(), this.bigEndianBytes.toByteArray(), "littleEndian", "bigEndian");
    }

    protected char toLittleEndian(char value) {
        byte b1 = (byte)value;
        byte b2 = (byte)(value >> 8);
        int result = b1 << 8 | b2 & 0xFF;
        return (char)result;
    }

    protected short toLittleEndian(short value) {
        byte b1 = (byte)value;
        byte b2 = (byte)(value >> 8);
        int result = b1 << 8 | b2 & 0xFF;
        return (short)result;
    }

    protected int toLittleEndian(int value) {
        byte b1 = (byte)value;
        byte b2 = (byte)(value >> 8);
        byte b3 = (byte)(value >> 16);
        byte b4 = (byte)(value >> 24);
        int result = b1 << 24 | (b2 & 0xFF) << 16 | (b3 & 0xFF) << 8 | b4 & 0xFF;
        return result;
    }

    protected long toLittleEndian(long value) {
        byte b1 = (byte)value;
        byte b2 = (byte)(value >> 8);
        byte b3 = (byte)(value >> 16);
        byte b4 = (byte)(value >> 24);
        byte b5 = (byte)(value >> 32);
        byte b6 = (byte)(value >> 40);
        byte b7 = (byte)(value >> 48);
        byte b8 = (byte)(value >> 56);
        long result = ((long)b1 & 0xFFL) << 56 | ((long)b2 & 0xFFL) << 48 | ((long)b3 & 0xFFL) << 40 | ((long)b4 & 0xFFL) << 32 | ((long)b5 & 0xFFL) << 24 | ((long)b6 & 0xFFL) << 16 | ((long)b7 & 0xFFL) << 8 | (long)b8 & 0xFFL;
        return result;
    }

    protected void assertSame(byte[] b1, byte[] b2, String name1, String name2) {
        if (b1.equals(b2)) {
            return;
        }
        int s1 = b1.length;
        int s2 = b2.length;
        StringBuilder sb1 = new StringBuilder();
        for (byte b : b1) {
            sb1.append(b).append(' ');
        }
        StringBuilder sb2 = new StringBuilder();
        for (byte b : b2) {
            sb2.append(b).append(' ');
        }
        if (!sb1.toString().equals(sb2.toString())) {
            System.out.println(name1 + " size: " + s1 + " content: " + sb1);
            System.out.println(name2 + " size: " + s2 + " content: " + sb2);
            assert (false);
        }
    }
}

