/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.schematic.internal;

import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.infinispan.AdvancedCache;
import org.infinispan.batch.AutoBatchSupport;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.FlagContainer;
import org.infinispan.marshall.MarshalledValue;
import org.infinispan.schematic.SchematicEntry;
import org.infinispan.schematic.document.Binary;
import org.infinispan.schematic.document.Document;
import org.infinispan.schematic.document.EditableDocument;
import org.infinispan.schematic.document.Path;
import org.infinispan.schematic.internal.CacheContext;
import org.infinispan.schematic.internal.SchematicEntryLiteral;
import org.infinispan.schematic.internal.delta.DocumentObserver;
import org.infinispan.schematic.internal.document.DocumentEditor;
import org.infinispan.schematic.internal.document.MutableDocument;
import org.infinispan.schematic.internal.document.ObservableDocumentEditor;
import org.infinispan.transaction.LocalTransaction;
import org.infinispan.transaction.TransactionTable;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class SchematicEntryProxy
extends AutoBatchSupport
implements SchematicEntry {
    private static final Log LOGGER = LogFactory.getLog(SchematicEntryProxy.class);
    private static final boolean TRACE = LOGGER.isTraceEnabled();
    private final CacheContext context;
    private final FlagContainer flagContainer;
    private final String key;
    private volatile boolean startedReadingValue = false;

    SchematicEntryProxy(CacheContext context, String key, FlagContainer flagContainer) {
        this.key = key;
        this.context = context;
        this.batchContainer = context.getCacheForWriting().getBatchContainer();
        this.flagContainer = flagContainer;
    }

    protected SchematicEntryLiteral toValue(Object object) {
        Object value = object instanceof MarshalledValue ? ((MarshalledValue)object).get() : object;
        return (SchematicEntryLiteral)value;
    }

    private void assertValid(SchematicEntryLiteral value) {
        if (this.startedReadingValue && (value == null || value.removed)) {
            throw new IllegalStateException("SchematicValue stored under key " + this.key + " has been concurrently removed!");
        }
    }

    protected CacheEntry lookupEntryFromCurrentTransaction() {
        try {
            TransactionManager txnMgr = this.context.getTransactionManager();
            TransactionTable transactionTable = this.context.getTransactionTable();
            Transaction tx = txnMgr.getTransaction();
            LocalTransaction localTransaction = tx == null ? null : transactionTable.getLocalTransaction(tx);
            return localTransaction == null ? null : localTransaction.lookupEntry((Object)this.key);
        }
        catch (SystemException e) {
            return null;
        }
    }

    private SchematicEntryLiteral getDeltaValueForRead() {
        SchematicEntryLiteral value = this.toValue(this.context.getCache().get((Object)this.key));
        if (value != null && !this.startedReadingValue) {
            this.startedReadingValue = true;
        }
        this.assertValid(value);
        return value;
    }

    private SchematicEntryLiteral getDeltaValueForWrite() {
        boolean suppressLocks;
        boolean lockedAndCopied;
        CacheEntry lookedUpEntry = this.lookupEntryFromCurrentTransaction();
        boolean bl = lockedAndCopied = lookedUpEntry != null && lookedUpEntry.isChanged() && this.toValue((Object)lookedUpEntry.getValue()).copied;
        if (lockedAndCopied) {
            return this.getDeltaValueForRead();
        }
        boolean bl2 = suppressLocks = this.flagContainer != null && this.flagContainer.hasFlag(Flag.SKIP_LOCKING);
        if (!suppressLocks && this.flagContainer != null) {
            this.flagContainer.setFlags(new Flag[]{Flag.FORCE_WRITE_LOCK});
        }
        if (TRACE) {
            if (suppressLocks) {
                LOGGER.trace((Object)"Skip locking flag used.  Skipping locking.");
            } else {
                LOGGER.trace((Object)"Forcing write lock even for reads");
            }
        }
        if (this.context.isExplicitLockingEnabled()) {
            this.context.getCacheForLocking().lock((Object[])new String[]{this.key});
        }
        SchematicEntryLiteral value = this.getDeltaValueForRead();
        SchematicEntryLiteral copy = null;
        if (value != null) {
            copy = value.copyForWrite();
        } else {
            copy = new SchematicEntryLiteral(this.key);
            copy.copied = true;
        }
        copy.createDelta(this.context);
        if (TRACE) {
            LOGGER.trace((Object)("Created copy of " + this.key + ": " + copy.data()));
        }
        if (suppressLocks) {
            this.flagContainer.setFlags(new Flag[]{Flag.SKIP_LOCKING});
        }
        AdvancedCache<String, SchematicEntry> cache = this.context.getCacheForWriting();
        cache.put((Object)this.key, (Object)copy);
        return copy;
    }

    @Override
    public Document getMetadata() {
        SchematicEntryLiteral value = this.getDeltaValueForRead();
        return value.getMetadata();
    }

    @Override
    public String getContentType() {
        SchematicEntryLiteral value = this.getDeltaValueForRead();
        return value.getContentType();
    }

    @Override
    public Object getContent() {
        SchematicEntryLiteral value = this.getDeltaValueForRead();
        return value.getContent();
    }

    @Override
    public Document getContentAsDocument() {
        SchematicEntryLiteral value = this.getDeltaValueForRead();
        return value.getContentAsDocument();
    }

    @Override
    public Binary getContentAsBinary() {
        SchematicEntryLiteral value = this.getDeltaValueForRead();
        return value.getContentAsBinary();
    }

    @Override
    public boolean hasDocumentContent() {
        SchematicEntryLiteral value = this.getDeltaValueForRead();
        return value.hasDocumentContent();
    }

    @Override
    public boolean hasBinaryContent() {
        SchematicEntryLiteral value = this.getDeltaValueForRead();
        return value.hasBinaryContent();
    }

    @Override
    public Document asDocument() {
        SchematicEntryLiteral value = this.getDeltaValueForRead();
        return value.asDocument();
    }

    public String toString() {
        return "SchematicValueProxy{key=" + this.key + '}';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setContent(Binary content, Document metadata, String defaultContentType) {
        try {
            this.startAtomic();
            this.getDeltaValueForWrite().internalSetContent(content, metadata, defaultContentType);
        }
        finally {
            this.endAtomic();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setContent(Document content, Document metadata, String defaultContentType) {
        try {
            this.startAtomic();
            this.getDeltaValueForWrite().internalSetContent(content, metadata, defaultContentType);
        }
        finally {
            this.endAtomic();
        }
    }

    @Override
    public EditableDocument editDocumentContent() {
        SchematicEntryLiteral writable = this.getDeltaValueForWrite();
        Document content = writable.data().getDocument("content");
        return this.editorFor(content, SchematicEntryLiteral.FieldPath.CONTENT, writable.getDelta());
    }

    @Override
    public EditableDocument editMetadata() {
        SchematicEntryLiteral writable = this.getDeltaValueForWrite();
        Document metadata = writable.data().getDocument("metadata");
        return this.editorFor(metadata, SchematicEntryLiteral.FieldPath.METADATA, writable.getDelta());
    }

    protected EditableDocument editorFor(Document doc, Path pathToDocument, DocumentObserver observer) {
        if (doc == null) {
            return null;
        }
        if (doc instanceof DocumentEditor) {
            return (DocumentEditor)doc;
        }
        if (this.context.isDeltaContainingChangesEnabled() && this.context.isClustered()) {
            return new ObservableDocumentEditor((MutableDocument)doc, pathToDocument, observer, null);
        }
        return new DocumentEditor((MutableDocument)doc);
    }
}

