/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.topology;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.util.CollectionFactory;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.distribution.ch.ConsistentHashFactory;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachemanagerlistener.CacheManagerNotifier;
import org.infinispan.notifications.cachemanagerlistener.annotation.Merged;
import org.infinispan.notifications.cachemanagerlistener.annotation.ViewChanged;
import org.infinispan.notifications.cachemanagerlistener.event.ViewChangedEvent;
import org.infinispan.remoting.responses.ExceptionResponse;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.SuccessfulResponse;
import org.infinispan.remoting.rpc.ResponseMode;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.topology.CacheJoinInfo;
import org.infinispan.topology.CacheTopology;
import org.infinispan.topology.CacheTopologyControlCommand;
import org.infinispan.topology.ClusterCacheStatus;
import org.infinispan.topology.ClusterTopologyManager;
import org.infinispan.topology.RebalancePolicy;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class ClusterTopologyManagerImpl
implements ClusterTopologyManager {
    private static Log log = LogFactory.getLog(ClusterTopologyManagerImpl.class);
    private Transport transport;
    private RebalancePolicy rebalancePolicy;
    private GlobalConfiguration globalConfiguration;
    private GlobalComponentRegistry gcr;
    private CacheManagerNotifier cacheManagerNotifier;
    private ExecutorService asyncTransportExecutor;
    private volatile boolean isCoordinator;
    private volatile boolean isShuttingDown;
    private volatile int viewId = -1;
    private final Object viewUpdateLock = new Object();
    private final Object viewHandlingLock = new Object();
    private final ConcurrentMap<String, ClusterCacheStatus> cacheStatusMap = CollectionFactory.makeConcurrentMap();
    private ClusterViewListener viewListener;

    @Inject
    public void inject(Transport transport, RebalancePolicy rebalancePolicy, @ComponentName(value="org.infinispan.executors.transport") ExecutorService asyncTransportExecutor, GlobalConfiguration globalConfiguration, GlobalComponentRegistry gcr, CacheManagerNotifier cacheManagerNotifier) {
        this.transport = transport;
        this.rebalancePolicy = rebalancePolicy;
        this.asyncTransportExecutor = asyncTransportExecutor;
        this.globalConfiguration = globalConfiguration;
        this.gcr = gcr;
        this.cacheManagerNotifier = cacheManagerNotifier;
    }

    @Start(priority=100)
    public void start() {
        this.isShuttingDown = false;
        this.isCoordinator = this.transport.isCoordinator();
        this.viewListener = new ClusterViewListener();
        this.cacheManagerNotifier.addListener(this.viewListener);
        this.handleNewView(this.transport.getMembers(), false, this.transport.getViewId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Stop(priority=100)
    public void stop() {
        this.isShuttingDown = true;
        this.cacheManagerNotifier.removeListener(this.viewListener);
        Object object = this.viewUpdateLock;
        synchronized (object) {
            this.viewId = Integer.MAX_VALUE;
            this.viewUpdateLock.notifyAll();
        }
    }

    @Override
    public void triggerRebalance(final String cacheName) {
        this.asyncTransportExecutor.submit(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                try {
                    ClusterTopologyManagerImpl.this.startRebalance(cacheName);
                    return null;
                }
                catch (Throwable t) {
                    log.rebalanceStartError(cacheName, t);
                    throw new Exception(t);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CacheTopology handleJoin(String cacheName, Address joiner, CacheJoinInfo joinInfo, int viewId) throws Exception {
        boolean hadEmptyConsistentHashes;
        ClusterCacheStatus cacheStatus;
        this.waitForView(viewId);
        if (this.isShuttingDown) {
            log.debugf("Ignoring join request from %s for cache %s, the local cache manager is shutting down", joiner, cacheName);
            return null;
        }
        ClusterCacheStatus clusterCacheStatus = cacheStatus = this.initCacheStatusIfAbsent(cacheName, joinInfo);
        synchronized (clusterCacheStatus) {
            hadEmptyConsistentHashes = cacheStatus.getCacheTopology().getMembers().isEmpty();
            cacheStatus.addMember(joiner, joinInfo.getCapacityFactor());
            if (hadEmptyConsistentHashes) {
                int newTopologyId = cacheStatus.getCacheTopology().getTopologyId() + 1;
                List<Address> initialMembers = cacheStatus.getMembers();
                Object initialCH = joinInfo.getConsistentHashFactory().create(joinInfo.getHashFunction(), joinInfo.getNumOwners(), joinInfo.getNumSegments(), initialMembers, cacheStatus.getCapacityFactors());
                CacheTopology initialTopology = new CacheTopology(newTopologyId, (ConsistentHash)initialCH, null);
                cacheStatus.updateCacheTopology(initialTopology);
            }
        }
        if (hadEmptyConsistentHashes) {
            this.rebalancePolicy.initCache(cacheName, cacheStatus);
        } else {
            this.rebalancePolicy.updateCacheStatus(cacheName, cacheStatus);
        }
        return cacheStatus.getCacheTopology();
    }

    @Override
    public void handleLeave(String cacheName, Address leaver, int viewId) throws Exception {
        if (this.isShuttingDown) {
            log.debugf("Ignoring leave request from %s for cache %s, the local cache manager is shutting down", leaver, cacheName);
            return;
        }
        ClusterCacheStatus cacheStatus = (ClusterCacheStatus)this.cacheStatusMap.get(cacheName);
        if (cacheStatus == null) {
            log.tracef("Ignoring leave request from %s for cache %s because it doesn't have a cache status entry", new Object[0]);
            return;
        }
        boolean actualLeaver = cacheStatus.removeMember(leaver);
        if (!actualLeaver) {
            return;
        }
        this.onCacheMembershipChange(cacheName, cacheStatus);
    }

    @Override
    public void handleRebalanceCompleted(String cacheName, Address node, int topologyId, Throwable throwable, int viewId) throws Exception {
        if (throwable != null) {
            log.rebalanceError(cacheName, node, throwable);
        }
        log.debugf("Finished local rebalance for cache %s on node %s, topology id = %d", cacheName, node, topologyId);
        ClusterCacheStatus cacheStatus = (ClusterCacheStatus)this.cacheStatusMap.get(cacheName);
        if (cacheStatus == null || !cacheStatus.isRebalanceInProgress()) {
            throw new CacheException(String.format("Received invalid rebalance confirmation from %s for cache %s, we don't have a rebalance in progress", node, cacheName));
        }
        boolean rebalanceCompleted = cacheStatus.confirmRebalanceOnNode(node, topologyId);
        if (rebalanceCompleted) {
            this.endRebalance(cacheName, cacheStatus);
            this.broadcastConsistentHashUpdate(cacheName, cacheStatus);
            this.rebalancePolicy.updateCacheStatus(cacheName, cacheStatus);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleNewView(List<Address> ignored, boolean mergeView, int newViewId) {
        Object object = this.viewHandlingLock;
        synchronized (object) {
            if (newViewId <= this.viewId) {
                log.tracef("Ignoring old cluster view notification: %s", newViewId);
                return;
            }
            boolean becameCoordinator = !this.isCoordinator && this.transport.isCoordinator();
            this.isCoordinator = this.transport.isCoordinator();
            log.tracef("Received new cluster view: %s, isCoordinator = %s, becameCoordinator = %s", newViewId, this.isCoordinator, becameCoordinator);
            if (this.isCoordinator && mergeView || becameCoordinator) {
                try {
                    HashMap<String, List<CacheTopology>> clusterCacheMap = this.recoverClusterStatus(newViewId);
                    for (Map.Entry entry : clusterCacheMap.entrySet()) {
                        String cacheName = (String)entry.getKey();
                        List topologyList = (List)entry.getValue();
                        try {
                            this.updateCacheStatusAfterMerge(cacheName, this.transport.getMembers(), topologyList);
                        }
                        catch (Exception e) {
                            log.failedToRecoverCacheState(cacheName, e);
                        }
                    }
                }
                catch (InterruptedException e) {
                    log.tracef("Cluster state recovery interrupted because the coordinator is shutting down", new Object[0]);
                    return;
                }
                catch (Exception e) {
                    log.failedToRecoverClusterState(e);
                }
            } else if (this.isCoordinator) {
                try {
                    this.updateClusterMembers(this.transport.getMembers());
                }
                catch (Exception e) {
                    log.errorUpdatingMembersList(e);
                }
            }
            Object object2 = this.viewUpdateLock;
            synchronized (object2) {
                this.viewId = newViewId;
                this.viewUpdateLock.notifyAll();
            }
        }
    }

    private ClusterCacheStatus initCacheStatusIfAbsent(String cacheName, CacheJoinInfo joinInfo) {
        ClusterCacheStatus newCacheStatus;
        ClusterCacheStatus cacheStatus = (ClusterCacheStatus)this.cacheStatusMap.get(cacheName);
        if (cacheStatus == null && (cacheStatus = this.cacheStatusMap.putIfAbsent(cacheName, newCacheStatus = new ClusterCacheStatus(cacheName, joinInfo))) == null) {
            cacheStatus = newCacheStatus;
        }
        return cacheStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCacheStatusAfterMerge(String cacheName, List<Address> clusterMembers, List<CacheTopology> partitionTopologies) throws Exception {
        log.tracef("Initializing rebalance policy for cache %s, pre-existing partitions are %s", cacheName, partitionTopologies);
        ClusterCacheStatus cacheStatus = (ClusterCacheStatus)this.cacheStatusMap.get(cacheName);
        if (partitionTopologies.isEmpty()) {
            return;
        }
        ClusterCacheStatus clusterCacheStatus = cacheStatus;
        synchronized (clusterCacheStatus) {
            int unionTopologyId = 0;
            ConsistentHash currentCHUnion = null;
            ConsistentHashFactory chFactory = cacheStatus.getJoinInfo().getConsistentHashFactory();
            for (CacheTopology topology : partitionTopologies) {
                if (topology.getTopologyId() > unionTopologyId) {
                    unionTopologyId = topology.getTopologyId();
                }
                if (currentCHUnion == null) {
                    currentCHUnion = topology.getCurrentCH();
                    continue;
                }
                currentCHUnion = chFactory.union(currentCHUnion, topology.getCurrentCH());
            }
            cacheStatus.updateClusterMembers(clusterMembers);
            List<Address> members = cacheStatus.getMembers();
            if (members.isEmpty()) {
                log.tracef("Cache %s has no members left, skipping topology update", cacheName);
                return;
            }
            if (currentCHUnion != null) {
                currentCHUnion = chFactory.updateMembers(currentCHUnion, members, cacheStatus.getCapacityFactors());
            }
            CacheTopology cacheTopology = new CacheTopology(unionTopologyId += 2, currentCHUnion, null);
            if (cacheStatus.isRebalanceInProgress()) {
                cacheStatus.endRebalance();
            }
            cacheStatus.updateCacheTopology(cacheTopology);
        }
        this.broadcastConsistentHashUpdate(cacheName, cacheStatus);
        this.rebalancePolicy.updateCacheStatus(cacheName, cacheStatus);
    }

    private void broadcastConsistentHashUpdate(String cacheName, ClusterCacheStatus cacheStatus) throws Exception {
        CacheTopology cacheTopology = cacheStatus.getCacheTopology();
        log.debugf("Updating cluster-wide consistent hash for cache %s, topology = %s", cacheName, cacheTopology);
        CacheTopologyControlCommand command = new CacheTopologyControlCommand(cacheName, CacheTopologyControlCommand.Type.CH_UPDATE, this.transport.getAddress(), cacheTopology, this.transport.getViewId());
        this.executeOnClusterAsync(command, this.getGlobalTimeout(), cacheStatus.isTotalOrder(), cacheStatus.isDistributed());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startRebalance(String cacheName) throws Exception {
        ClusterCacheStatus cacheStatus;
        ClusterCacheStatus clusterCacheStatus = cacheStatus = (ClusterCacheStatus)this.cacheStatusMap.get(cacheName);
        synchronized (clusterCacheStatus) {
            ConsistentHash updatedMembersCH;
            CacheTopology cacheTopology = cacheStatus.getCacheTopology();
            if (cacheStatus.isRebalanceInProgress()) {
                log.tracef("Ignoring request to rebalance cache %s, there's already a rebalance in progress: %s", cacheName, cacheTopology);
                return;
            }
            ArrayList<Address> newMembers = new ArrayList<Address>(cacheStatus.getMembers());
            if (newMembers.isEmpty()) {
                log.tracef("Ignoring request to rebalance cache %s, it doesn't have any member", cacheName);
                return;
            }
            log.tracef("Rebalancing consistent hash for cache %s, members are %s", cacheName, newMembers);
            int newTopologyId = cacheTopology.getTopologyId() + 1;
            ConsistentHash currentCH = cacheTopology.getCurrentCH();
            if (currentCH == null) {
                log.tracef("Ignoring request to rebalance cache %s, it doesn't have a consistent hash", cacheName);
                return;
            }
            if (!newMembers.containsAll(currentCH.getMembers())) {
                newMembers.removeAll(currentCH.getMembers());
                log.tracef("Ignoring request to rebalance cache %s, we have new leavers: %s", cacheName, newMembers);
                return;
            }
            ConsistentHashFactory chFactory = cacheStatus.getJoinInfo().getConsistentHashFactory();
            ConsistentHash balancedCH = chFactory.rebalance(updatedMembersCH = chFactory.updateMembers(currentCH, newMembers, cacheStatus.getCapacityFactors()));
            if (balancedCH.equals(currentCH)) {
                log.tracef("The balanced CH is the same as the current CH, not rebalancing", new Object[0]);
                return;
            }
            CacheTopology newTopology = new CacheTopology(newTopologyId, currentCH, balancedCH);
            log.tracef("Updating cache %s topology for rebalance: %s", cacheName, newTopology);
            newTopology.logRoutingTableInformation();
            cacheStatus.startRebalance(newTopology);
        }
        this.rebalancePolicy.updateCacheStatus(cacheName, cacheStatus);
        this.broadcastRebalanceStart(cacheName, cacheStatus);
    }

    private void broadcastRebalanceStart(String cacheName, ClusterCacheStatus cacheStatus) throws Exception {
        CacheTopology cacheTopology = cacheStatus.getCacheTopology();
        log.debugf("Starting cluster-wide rebalance for cache %s, topology = %s", cacheName, cacheTopology);
        CacheTopologyControlCommand command = new CacheTopologyControlCommand(cacheName, CacheTopologyControlCommand.Type.REBALANCE_START, this.transport.getAddress(), cacheTopology, this.transport.getViewId());
        this.executeOnClusterAsync(command, this.getGlobalTimeout(), cacheStatus.isTotalOrder(), cacheStatus.isDistributed());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endRebalance(String cacheName, ClusterCacheStatus cacheStatus) {
        ClusterCacheStatus clusterCacheStatus = cacheStatus;
        synchronized (clusterCacheStatus) {
            CacheTopology currentTopology = cacheStatus.getCacheTopology();
            int currentTopologyId = currentTopology.getTopologyId();
            log.debugf("Finished cluster-wide rebalance for cache %s, topology id = %d", cacheName, currentTopologyId);
            int newTopologyId = currentTopologyId + 1;
            ConsistentHash newCurrentCH = currentTopology.getPendingCH();
            CacheTopology newTopology = new CacheTopology(newTopologyId, newCurrentCH, null);
            cacheStatus.updateCacheTopology(newTopology);
            cacheStatus.endRebalance();
        }
    }

    private HashMap<String, List<CacheTopology>> recoverClusterStatus(int newViewId) throws Exception {
        log.debugf("Recovering running caches in the cluster", new Object[0]);
        CacheTopologyControlCommand command = new CacheTopologyControlCommand(null, CacheTopologyControlCommand.Type.GET_STATUS, this.transport.getAddress(), newViewId);
        Map<Address, Object> statusResponses = this.executeOnClusterSync(command, this.getGlobalTimeout(), false, false);
        HashMap<String, List<CacheTopology>> clusterCacheMap = new HashMap<String, List<CacheTopology>>();
        for (Map.Entry<Address, Object> responseEntry : statusResponses.entrySet()) {
            Address sender = responseEntry.getKey();
            Map nodeStatus = (Map)responseEntry.getValue();
            for (Map.Entry statusEntry : nodeStatus.entrySet()) {
                String cacheName = (String)statusEntry.getKey();
                CacheJoinInfo joinInfo = (CacheJoinInfo)((Object[])statusEntry.getValue())[0];
                CacheTopology cacheTopology = (CacheTopology)((Object[])statusEntry.getValue())[1];
                List<CacheTopology> topologyList = clusterCacheMap.get(cacheName);
                if (topologyList == null) {
                    this.initCacheStatusIfAbsent(cacheName, joinInfo);
                    topologyList = new ArrayList<CacheTopology>();
                    clusterCacheMap.put(cacheName, topologyList);
                }
                if (cacheTopology != null) {
                    topologyList.add(cacheTopology);
                    for (Address member : cacheTopology.getMembers()) {
                        if (!statusResponses.containsKey(member)) continue;
                        Map memberStatus = (Map)statusResponses.get(member);
                        CacheJoinInfo memberJoinInfo = (CacheJoinInfo)((Object[])memberStatus.get(cacheName))[0];
                        float capacityFactor = memberJoinInfo.getCapacityFactor();
                        ((ClusterCacheStatus)this.cacheStatusMap.get(cacheName)).addMember(member, capacityFactor);
                    }
                }
                ((ClusterCacheStatus)this.cacheStatusMap.get(cacheName)).addMember(sender, joinInfo.getCapacityFactor());
            }
        }
        return clusterCacheMap;
    }

    public void updateClusterMembers(List<Address> newClusterMembers) throws Exception {
        log.tracef("Updating cluster members for all the caches. New list is %s", newClusterMembers);
        for (Map.Entry e : this.cacheStatusMap.entrySet()) {
            String cacheName = (String)e.getKey();
            ClusterCacheStatus cacheStatus = (ClusterCacheStatus)e.getValue();
            boolean cacheMembersModified = cacheStatus.updateClusterMembers(newClusterMembers);
            if (!cacheMembersModified) continue;
            this.onCacheMembershipChange(cacheName, cacheStatus);
        }
    }

    private boolean onCacheMembershipChange(String cacheName, ClusterCacheStatus cacheStatus) throws Exception {
        boolean topologyChanged = this.updateTopologyAfterMembershipChange(cacheName, cacheStatus);
        if (!topologyChanged) {
            return true;
        }
        boolean rebalanceCompleted = cacheStatus.updateRebalanceMembersList();
        if (rebalanceCompleted) {
            this.endRebalance(cacheName, cacheStatus);
        }
        this.broadcastConsistentHashUpdate(cacheName, cacheStatus);
        this.rebalancePolicy.updateCacheStatus(cacheName, cacheStatus);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateTopologyAfterMembershipChange(String cacheName, ClusterCacheStatus cacheStatus) {
        ClusterCacheStatus clusterCacheStatus = cacheStatus;
        synchronized (clusterCacheStatus) {
            ConsistentHashFactory consistentHashFactory = cacheStatus.getJoinInfo().getConsistentHashFactory();
            int topologyId = cacheStatus.getCacheTopology().getTopologyId();
            ConsistentHash currentCH = cacheStatus.getCacheTopology().getCurrentCH();
            ConsistentHash pendingCH = cacheStatus.getCacheTopology().getPendingCH();
            if (!cacheStatus.needConsistentHashUpdate()) {
                log.tracef("Cache %s members list was updated, but the cache topology doesn't need to change: %s", cacheName, cacheStatus.getCacheTopology());
                return false;
            }
            List<Address> newCurrentMembers = cacheStatus.pruneInvalidMembers(currentCH.getMembers());
            if (newCurrentMembers.isEmpty()) {
                CacheTopology newTopology = new CacheTopology(topologyId + 1, null, null);
                cacheStatus.updateCacheTopology(newTopology);
                log.tracef("Initial topology installed for cache %s: %s", cacheName, newTopology);
                return false;
            }
            ConsistentHash newCurrentCH = consistentHashFactory.updateMembers(currentCH, newCurrentMembers, cacheStatus.getCapacityFactors());
            ConsistentHash newPendingCH = null;
            if (pendingCH != null) {
                List<Address> newPendingMembers = cacheStatus.pruneInvalidMembers(pendingCH.getMembers());
                newPendingCH = consistentHashFactory.updateMembers(pendingCH, newPendingMembers, cacheStatus.getCapacityFactors());
            }
            CacheTopology newTopology = new CacheTopology(topologyId + 1, newCurrentCH, newPendingCH);
            cacheStatus.updateCacheTopology(newTopology);
            log.tracef("Cache %s topology updated: %s", cacheName, newTopology);
            newTopology.logRoutingTableInformation();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForView(int viewId) throws InterruptedException {
        if (this.viewId < viewId) {
            log.tracef("Received a cache topology command with a higher view id: %s, our view id is %s", viewId, this.viewId);
        }
        Object object = this.viewUpdateLock;
        synchronized (object) {
            while (this.viewId < viewId) {
                this.viewUpdateLock.wait(1000L);
            }
        }
    }

    private Map<Address, Object> executeOnClusterSync(final ReplicableCommand command, final int timeout, boolean totalOrder, boolean distributed) throws Exception {
        Response localResponse;
        if (totalOrder) {
            Map<Address, Response> responseMap = this.transport.invokeRemotely(null, command, ResponseMode.SYNCHRONOUS_IGNORE_LEAVERS, timeout, false, null, totalOrder, distributed);
            HashMap<Address, Object> responseValues = new HashMap<Address, Object>(this.transport.getMembers().size());
            for (Map.Entry<Address, Response> entry : responseMap.entrySet()) {
                Address address = entry.getKey();
                Response response = entry.getValue();
                if (!response.isSuccessful()) {
                    Exception cause = response instanceof ExceptionResponse ? ((ExceptionResponse)response).getException() : null;
                    throw new CacheException("Unsuccessful response received from node " + address + ": " + response, (Throwable)cause);
                }
                responseValues.put(address, ((SuccessfulResponse)response).getResponseValue());
            }
            return responseValues;
        }
        Future<Map<Address, Response>> remoteFuture = this.asyncTransportExecutor.submit(new Callable<Map<Address, Response>>(){

            @Override
            public Map<Address, Response> call() throws Exception {
                return ClusterTopologyManagerImpl.this.transport.invokeRemotely(null, command, ResponseMode.SYNCHRONOUS_IGNORE_LEAVERS, timeout, true, null, false, false);
            }
        });
        this.gcr.wireDependencies(command);
        try {
            if (log.isTraceEnabled()) {
                log.tracef("Attempting to execute command on self: %s", command);
            }
            localResponse = (Response)command.perform(null);
        }
        catch (Throwable throwable) {
            throw new Exception(throwable);
        }
        if (!localResponse.isSuccessful()) {
            throw new CacheException("Unsuccessful local response");
        }
        Map<Address, Response> responseMap = remoteFuture.get(timeout, TimeUnit.MILLISECONDS);
        HashMap<Address, Object> responseValues = new HashMap<Address, Object>(this.transport.getMembers().size());
        for (Map.Entry<Address, Response> entry : responseMap.entrySet()) {
            Address address = entry.getKey();
            Response response = entry.getValue();
            if (!response.isSuccessful()) {
                Exception cause = response instanceof ExceptionResponse ? ((ExceptionResponse)response).getException() : null;
                throw new CacheException("Unsuccessful response received from node " + address + ": " + response, (Throwable)cause);
            }
            responseValues.put(address, ((SuccessfulResponse)response).getResponseValue());
        }
        responseValues.put(this.transport.getAddress(), ((SuccessfulResponse)localResponse).getResponseValue());
        return responseValues;
    }

    private void executeOnClusterAsync(final ReplicableCommand command, int timeout, boolean totalOrder, boolean isDistributed) throws Exception {
        if (!totalOrder) {
            this.asyncTransportExecutor.submit(new Runnable(){

                @Override
                public void run() {
                    ClusterTopologyManagerImpl.this.gcr.wireDependencies(command);
                    try {
                        if (log.isTraceEnabled()) {
                            log.tracef("Attempting to execute command on self: %s", command);
                        }
                        command.perform(null);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            });
        }
        this.transport.invokeRemotely(null, command, ResponseMode.ASYNCHRONOUS_WITH_SYNC_MARSHALLING, timeout, true, null, totalOrder, isDistributed);
    }

    private int getGlobalTimeout() {
        return (int)this.globalConfiguration.transport().distributedSyncTimeout();
    }

    @Listener(sync=true)
    public class ClusterViewListener {
        @Merged
        @ViewChanged
        public void handleViewChange(final ViewChangedEvent e) {
            ClusterTopologyManagerImpl.this.asyncTransportExecutor.submit(new Runnable(){

                @Override
                public void run() {
                    ClusterTopologyManagerImpl.this.handleNewView(e.getNewMembers(), e.isMergeView(), e.getViewId());
                }
            });
        }
    }
}

