/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.schematic.internal;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.infinispan.atomic.DeltaAware;
import org.infinispan.commons.marshall.SerializeWith;
import org.infinispan.commons.util.Util;
import org.infinispan.schematic.internal.SchematicDelta;
import org.infinispan.schematic.internal.SchematicEntryLiteral;
import org.infinispan.schematic.internal.SchematicExternalizer;
import org.infinispan.schematic.internal.delta.Operation;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@SerializeWith(value=Externalizer.class)
public class SchematicEntryDelta
implements SchematicDelta {
    private static final Log LOG = LogFactory.getLog(SchematicEntryDelta.class);
    private static final boolean TRACE = LOG.isTraceEnabled();
    private final String key;
    private final List<Operation> changeLog;

    public SchematicEntryDelta(String key) {
        this.key = key;
        this.changeLog = new LinkedList<Operation>();
        assert (this.key != null);
        assert (this.changeLog != null);
    }

    public SchematicEntryDelta(String key, List<Operation> changeLog) {
        this.key = key;
        this.changeLog = changeLog;
        assert (this.key != null);
        assert (this.changeLog != null);
    }

    public DeltaAware merge(DeltaAware d) {
        SchematicEntryLiteral other = null;
        if (d != null && d instanceof SchematicEntryLiteral) {
            other = (SchematicEntryLiteral)d;
            LOG.trace((Object)("Merging delta " + this.changeLog + " into existing " + other));
        } else {
            other = new SchematicEntryLiteral();
            LOG.trace((Object)("Merging delta " + this.changeLog + " into new SchematicEntryLiteral"));
        }
        try {
            if (this.changeLog != null) {
                other.apply(this.changeLog);
            }
        }
        catch (RuntimeException e) {
            LOG.debug((Object)("Exception while merging delta " + this + " onto " + d), (Throwable)e);
            throw e;
        }
        finally {
            other.commit();
        }
        return other;
    }

    @Override
    public boolean isRecordingOperations() {
        return true;
    }

    @Override
    public void addOperation(Operation o) {
        this.changeLog.add(o);
    }

    public String toString() {
        return "SchematicEntryDelta{key=" + this.key + "," + "changeLog=" + this.changeLog + '}';
    }

    public int hashCode() {
        return this.changeLog.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof SchematicEntryDelta) {
            SchematicEntryDelta other = (SchematicEntryDelta)obj;
            return this.changeLog.equals(other.changeLog);
        }
        return false;
    }

    public static class Externalizer
    extends SchematicExternalizer<SchematicEntryDelta> {
        private static final long serialVersionUID = 1L;

        public void writeObject(ObjectOutput output, SchematicEntryDelta delta) throws IOException {
            if (TRACE) {
                LOG.tracef("Serializing %s", (Object)delta);
            }
            output.writeUTF(delta.key);
            output.writeObject(delta.changeLog);
        }

        public SchematicEntryDelta readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            String key = input.readUTF();
            List changeLog = (List)input.readObject();
            SchematicEntryDelta delta = new SchematicEntryDelta(key, changeLog);
            if (TRACE) {
                LOG.tracef("Deserialized %s", (Object)delta);
            }
            return delta;
        }

        @Override
        public Integer getId() {
            return 1601;
        }

        @Override
        public Set<Class<? extends SchematicEntryDelta>> getTypeClasses() {
            return Util.asSet((Object[])new Class[]{SchematicEntryDelta.class});
        }
    }
}

