/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.schematic;

import java.io.File;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.CacheContainer;
import org.infinispan.persistence.leveldb.configuration.LevelDBStoreConfiguration;
import org.infinispan.persistence.leveldb.configuration.LevelDBStoreConfigurationBuilder;
import org.infinispan.schematic.AbstractSchematicDbTest;
import org.infinispan.schematic.Schematic;
import org.infinispan.schematic.SchematicEntry;
import org.infinispan.schematic.TestUtil;
import org.infinispan.schematic.document.Document;
import org.infinispan.schematic.document.EditableDocument;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.lookup.DummyTransactionManagerLookup;
import org.infinispan.transaction.lookup.TransactionManagerLookup;
import org.junit.Before;
import org.junit.Test;

public class SchematicDbWithLevelDbTest
extends AbstractSchematicDbTest {
    @Override
    @Before
    public void beforeTest() {
        TestUtil.delete(new File("target/leveldb"));
        TestUtil.delete(new File("target/leveldbdocuments"));
        GlobalConfigurationBuilder globalConfigurationBuilder = new GlobalConfigurationBuilder();
        globalConfigurationBuilder.transport().transport(null).serialization().addAdvancedExternalizer(Schematic.externalizers());
        ConfigurationBuilder configurationBuilder = new ConfigurationBuilder();
        configurationBuilder.invocationBatching().enable().transaction().transactionManagerLookup((TransactionManagerLookup)new DummyTransactionManagerLookup());
        ((LevelDBStoreConfigurationBuilder)configurationBuilder.persistence().addStore(LevelDBStoreConfigurationBuilder.class)).implementationType(LevelDBStoreConfiguration.ImplementationType.JAVA).location("target/leveldb/store").expiredLocation("target/leveldb/expired").purgeOnStartup(true);
        this.cm = TestCacheManagerFactory.createClusteredCacheManager((GlobalConfigurationBuilder)globalConfigurationBuilder, (ConfigurationBuilder)configurationBuilder);
        this.tm = this.cm.getCache().getAdvancedCache().getTransactionManager();
        this.db = Schematic.get((CacheContainer)this.cm, (String)"documents");
    }

    @Test
    public void shouldGetNonExistantDocument() {
        String key = "can be anything";
        SchematicEntry entry = this.db.get(key);
        assert (entry == null) : "Should not have found a prior entry";
    }

    @Test
    public void shouldStoreDocumentWithUnusedKeyAndWithNullMetadata() {
        EditableDocument doc = Schematic.newDocument((String)"k1", (Object)"value1", (String)"k2", (Object)2);
        String key = "can be anything";
        SchematicEntry prior = this.db.put(key, (Document)doc, null);
        assert (prior == null) : "Should not have found a prior entry";
        SchematicEntry entry = this.db.get(key);
        assert (entry != null) : "Should have found the entry";
        Document read = entry.getContentAsDocument();
        assert (read != null);
        assert ("value1".equals(read.getString("k1")));
        assert (2 == read.getInteger("k2"));
        assert (entry.getContentAsBinary() == null) : "Should not have a Binary value for the entry's content";
        assert (read.containsAll((Document)doc));
        assert (read.equals(doc));
        Document readMetadata = entry.getMetadata();
        assert (readMetadata != null);
        assert (readMetadata.getString("id").equals(key));
    }

    @Test
    public void shouldStoreDocumentWithUnusedKeyAndWithNonNullMetadata() {
        EditableDocument doc = Schematic.newDocument((String)"k1", (Object)"value1", (String)"k2", (Object)2);
        EditableDocument metadata = Schematic.newDocument((String)"mimeType", (Object)"text/plain");
        String key = "can be anything";
        SchematicEntry prior = this.db.put(key, (Document)doc, (Document)metadata);
        assert (prior == null) : "Should not have found a prior entry";
        SchematicEntry entry = this.db.get(key);
        assert (entry != null) : "Should have found the entry";
        Document read = entry.getContentAsDocument();
        assert (read != null);
        assert ("value1".equals(read.getString("k1")));
        assert (2 == read.getInteger("k2"));
        assert (entry.getContentAsBinary() == null) : "Should not have a Binary value for the entry's content";
        assert (read.containsAll((Document)doc));
        assert (read.equals(doc));
        Document readMetadata = entry.getMetadata();
        assert (readMetadata != null);
        assert (readMetadata.getString("mimeType").equals(metadata.getString("mimeType")));
        assert (readMetadata.containsAll((Document)metadata));
        assert (!readMetadata.equals(metadata)) : "Expected:\n" + metadata + "\nFound: \n" + readMetadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldStoreDocumentAndFetchAndModifyAndRefetch() throws Exception {
        EditableDocument doc = Schematic.newDocument((String)"k1", (Object)"value1", (String)"k2", (Object)2);
        EditableDocument metadata = Schematic.newDocument((String)"mimeType", (Object)"text/plain");
        String key = "can be anything";
        SchematicEntry prior = this.db.put(key, (Document)doc, (Document)metadata);
        assert (prior == null) : "Should not have found a prior entry";
        SchematicEntry entry = this.db.get(key);
        assert (entry != null) : "Should have found the entry";
        Document read = entry.getContentAsDocument();
        assert (read != null);
        assert ("value1".equals(read.getString("k1")));
        assert (2 == read.getInteger("k2"));
        assert (entry.getContentAsBinary() == null) : "Should not have a Binary value for the entry's content";
        assert (read.containsAll((Document)doc));
        assert (read.equals(doc));
        try {
            this.tm.begin();
            EditableDocument editable = entry.editDocumentContent();
            editable.setBoolean("k3", true);
            editable.setNumber("k4", 3.5);
        }
        finally {
            this.tm.commit();
        }
        SchematicEntry entry2 = this.db.get(key);
        Document read2 = entry2.getContentAsDocument();
        assert (read2 != null);
        assert ("value1".equals(read2.getString("k1")));
        assert (2 == read2.getInteger("k2"));
        assert (read2.getBoolean("k3").booleanValue());
        assert (3.4 < read2.getDouble("k4"));
    }
}

