/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.schematic.internal.delta;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Set;
import org.infinispan.commons.marshall.SerializeWith;
import org.infinispan.commons.util.Util;
import org.infinispan.schematic.document.Path;
import org.infinispan.schematic.internal.HashCode;
import org.infinispan.schematic.internal.SchematicExternalizer;
import org.infinispan.schematic.internal.delta.Operation;
import org.infinispan.schematic.internal.document.MutableDocument;

@SerializeWith(value=Externalizer.class)
public class PutIfAbsentOperation
extends Operation {
    protected final String fieldName;
    protected final Object newValue;
    private transient boolean absent = false;

    public PutIfAbsentOperation(Path parentPath, String fieldName, Object newValue) {
        super(parentPath, HashCode.compute(parentPath, fieldName, newValue));
        this.fieldName = fieldName;
        this.newValue = newValue;
    }

    @Override
    public PutIfAbsentOperation clone() {
        return new PutIfAbsentOperation(this.getParentPath(), this.fieldName, this.cloneValue(this.newValue));
    }

    public Object getNewValue() {
        return this.newValue;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public boolean isApplied() {
        return this.absent;
    }

    @Override
    public void rollback(MutableDocument delegate) {
        MutableDocument parent = this.mutableParent(delegate);
        assert (parent != null);
        if (this.absent) {
            parent.remove(this.fieldName);
        }
    }

    @Override
    public void replay(MutableDocument delegate) {
        MutableDocument parent = this.mutableParent(delegate);
        assert (parent != null);
        if (!parent.containsField(this.fieldName)) {
            parent.put(this.fieldName, this.newValue);
            this.absent = true;
        }
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof PutIfAbsentOperation) {
            PutIfAbsentOperation other = (PutIfAbsentOperation)obj;
            return this.equalsIfNotNull(this.fieldName, other.fieldName) && this.absent == other.absent && this.equalsIfNotNull(this.newValue, other.newValue) && this.getParentPath().equals(other.getParentPath());
        }
        return false;
    }

    public String toString() {
        return "Put-if-absent at '" + this.parentPath + "' the '" + this.fieldName + "' field value '" + this.newValue + "'";
    }

    public static final class Externalizer
    extends SchematicExternalizer<PutIfAbsentOperation> {
        private static final long serialVersionUID = 1L;

        public void writeObject(ObjectOutput output, PutIfAbsentOperation put) throws IOException {
            output.writeObject(put.parentPath);
            output.writeUTF(put.fieldName);
            output.writeObject(put.newValue);
        }

        public PutIfAbsentOperation readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            Path path = (Path)input.readObject();
            String fieldName = input.readUTF();
            Object newValue = input.readObject();
            return new PutIfAbsentOperation(path, fieldName, newValue);
        }

        @Override
        public Integer getId() {
            return 1624;
        }

        @Override
        public Set<Class<? extends PutIfAbsentOperation>> getTypeClasses() {
            return Util.asSet((Object[])new Class[]{PutIfAbsentOperation.class});
        }
    }
}

