/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.schematic.internal.document;

import java.io.InputStream;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.infinispan.schematic.FixFor;
import org.infinispan.schematic.document.Document;
import org.infinispan.schematic.document.DocumentSequence;
import org.infinispan.schematic.document.ParsingException;
import org.infinispan.schematic.internal.document.JsonReader;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JsonReaderTest {
    protected JsonReader reader;
    protected boolean print;
    protected Document doc;

    @Before
    public void beforeTest() {
        this.reader = new JsonReader();
        this.print = false;
    }

    @After
    public void afterTest() {
        this.reader = null;
    }

    @Test
    public void shouldParseEmptyDocument() throws Exception {
        this.doc = this.reader.read("{ }");
    }

    @Test
    public void shouldParseEmptyDocumentWithLeadingWhitespace() throws Exception {
        this.doc = this.reader.read("  { }");
    }

    @Test
    public void shouldParseEmptyDocumentWithEmbeddedWhitespace() throws Exception {
        this.doc = this.reader.read("{ \n \t \r\n }  ");
    }

    @Test
    public void shouldParseDocumentWithSingleFieldWithStringValue() throws Exception {
        this.doc = this.reader.read("{ \"foo\" : \"bar\" }");
        this.assertField("foo", "bar");
    }

    @Test
    public void shouldParseDocumentWithSingleFieldWithBooleanFalseValue() throws Exception {
        this.doc = this.reader.read("{ \"foo\" : false }");
        this.assertField("foo", false);
    }

    @Test
    public void shouldParseDocumentWithSingleFieldWithBooleanTrueValue() throws Exception {
        this.doc = this.reader.read("{ \"foo\" : true }");
        this.assertField("foo", true);
    }

    @Test
    public void shouldParseDocumentWithSingleFieldWithIntegerValue() throws Exception {
        this.doc = this.reader.read("{ \"foo\" : 0 }");
        this.assertField("foo", 0);
    }

    @Test
    public void shouldParseDocumentWithSingleFieldWithLongValue() throws Exception {
        long val = 0x80000009L;
        this.doc = this.reader.read("{ \"foo\" : " + val + " }");
        this.assertField("foo", val);
    }

    @Test
    public void shouldParseDocumentWithSingleFieldWithDoubleValue() throws Exception {
        this.doc = this.reader.read("{ \"foo\" : 2.3543 }");
        this.assertField("foo", 2.3543);
    }

    @Test
    public void shouldParseDocumentWithMultipleFieldsAndExtraDelimiters() throws Exception {
        this.doc = this.reader.read("{ \"foo\" : 32 ,, \"nested\" : { \"bar\" : \"baz\", \"bom\" : true } ,}");
        this.assertField("foo", 32);
        this.doc = this.doc.getDocument("nested");
        this.assertField("bar", "baz");
        this.assertField("bom", true);
    }

    @Test
    public void shouldParseMultipleDocuments() throws Exception {
        Document doc;
        InputStream stream = this.getClass().getClassLoader().getResourceAsStream("json/multiple-json-files.txt");
        DocumentSequence seq = this.reader.readMultiple(stream);
        int count = 0;
        while ((doc = seq.nextDocument()) != null) {
            ++count;
        }
        Assert.assertThat((Object)count, (Matcher)Is.is((Object)265));
    }

    @Test
    @FixFor(value={"MODE-2309"})
    public void shouldParseJsonWithControlCharactersInFieldValues() throws Exception {
        InputStream stream = this.getClass().getClassLoader().getResourceAsStream("json/example-with-control-characters.json");
        this.doc = this.reader.read(stream);
        Assert.assertNotNull((Object)this.doc);
        Assert.assertEquals((long)6L, (long)this.countFields(this.doc));
        this.assertField("firstName", "Jane");
        this.assertField("lastName", "Doe");
        this.assertField("fieldWithLF", "This is a value\nwith a line feed");
        this.assertField("fieldWithCRLF", "This is a value\r\nwith a line feed\r\ncarriage return");
        this.doc = this.doc.getDocument("address");
        Assert.assertEquals((long)3L, (long)this.countFields(this.doc));
        this.assertField("street", "Main Street");
        this.assertField("city", "Memphis");
        this.assertField("zip", 12345);
    }

    @Test
    @FixFor(value={"MODE-2082"})
    public void shouldParseJsonWithComments() throws Exception {
        InputStream stream = this.getClass().getClassLoader().getResourceAsStream("json/example-with-comments.json");
        this.doc = this.reader.read(stream);
        Assert.assertNotNull((Object)this.doc);
        Assert.assertEquals((long)4L, (long)this.countFields(this.doc));
        this.assertField("firstName", "Jane");
        this.assertField("lastName", "Doe");
        this.doc = this.doc.getDocument("address");
        Assert.assertEquals((long)3L, (long)this.countFields(this.doc));
        this.assertField("street", "Main // Street");
        this.assertField("city", "Mem/ phis");
        this.assertField("zip", 12345);
    }

    @Test
    @FixFor(value={"MODE-2082"})
    public void shouldNotParseJsonWithInvalidComments() throws Exception {
        InputStream stream = this.getClass().getClassLoader().getResourceAsStream("json/invalid-example-with-comments.json");
        try {
            this.doc = this.reader.read(stream);
            Assert.fail((String)"Expected parsing exception");
        }
        catch (ParsingException e) {
            // empty catch block
        }
        stream = this.getClass().getClassLoader().getResourceAsStream("json/invalid-example-with-comments2.json");
        try {
            this.doc = this.reader.read(stream);
            Assert.fail((String)"Expected parsing exception");
        }
        catch (ParsingException parsingException) {
            // empty catch block
        }
    }

    @Test
    @FixFor(value={"MODE-2214"})
    public void shouldNotParseJsonWithInvalidArray() throws Exception {
        InputStream stream = this.getClass().getClassLoader().getResourceAsStream("json/invalid-array-repo-config-1.json");
        try {
            this.doc = this.reader.read(stream);
            Assert.fail((String)"Expected parsing exception");
        }
        catch (ParsingException e) {
            // empty catch block
        }
        stream = this.getClass().getClassLoader().getResourceAsStream("json/invalid-array-repo-config-2.json");
        try {
            this.doc = this.reader.read(stream);
            Assert.fail((String)"Expected parsing exception");
        }
        catch (ParsingException parsingException) {
            // empty catch block
        }
    }

    @Test
    @FixFor(value={"MODE-2317"})
    public void shouldParseNonUnicodeEscapeSequence() throws Exception {
        String url = "jdbc:h2:file:path\\upstream.jboss-integration.modeshape\\modeshape-jcr;DB_CLOSE_DELAY=-1";
        this.doc = this.reader.read("{ \"url\" : \"" + url + "\"}");
        this.assertField("url", url);
        InputStream stream = this.getClass().getClassLoader().getResourceAsStream("json/non-unicode-escape.json");
        this.reader.read(stream);
    }

    private int countFields(Document doc) {
        int fieldCount = 0;
        for (Document.Field field : doc.fields()) {
            Assert.assertThat((Object)field, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
            ++fieldCount;
        }
        return fieldCount;
    }

    protected void assertField(String name, Object value) {
        Object actual = this.doc.get(name);
        if (value == null) {
            Assert.assertNull((Object)actual);
        } else {
            Assert.assertEquals((Object)value, (Object)actual);
        }
    }
}

