/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.schematic.internal;

import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.modeshape.schematic.DocumentLibrary;
import org.modeshape.schematic.document.Document;

public class InMemoryDocumentLibrary
implements DocumentLibrary,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final ConcurrentMap<String, Document> documents = new ConcurrentHashMap<String, Document>();

    public InMemoryDocumentLibrary(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Document get(String key) {
        return (Document)this.documents.get(key);
    }

    @Override
    public Document put(String key, Document document) {
        return this.documents.put(key, document);
    }

    @Override
    public Document putIfAbsent(String key, Document document) {
        return this.documents.putIfAbsent(key, document);
    }

    @Override
    public Document replace(String key, Document document) {
        return this.documents.replace(key, document);
    }

    @Override
    public Document remove(String key) {
        return (Document)this.documents.remove(key);
    }
}

