/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.schematic.internal.delta;

import org.modeshape.schematic.document.Path;
import org.modeshape.schematic.internal.HashCode;
import org.modeshape.schematic.internal.delta.ArrayOperation;
import org.modeshape.schematic.internal.document.MutableArray;
import org.modeshape.schematic.internal.document.MutableDocument;

public class AddValueOperation
extends ArrayOperation {
    protected static final int APPEND_INDEX = -1;
    protected final Object value;
    protected final int index;
    protected transient int actualIndex = -1;

    public AddValueOperation(Path path, Object value) {
        super(path, HashCode.compute(path, value, -1));
        assert (value != null);
        this.value = value;
        this.index = -1;
    }

    public AddValueOperation(Path path, Object value, int index) {
        super(path, HashCode.compute(path, value, index));
        assert (value != null);
        this.value = value;
        this.index = index;
    }

    @Override
    public AddValueOperation clone() {
        return new AddValueOperation(this.getParentPath(), this.cloneValue(this.value), this.index);
    }

    public Object getValue() {
        return this.value;
    }

    public int getIndex() {
        return this.index;
    }

    public int getActualIndex() {
        return this.actualIndex;
    }

    @Override
    public void rollback(MutableDocument delegate) {
        if (this.actualIndex > -1) {
            MutableArray array = this.mutableParent(delegate);
            array.remove(this.actualIndex);
        }
    }

    @Override
    public void replay(MutableDocument delegate) {
        MutableArray array = this.mutableParent(delegate);
        if (this.index == -1) {
            this.actualIndex = array.addValue(this.value);
        } else {
            array.addValue(this.index, this.value);
            this.actualIndex = this.index;
        }
    }

    public String toString() {
        return "Add to '" + this.parentPath + "' the value '" + this.value + "'" + (this.index >= 0 ? " at index " + this.index : "");
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof AddValueOperation) {
            AddValueOperation other = (AddValueOperation)obj;
            return this.equalsIfNotNull(this.value, other.value) && this.index == other.index && this.equalsIfNotNull(this.getParentPath(), other.getParentPath());
        }
        return false;
    }
}

