/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.schematic.internal.delta;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.modeshape.schematic.annotation.Immutable;
import org.modeshape.schematic.document.Path;
import org.modeshape.schematic.internal.HashCode;
import org.modeshape.schematic.internal.delta.ArrayOperation;
import org.modeshape.schematic.internal.document.MutableArray;
import org.modeshape.schematic.internal.document.MutableDocument;

@Immutable
public class ClearOperation
extends ArrayOperation {
    private transient List<?> removedValues;

    public ClearOperation(Path path) {
        super(path, HashCode.compute(path));
    }

    @Override
    public ClearOperation clone() {
        return this;
    }

    @Override
    public void replay(MutableDocument delegate) {
        MutableArray array = this.mutableParent(delegate);
        if (!array.isEmpty()) {
            this.removedValues = new ArrayList<Object>(array);
            array.clear();
        } else {
            this.removedValues = Collections.emptyList();
        }
    }

    @Override
    public void rollback(MutableDocument delegate) {
        if (this.removedValues != null) {
            MutableArray array = this.mutableParent(delegate);
            array.clear();
            array.addAll(this.removedValues);
            this.removedValues = null;
        }
    }

    public String toString() {
        return "Clear at '" + this.parentPath + "' the existing values";
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ClearOperation) {
            ClearOperation that = (ClearOperation)obj;
            return this.equalsIfNotNull(this.getParentPath(), that.getParentPath());
        }
        return false;
    }
}

