/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.schematic.internal.delta;

import java.util.Collection;
import java.util.stream.Collectors;
import org.modeshape.schematic.annotation.Immutable;
import org.modeshape.schematic.document.Document;
import org.modeshape.schematic.document.Path;
import org.modeshape.schematic.internal.document.MutableDocument;

@Immutable
public abstract class Operation {
    protected final Path parentPath;
    private final int hashCode;

    protected Operation(Path parentPath, int hashCode) {
        this.parentPath = parentPath;
        this.hashCode = hashCode;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public abstract void replay(MutableDocument var1);

    public abstract void rollback(MutableDocument var1);

    public Path getParentPath() {
        return this.parentPath;
    }

    protected MutableDocument mutableParent(MutableDocument delegate) {
        MutableDocument parent = delegate;
        Path parentPath = this.getParentPath();
        for (String fieldName : parentPath) {
            assert (parent != null) : "Unexpected to find path " + parentPath + " in " + delegate + ". Unable to apply operation " + this;
            parent = (MutableDocument)parent.getDocument(fieldName);
        }
        return parent;
    }

    public abstract Operation clone();

    protected Object cloneValue(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Document) {
            return ((Document)value).clone();
        }
        if (value instanceof Collection) {
            Collection original = (Collection)value;
            Collection copy = original.stream().map(this::cloneValue).collect(Collectors.toList());
            return copy;
        }
        return value;
    }

    protected boolean equalsIfNotNull(Object obj1, Object obj2) {
        if (obj1 == null) {
            return obj2 == null;
        }
        return obj1.equals(obj2);
    }
}

