/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.schematic.internal.document;

import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.Date;
import java.util.Iterator;
import java.util.UUID;
import java.util.regex.Pattern;
import org.modeshape.schematic.annotation.ThreadSafe;
import org.modeshape.schematic.document.Binary;
import org.modeshape.schematic.document.Code;
import org.modeshape.schematic.document.CodeWithScope;
import org.modeshape.schematic.document.Document;
import org.modeshape.schematic.document.MaxKey;
import org.modeshape.schematic.document.MinKey;
import org.modeshape.schematic.document.Null;
import org.modeshape.schematic.document.ObjectId;
import org.modeshape.schematic.document.Symbol;
import org.modeshape.schematic.document.Timestamp;
import org.modeshape.schematic.internal.document.ArrayEditor;
import org.modeshape.schematic.internal.document.BsonUtils;
import org.modeshape.schematic.internal.document.DocumentEditor;
import org.modeshape.schematic.internal.document.IndexSequence;
import org.modeshape.schematic.internal.io.BsonDataOutput;

@ThreadSafe
public class BsonWriter {
    public void write(Object object, OutputStream stream) throws IOException {
        BsonDataOutput buffer = new BsonDataOutput();
        this.write(null, object, buffer);
        buffer.writeTo(stream);
    }

    public byte[] write(Object object) throws IOException {
        BsonDataOutput buffer = new BsonDataOutput();
        this.write(null, object, buffer);
        ByteArrayOutputStream stream = new ByteArrayOutputStream(buffer.size());
        buffer.writeTo(stream);
        return stream.toByteArray();
    }

    public void write(Object object, DataOutput output) throws IOException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        this.write(object, stream);
        stream.flush();
        byte[] bytes = stream.toByteArray();
        output.write(bytes);
    }

    protected void write(String name, Object object, BsonDataOutput output) {
        if (object == null) {
            this.writeNull(name, output);
        } else if (object instanceof String) {
            this.write(name, (String)object, output);
        } else if (object instanceof Boolean) {
            this.write(name, (Boolean)object, output);
        } else if (object instanceof Integer) {
            this.write(name, (Integer)object, output);
        } else if (object instanceof Long) {
            this.write(name, (Long)object, output);
        } else if (object instanceof Float) {
            this.write(name, ((Float)object).floatValue(), output);
        } else if (object instanceof Double) {
            this.write(name, (Double)object, output);
        } else if (object.getClass().isArray()) {
            this.writeArray(name, object, output);
        } else if (object instanceof ArrayEditor) {
            this.write(name, ((ArrayEditor)object).unwrap(), output);
        } else if (object instanceof DocumentEditor) {
            this.write(name, ((DocumentEditor)object).unwrap(), output);
        } else if (object instanceof Iterable) {
            this.write(name, (Iterable)object, output);
        } else if (object instanceof Document) {
            this.write(name, (Document)object, output);
        } else if (object instanceof Binary) {
            this.write(name, (Binary)object, output);
        } else if (object instanceof Symbol) {
            this.write(name, (Symbol)object, output);
        } else if (object instanceof Pattern) {
            this.write(name, (Pattern)object, output);
        } else if (object instanceof Date) {
            this.write(name, (Date)object, output);
        } else if (object instanceof UUID) {
            this.write(name, (UUID)object, output);
        } else if (object instanceof CodeWithScope) {
            this.write(name, (CodeWithScope)object, output);
        } else if (object instanceof Code) {
            this.write(name, (Code)object, output);
        } else if (object instanceof Timestamp) {
            this.write(name, (Timestamp)object, output);
        } else if (object instanceof ObjectId) {
            this.write(name, (ObjectId)object, output);
        } else if (object instanceof MaxKey) {
            this.write(name, (MaxKey)object, output);
        } else if (object instanceof MinKey) {
            this.write(name, (MinKey)object, output);
        } else if (object instanceof Null) {
            this.writeNull(name, output);
        } else {
            throw new RuntimeException("Unable to serialize type '" + object.getClass() + "\" to BSON");
        }
    }

    protected void writeCString(String value, BsonDataOutput output) {
        output.writeUTFString(value);
        output.writeByte(0);
    }

    protected void writeString(String value, BsonDataOutput output) {
        int position = output.size();
        output.writeInt(0);
        int len = output.writeUTFString(value);
        output.writeByte(0);
        assert (len + 1 >= 0);
        output.writeInt(position, len + 1);
    }

    protected void writeNull(String name, BsonDataOutput output) {
        output.writeByte(10);
        this.writeCString(name, output);
    }

    protected void write(String name, String value, BsonDataOutput output) {
        output.writeByte(2);
        this.writeCString(name, output);
        this.writeString(value, output);
    }

    protected void write(String name, boolean value, BsonDataOutput output) {
        output.writeByte(8);
        this.writeCString(name, output);
        output.writeByte(value ? 1 : 0);
    }

    protected void write(String name, int value, BsonDataOutput output) {
        output.writeByte(16);
        this.writeCString(name, output);
        output.writeInt(value);
    }

    protected void write(String name, long value, BsonDataOutput output) {
        output.writeByte(18);
        this.writeCString(name, output);
        output.writeLong(value);
    }

    protected void write(String name, float value, BsonDataOutput output) {
        output.writeByte(1);
        this.writeCString(name, output);
        output.writeDouble(value);
    }

    protected void write(String name, double value, BsonDataOutput output) {
        output.writeByte(1);
        this.writeCString(name, output);
        output.writeDouble(value);
    }

    protected void writeArray(String name, Object arrayValue, BsonDataOutput output) {
        if (name != null) {
            output.writeByte(4);
            this.writeCString(name, output);
        }
        int arraySizePosition = output.size();
        output.writeInt(0);
        int length = Array.getLength(arrayValue);
        Iterator<String> indexIter = IndexSequence.infiniteSequence();
        for (int i = 0; i != length; ++i) {
            String elementName = indexIter.next();
            Object value = Array.get(arrayValue, i);
            this.write(elementName, value, output);
        }
        output.writeByte(0);
        int arraySize = output.size() - arraySizePosition;
        output.writeInt(arraySizePosition, arraySize);
    }

    protected void write(String name, Iterable<?> arrayValue, BsonDataOutput output) {
        if (name != null) {
            output.writeByte(4);
            this.writeCString(name, output);
        }
        int arraySizePosition = output.size();
        output.writeInt(0);
        Iterator<String> indexIter = IndexSequence.infiniteSequence();
        Iterator<?> valueIter = arrayValue.iterator();
        while (valueIter.hasNext()) {
            String elementName = indexIter.next();
            Object value = valueIter.next();
            this.write(elementName, value, output);
        }
        output.writeByte(0);
        int arraySize = output.size() - arraySizePosition;
        output.writeInt(arraySizePosition, arraySize);
    }

    protected void write(String name, Document document, BsonDataOutput output) {
        if (name != null) {
            output.writeByte(3);
            this.writeCString(name, output);
        }
        int arraySizePosition = output.size();
        output.writeInt(-1);
        for (Document.Field field : document.fields()) {
            this.write(field.getName(), field.getValue(), output);
        }
        output.writeByte(0);
        int arraySize = output.size() - arraySizePosition;
        output.writeInt(arraySizePosition, arraySize);
    }

    protected void write(String name, Binary value, BsonDataOutput output) {
        output.writeByte(5);
        this.writeCString(name, output);
        byte[] bytes = value.getBytes();
        output.writeInt(bytes.length);
        output.writeByte(value.getType());
        output.write(bytes);
    }

    protected void write(String name, Symbol value, BsonDataOutput output) {
        output.writeByte(14);
        this.writeCString(name, output);
        this.writeString(value.getSymbol(), output);
    }

    protected void write(String name, Pattern value, BsonDataOutput output) {
        output.writeByte(11);
        this.writeCString(name, output);
        this.writeCString(value.pattern(), output);
        this.writeCString(BsonUtils.regexFlagsFor(value), output);
    }

    protected void write(String name, Date value, BsonDataOutput output) {
        output.writeByte(9);
        this.writeCString(name, output);
        output.writeLong(value.getTime());
    }

    protected void write(String name, UUID value, BsonDataOutput output) {
        output.writeByte(5);
        this.writeCString(name, output);
        output.writeInt(16);
        output.writeByte(3);
        output.writeLong(value.getMostSignificantBits());
        output.writeLong(value.getLeastSignificantBits());
    }

    protected void write(String name, CodeWithScope value, BsonDataOutput output) {
        output.writeByte(15);
        this.writeCString(name, output);
        int arraySizePosition = output.size();
        output.writeInt(0);
        this.writeString(value.getCode(), output);
        this.write(null, value.getScope(), output);
        int arraySize = output.size() - arraySizePosition;
        output.writeInt(arraySizePosition, arraySize);
    }

    protected void write(String name, Code value, BsonDataOutput output) {
        output.writeByte(13);
        this.writeCString(name, output);
        this.writeString(value.getCode(), output);
    }

    protected void write(String name, Timestamp value, BsonDataOutput output) {
        output.writeByte(17);
        this.writeCString(name, output);
        output.writeInt(value.getInc());
        output.writeInt(value.getTime());
    }

    protected void write(String name, ObjectId value, BsonDataOutput output) {
        output.writeByte(7);
        this.writeCString(name, output);
        output.write(value.getBytes());
    }

    protected void write(String name, MaxKey value, BsonDataOutput output) {
        output.writeByte(127);
        this.writeCString(name, output);
    }

    protected void write(String name, MinKey value, BsonDataOutput output) {
        output.writeByte(-1);
        this.writeCString(name, output);
    }
}

