/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.schematic.internal.document;

import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Array;
import java.util.Iterator;
import org.modeshape.schematic.document.Document;
import org.modeshape.schematic.internal.document.CompactJsonWriter;

public class PrettyJsonWriter
extends CompactJsonWriter {
    private static final int MAX_CACHED_INDENTS = 10;
    private static final String[] CACHED_INDENTS = new String[10];
    private int depth = 0;

    @Override
    protected void write(Document bson, Writer writer) throws IOException {
        if (bson.size() == 0) {
            writer.append("{ }");
            return;
        }
        ++this.depth;
        writer.append('{').append('\n');
        this.indent(writer);
        Iterator<Document.Field> iter = bson.fields().iterator();
        if (iter.hasNext()) {
            this.write(iter.next(), writer);
            while (iter.hasNext()) {
                writer.append(',').append('\n');
                this.indent(writer);
                this.write(iter.next(), writer);
            }
        }
        writer.append('\n');
        --this.depth;
        this.indent(writer);
        writer.append('}');
    }

    @Override
    protected void write(Iterable<?> arrayValue, Writer writer) throws IOException {
        ++this.depth;
        writer.append('[');
        boolean first = true;
        for (Object value : arrayValue) {
            if (first) {
                first = false;
                writer.append('\n');
                this.indent(writer);
            } else {
                writer.append(',').append('\n');
                this.indent(writer);
            }
            this.write(value, writer);
        }
        --this.depth;
        if (first) {
            writer.append(' ');
        } else {
            writer.append('\n');
            this.indent(writer);
        }
        writer.append(']');
    }

    @Override
    protected void writeArray(Object array, Writer writer) throws IOException {
        int len = Array.getLength(array);
        if (len == 0) {
            writer.append("[ ]");
            return;
        }
        ++this.depth;
        writer.append('[').append('\n');
        this.indent(writer);
        for (int i = 0; i < len; ++i) {
            if (i > 0) {
                writer.append(',').append('\n');
                this.indent(writer);
            }
            this.write(Array.get(array, i), writer);
        }
        writer.append('\n');
        --this.depth;
        this.indent(writer);
        writer.append(']');
    }

    protected void indent(Writer writer) throws IOException {
        if (this.depth == 0) {
            return;
        }
        if (this.depth < 10) {
            writer.append(CACHED_INDENTS[this.depth]);
        } else {
            for (int i = 0; i != this.depth; ++i) {
                writer.append(' ').append(' ');
            }
        }
    }

    static {
        PrettyJsonWriter.CACHED_INDENTS[0] = "";
        StringBuilder sb = new StringBuilder();
        for (int i = 1; i != 10; ++i) {
            sb.append(' ').append(' ');
            PrettyJsonWriter.CACHED_INDENTS[i] = sb.toString();
        }
    }
}

