/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.schematic.internal.document;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.schematic.document.Array;
import org.modeshape.schematic.document.Document;
import org.modeshape.schematic.internal.document.BasicArray;
import org.modeshape.schematic.internal.document.BasicDocument;

public class BasicDocumentTest {
    private BasicDocument doc;

    @Before
    public void beforeTest() {
        this.doc = new BasicDocument();
        this.doc.put((Object)"foo", (Object)"value for foo");
        this.doc.put((Object)"bar", (Object)"value for bar");
        this.doc.put((Object)"baz", (Object)new BasicDocument("key1", (Object)"value1", "key2", (Object)"value2"));
        this.doc.put((Object)"bom", (Object)new BasicArray(new Object[]{"v1", "v2", "v3", new BasicDocument("v4-Key", (Object)"v4-value")}));
    }

    @Test
    public void shouldBeCloneable() {
        this.assertEquals((Document)this.doc, (Document)this.doc.clone());
    }

    protected void assertEquals(Document doc1, Document doc2) {
        Assert.assertTrue((doc1 != doc2 ? 1 : 0) != 0);
        Assert.assertEquals((Object)doc1, (Object)doc2);
        for (Document.Field field : doc1.fields()) {
            Object value2 = doc2.get(field.getName());
            Assert.assertEquals((Object)value2, (Object)field.getValue());
            if (value2 instanceof Array) {
                Assert.assertTrue((value2 != field.getValue() ? 1 : 0) != 0);
                this.assertEquals((Array)field.getValue(), (Array)value2);
                continue;
            }
            if (!(value2 instanceof Document)) continue;
            Assert.assertTrue((value2 != field.getValue() ? 1 : 0) != 0);
            this.assertEquals(field.getValueAsDocument(), (Document)value2);
        }
    }

    protected void assertEquals(Array array1, Array array2) {
        Assert.assertTrue((array1 != array2 ? 1 : 0) != 0);
        Assert.assertEquals((Object)array1, (Object)array2);
        for (int i = 0; i != array1.size(); ++i) {
            Object value1 = array1.get(i);
            Object value2 = array2.get(i);
            Assert.assertEquals((Object)value1, (Object)value2);
            if (value2 instanceof Array) {
                Assert.assertTrue((value1 != value2 ? 1 : 0) != 0);
                this.assertEquals((Array)value1, (Array)value2);
                continue;
            }
            if (!(value2 instanceof Document)) continue;
            Assert.assertTrue((value1 != value2 ? 1 : 0) != 0);
            this.assertEquals((Document)value1, (Document)value2);
        }
    }
}

