/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.schematic.internal;

import org.modeshape.schematic.DocumentLibrary;
import org.modeshape.schematic.SchemaLibrary;
import org.modeshape.schematic.document.Document;
import org.modeshape.schematic.internal.InMemoryDocumentLibrary;
import org.modeshape.schematic.internal.document.Paths;
import org.modeshape.schematic.internal.schema.DocumentTransformer;
import org.modeshape.schematic.internal.schema.SchemaDocument;
import org.modeshape.schematic.internal.schema.SchemaDocumentCache;
import org.modeshape.schematic.internal.schema.ValidationResult;

public class InMemorySchemaLibrary
implements SchemaLibrary {
    private final DocumentLibrary documents;
    private final SchemaDocumentCache schemaDocuments;

    public InMemorySchemaLibrary(String name) {
        this.documents = new InMemoryDocumentLibrary(name);
        this.schemaDocuments = new SchemaDocumentCache(this, null);
    }

    @Override
    public String getName() {
        return this.documents.getName();
    }

    @Override
    public Document get(String key) {
        return this.documents.get(key);
    }

    @Override
    public Document put(String key, Document document) {
        Document result = this.documents.put(key, document);
        this.schemaDocuments.remove(key);
        return result;
    }

    @Override
    public Document putIfAbsent(String key, Document document) {
        Document result = this.documents.putIfAbsent(key, document);
        this.schemaDocuments.remove(key);
        return result;
    }

    @Override
    public Document replace(String key, Document document) {
        Document result = this.documents.replace(key, document);
        this.schemaDocuments.remove(key);
        return result;
    }

    @Override
    public Document remove(String key) {
        Document result = this.documents.remove(key);
        this.schemaDocuments.remove(key);
        return result;
    }

    @Override
    public SchemaLibrary.Results validate(Document document, String schemaUri) {
        ValidationResult result = new ValidationResult();
        SchemaDocument schema = this.schemaDocuments.get(schemaUri, result);
        if (schema != null) {
            schema.getValidator().validate(null, null, document, Paths.rootPath(), result, this.schemaDocuments);
        }
        return result;
    }

    @Override
    public Document convertValues(Document document, SchemaLibrary.Results results) {
        return DocumentTransformer.convertValuesWithMismatchedTypes(document, results);
    }

    @Override
    public Document convertValues(Document document, String schemaUri) {
        SchemaLibrary.Results results = this.validate(document, schemaUri);
        return this.convertValues(document, results);
    }
}

